/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FOLLOWINGSIBLINGAXIS_HPP
#define _FOLLOWINGSIBLINGAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/ForwardAxis.hpp>

class PATHAN_EXPORT FollowingSiblingAxis : public ForwardAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;

  class FollowingSiblingAxisResult : public NavStepImpl::AxisResult
  {
  public:
    FollowingSiblingAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node_;
  };
};

#endif

