/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FOLLOWINGAXIS_HPP
#define _FOLLOWINGAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/ForwardAxis.hpp>

class PATHAN_EXPORT FollowingAxis : public ForwardAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;

  class FollowingAxisResult : public NavStepImpl::AxisResult
  {
  public:
    FollowingAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node_;
  };
};


#endif

