/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _DESCENDANTORSELFAXIS_HPP
#define _DESCENDANTORSELFAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/ForwardAxis.hpp>

class DynamicContext;

class PATHAN_EXPORT DescendantOrSelfAxis : public ForwardAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;

  class DescendantOrSelfAxisResult : public NavStepImpl::AxisResult
  {
  public:
    DescendantOrSelfAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *descendant_;
  };
};


#endif

