/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _CHILDAXIS_HPP
#define _CHILDAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/ForwardAxis.hpp>
/**
This class implements the ChildAxis axis as defined by the XPath spec
*/


class PATHAN_EXPORT ChildAxis : public ForwardAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;

  class ChildAxisResult : public NavStepImpl::AxisResult
  {
  public:
    ChildAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *child_;
  };
};


#endif

