/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _ATTRIBUTEAXIS_HPP
#define _ATTRIBUTEAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/ForwardAxis.hpp>
#include <xercesc/dom/DOMNamedNodeMap.hpp>

/**
This class implements the AttributeAxis axis as defined by the XPath spec
*/

class PATHAN_EXPORT AttributeAxis : public ForwardAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;  

  class AttributeAxisResult : public NavStepImpl::AxisResult
  {
  public:
    AttributeAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNamedNodeMap *nodeMap_;
    unsigned int i_;
  };
};


#endif

