/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _ANCESTORORSELFAXIS_HPP
#define _ANCESTORORSELFAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/AncestorAxis.hpp>

/**
This class implements the AncestorOrSelf axis as defined by the XPath spec
*/

class PATHAN_EXPORT AncestorOrSelfAxis : public ReverseAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;

  class AncestorOrSelfAxisResult : public NavStepImpl::AxisResult
  {
  public:
    AncestorOrSelfAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *ancestor_;
  };
};


#endif

