/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _ANCESTORAXIS_HPP
#define _ANCESTORAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/ReverseAxis.hpp>

/**
This class implements the AncestorAxis as defined in the XPath spec
*/

class PATHAN_EXPORT AncestorAxis : public ReverseAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;

  class AncestorAxisResult : public NavStepImpl::AxisResult
  {
  public:
    AncestorAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *ancestor_;
  };
};

#endif

