/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/*
  Factory base class
*/

#ifndef _DATATYPEFACTORY_HPP
#define _DATATYPEFACTORY_HPP

#include <pathan/Pathan.hpp>
#include <pathan/internal/m_apm.h>
#include "../../ATAnySimpleType.hpp"
#include "../../ATAnyURIOrDerived.hpp"
#include "../../ATBase64BinaryOrDerived.hpp"
#include "../../ATBooleanOrDerived.hpp"
#include "../../ATDateOrDerived.hpp"
#include "../../ATDateTimeOrDerived.hpp"
#include "../../ATDecimalOrDerived.hpp"
#include "../../ATDoubleOrDerived.hpp"
#include "../../ATDurationOrDerived.hpp"
#include "../../ATFloatOrDerived.hpp"
#include "../../ATGDayOrDerived.hpp"
#include "../../ATGMonthOrDerived.hpp"
#include "../../ATGMonthDayOrDerived.hpp"
#include "../../ATGYearMonthOrDerived.hpp"
#include "../../ATGYearOrDerived.hpp"
#include "../../ATHexBinaryOrDerived.hpp"
#include "../../ATNotationOrDerived.hpp"
#include "../../ATQNameOrDerived.hpp"
#include "../../ATStringOrDerived.hpp"
#include "../../ATTimeOrDerived.hpp"
#include "../../ATUntypedAtomic.hpp"
#include "../../Node.hpp"

class StaticContext;
class XPath2MemoryManager;
class DocumentCache;

class PATHAN_EXPORT DatatypeFactory
{
public:
  DatatypeFactory(const DocumentCache* dc);
  virtual ~DatatypeFactory();

  ///Create instance of a datatype, using DatatypeFactoryTemplate to determine type
  AnyAtomicType::Ptr createInstance(const XMLCh* typeURI,
                                    const XMLCh* typeName,
                                    const XMLCh* value,
                                    const StaticContext* context) const;

  bool checkInstance(const XMLCh* typeURI,
                     const XMLCh* typeName,
                     const XMLCh* value,
                     const StaticContext* context) const;

  ///Create instance of a datatype, using DatatypeFactoryTemplate to determine type
  virtual AnyAtomicType::Ptr createInstanceNoCheck(const XMLCh* typeURI,
                                                   const XMLCh* typeName,
                                                   const XMLCh* value,
                                                   const StaticContext* context) const = 0;

  virtual AnyAtomicType::AtomicObjectType getPrimitiveTypeIndex() const = 0;

  virtual const XMLCh* getPrimitiveTypeName() const = 0;
  //virtual const XMLCh* getPrimitiveTypeURI() const;

  class PATHAN_EXPORT POD2AT
  {
  public:
    static Node::Ptr createNode(const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node, const DynamicContext *context);
    static ATDoubleOrDerived::Ptr createDouble(const MAPM value, const StaticContext* context);
    static ATFloatOrDerived::Ptr createFloat(const MAPM value, const StaticContext* context);
    static ATDecimalOrDerived::Ptr createInteger(const int value, const StaticContext* context);
    static ATDecimalOrDerived::Ptr createInteger(const MAPM value, const StaticContext* context);
    static ATDecimalOrDerived::Ptr createDecimal(const MAPM value, const StaticContext* context);
    static ATDecimalOrDerived::Ptr createNonNegativeInteger(const MAPM value, const StaticContext* context);
    static ATDecimalOrDerived::Ptr createDecimalOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const MAPM value, const StaticContext* context);
    static ATDoubleOrDerived::Ptr createDoubleOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const MAPM value, const StaticContext* context);
    static ATFloatOrDerived::Ptr createFloatOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const MAPM value, const StaticContext* context);
    static ATBooleanOrDerived::Ptr createBoolean(bool value, const StaticContext* context);

    static ATBooleanOrDerived::Ptr createBooleanOrDerived(const XMLCh* typeURI, const XMLCh* typeName, bool value, const StaticContext* context);
  };

  class PATHAN_EXPORT STR2AT
  {
  public:
    static ATDoubleOrDerived::Ptr createDouble(const XMLCh* value, const StaticContext* context);
    static ATFloatOrDerived::Ptr createFloat(const XMLCh* value, const StaticContext* context);
    static ATDecimalOrDerived::Ptr createInteger(const XMLCh* value, const StaticContext* context);
    static ATDecimalOrDerived::Ptr createDecimal(const XMLCh* value, const StaticContext* context);
    static ATBooleanOrDerived::Ptr createBoolean(const XMLCh* value, const StaticContext* context);
    static ATDateOrDerived::Ptr createDate(const XMLCh* value, const StaticContext* context);
    static ATDateTimeOrDerived::Ptr createDateTime(const XMLCh* value, const StaticContext* context);
    static ATTimeOrDerived::Ptr createTime(const XMLCh* value, const StaticContext* context);
    static ATDurationOrDerived::Ptr createDayTimeDuration(const XMLCh* value, const StaticContext* context);
    static ATDurationOrDerived::Ptr createYearMonthDuration(const XMLCh* value, const StaticContext* context);
    static ATAnyURIOrDerived::Ptr createAnyURI(const XMLCh* value, const StaticContext* context);
    static ATQNameOrDerived::Ptr createQName(const XMLCh* uri, const XMLCh* name, const StaticContext* context);
    static ATQNameOrDerived::Ptr createQName(const XMLCh* value, const StaticContext* context);
    static ATStringOrDerived::Ptr createString(const XMLCh* value, const StaticContext* context);
    static ATBase64BinaryOrDerived::Ptr createBase64Binary(const XMLCh* value, const StaticContext* context);
    static ATHexBinaryOrDerived::Ptr createHexBinary(const XMLCh* value, const StaticContext* context);
    static AnyAtomicType::Ptr createDerivedFromAtomicType(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);

    static ATAnySimpleType::Ptr createAnySimpleType(const XMLCh* value, const StaticContext* context);
    static ATAnyURIOrDerived::Ptr createAnyURIOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context); 
    static ATBase64BinaryOrDerived::Ptr createBase64BinaryOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATBooleanOrDerived::Ptr createBooleanOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATDateOrDerived::Ptr createDateOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATDateTimeOrDerived::Ptr createDateTimeOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATDecimalOrDerived::Ptr createDecimalOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATDoubleOrDerived::Ptr createDoubleOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATDurationOrDerived::Ptr createDurationOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATFloatOrDerived::Ptr createFloatOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATGDayOrDerived::Ptr createGDayOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);  
    static ATGMonthDayOrDerived::Ptr createGMonthDayOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATGMonthOrDerived::Ptr createGMonthOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATGYearMonthOrDerived::Ptr createGYearMonthOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATGYearOrDerived::Ptr createGYearOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATHexBinaryOrDerived::Ptr createHexBinaryOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATNotationOrDerived::Ptr createDerivedFromNotation(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATQNameOrDerived::Ptr createQNameOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATQNameOrDerived::Ptr createQNameOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* uri, const XMLCh* name, const StaticContext* context);
    static ATStringOrDerived::Ptr createStringOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATTimeOrDerived::Ptr createTimeOrDerived(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context);
    static ATUntypedAtomic::Ptr createUntypedAtomic(const XMLCh* value, const StaticContext* context);
  };

private:
  const DocumentCache *fDocumentCache;
};

#endif  // DATATYPEFACTORY

