/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONZEROORONE_HPP
#define _FUNCTIONZEROORONE_HPP

#include <pathan/Pathan.hpp>

#include <pathan/functionAPI/ConstantFoldingFunction.hpp>

class PATHAN_EXPORT FunctionZeroOrOne : public ConstantFoldingFunction
{
public:
  static const XMLCh name[];

  FunctionZeroOrOne(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);
  
  Result createResult(DynamicContext* context, int flags=0) const;

private:
  class ZeroOrOneResult : public ResultImpl
  {
  public:
    ZeroOrOneResult(const FunctionZeroOrOne *func, int flags, DynamicContext *context);

    Item::Ptr next(DynamicContext *context);
    std::string asString(DynamicContext *context, int indent) const;
  private:
    int _flags;
    const FunctionZeroOrOne *_func;
    Result _arg;
    unsigned int _argNo;
  };
};

#endif // _FUNCTIONZEROORONE_HPP
