/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONGETYEARSFROMYEARMONTHDURATION_HPP
#define _FUNCTIONGETYEARSFROMYEARMONTHDURATION_HPP

#include <pathan/Pathan.hpp>

#include <pathan/functionAPI/ConstantFoldingFunction.hpp>

/**
 * Getter function for the years component of yearMonthDuration
 *
 *  years-from-duration(yearMonthDuration? $srcval) => integer?
 */
class PATHAN_EXPORT FunctionYearsFromDuration : public ConstantFoldingFunction
{
public:
  static const XMLCh name[];


  /**
   * Constructor.
   */
  FunctionYearsFromDuration(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);

  /**
   * Returns an integer representing the years component in the value of 
   * $srcval
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;
};

#endif // _FUNCTIONGETYEARSFROMYEARMONTHDURATION_HPP



