/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONGETYEARFROMDATETIME_HPP
#define _FUNCTIONGETYEARFROMDATETIME_HPP

#include <pathan/Pathan.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>

/**
 * Getter function for the year component of dateTime.
 *
 * year-from-dateTime(dateTime $srcval) => integer
 */
class PATHAN_EXPORT FunctionYearFromDateTime : public DataItemFunction
{
public:
  static const XMLCh name[];


  /**
   * Constructor.
   */
  FunctionYearFromDateTime(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);

  DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  /**
   * Returns an integer representing the year component in the value of 
   * $srcval.
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;
};

#endif // _FUNCTIONGETYEARFROMDATETIME_HPP



