/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONGETTIMEZONEFROMTIME_HPP
#define _FUNCTIONGETTIMEZONEFROMTIME_HPP

#include <pathan/Pathan.hpp>

#include <pathan/functionAPI/ConstantFoldingFunction.hpp>

/**
 * Getter function for timezone component of time.
 *
 * xf:timezone-from-time(time? $srcval) => xdt:dayTimeDuration?
 */
class PATHAN_EXPORT FunctionTimezoneFromTime : public ConstantFoldingFunction
{
public:
  static const XMLCh name[];


  /**
   * Constructor
   */
  FunctionTimezoneFromTime(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);

  /**
   * Returns the string representing the timezone in the value of $srcval
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;
};

#endif // _FUNCTIONGETTIMEZONEFROMTIME_HPP



