/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/*

  String function

*/

#ifndef _FUNCTIONSTRING_HPP
#define _FUNCTIONSTRING_HPP

#include <pathan/Pathan.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>

/** String operator function. */
class PATHAN_EXPORT FunctionString : public DataItemFunction
{
public:
  static const XMLCh name[];

  FunctionString(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);
  
  /**
   * Called during static analysis to determine if statically correct.
   * Performs constant folding if the function has an argument, and it
   * is constant.
   */
  virtual DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  /** Returns the argument as a String **/
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;

  static Item::Ptr string(const Item::Ptr &item, DynamicContext *context);
};

#endif // _FUNCTIONSTRING_HPP
