/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONGETSECONDSFROMTIME_HPP
#define _FUNCTIONGETSECONDSFROMTIME_HPP

#include <pathan/Pathan.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>

/**
 * Getter function for seconds component of time.
 *
 * xf:seconds-from-time(time? $srcval) => decimal?
 */
class PATHAN_EXPORT FunctionSecondsFromTime : public DataItemFunction
{
public:
  static const XMLCh name[];


  /**
   * Constructor
   */
  FunctionSecondsFromTime(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);

  DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  /**
   * Returns the integer representing the seconds in the value of $srcval
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;
};

#endif // _FUNCTIONGETSECONDSFROMTIME_HPP



