/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/*

  normalize-space function

*/

#ifndef _FUNCTIONNORMALIZESPACE_HPP
#define _FUNCTIONNORMALIZESPACE_HPP

#include <pathan/Pathan.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>

/** normalize-space function. */
class PATHAN_EXPORT FunctionNormalizeSpace : public DataItemFunction
{
public:
  static const XMLCh name[];

  FunctionNormalizeSpace(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);
  
  /**
   * Called during static analysis to determine if statically correct.
   * Performs constant folding if the function has an argument, and it
   * is constant.
   */
  virtual DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;

private:
  const XMLCh* getString(DynamicContext* context) const;
};

#endif // _FUNCTIONNORMALIZESPACE_HPP

