/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONGETMONTHFROMDATE_HPP
#define _FUNCTIONGETMONTHFROMDATE_HPP

#include <pathan/Pathan.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>

/**
 * Gettter function for month component of date.
 *
 * xf:month-from-date(date $srcval) => integer
 */
class PATHAN_EXPORT FunctionMonthFromDate : public DataItemFunction
{
public:
  static const XMLCh name[];


  /**
   * Constructor
   */
  FunctionMonthFromDate(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);

  DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  /**
   * Returns the integer representing the month in the value of $srcval
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;
};

#endif // _FUNCTIONGETMONTHFROMDATE_HPP



