/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONGETMINUTESFROMDATETIME_HPP
#define _FUNCTIONGETMINUTESFROMDATETIME_HPP

#include <pathan/Pathan.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>

/**
 * Getter function for the minutes component of dateTime.
 *
 *  minutes-from-dateTime(dateTime $srcval) => integer
 */
class PATHAN_EXPORT FunctionMinutesFromDateTime : public DataItemFunction
{
public:
  static const XMLCh name[];


  /**
   * Constructor.
   */
  FunctionMinutesFromDateTime(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);

  DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  /**
   * Returns an integer representing the minutes component in the value
   * of $srcval.
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;
};

#endif // _FUNCTIONGETMINUTESFROMDATETIME_HPP



