/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/*
  in-scope-prefixes function
*/

#ifndef _FUNCTIONGETINSCOPEPREFIXES_HPP
#define _FUNCTIONGETINSCOPEPREFIXES_HPP

#include <pathan/Pathan.hpp>
#include <pathan/functionAPI/ConstantFoldingFunction.hpp>
#include <pathan/internal/DOMutils/XMLChCompare.hpp>
#include <xercesc/util/XercesDefs.hpp>
#include <set>

XERCES_CPP_NAMESPACE_BEGIN
class DOMNode;
XERCES_CPP_NAMESPACE_END

class PATHAN_EXPORT FunctionInScopePrefixes : public ConstantFoldingFunction
{
public:
    static const XMLCh name[];

    FunctionInScopePrefixes(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);
  
    /** Returns the getinscopenamespaces to the right of parm2 until optional parm3 from string parm1 **/
    Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;

private:
  
    typedef std::set<const XMLCh *, XMLChSort> XMLChSet;  
    void addBindings(Sequence &s, const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node, XMLChSet &ps, const DynamicContext* context) const;
};


#endif // _FUNCTIONGETINSCOPEPREFIXES_HPP





