/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONIDREF_HPP
#define _FUNCTIONIDREF_HPP

#include <pathan/Pathan.hpp>
#include <xercesc/dom/DOMNodeFilter.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>
#include <pathan/Sequence.hpp>
#include <vector>

/** 
 * Function idref
 * 
 * fn:idref(string* $srcval) => element*
 *
 */
class PATHAN_EXPORT FunctionIdref : public DataItemFunction
{
public:
  static const XMLCh name[];

  /**
   * Constructor
   */
  FunctionIdref(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);
  
  virtual DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  /** 
   * Returns the sequence of elements nodes having either an IDREF attribute 
   * whose value matches the value of one of the items in the value of $srcval 
   * or an IDREFS attribute whose value contains an IDREF value that matches 
   * the value of one of the items in the value of $srcval. 
   *
   * This function allows reverse navigation from IDs to IDREFs.
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;

private:
  //This DOMNodeFilter will ensure that only the 
  class IdrefNodeFilter : public XERCES_CPP_NAMESPACE_QUALIFIER DOMNodeFilter{
    
    public:
      IdrefNodeFilter(std::vector<const XMLCh*> list);
      short acceptNode (const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode * node) const;

    private:
		std::vector<const XMLCh*> _values;
  };

};

#endif // _FUNCTIONIDREF_HPP

