/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONID_HPP
#define _FUNCTIONID_HPP

#include <pathan/Pathan.hpp>
#include <xercesc/dom/DOMNodeFilter.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>
#include <pathan/Sequence.hpp>
#include <vector>

/** 
 * Id function 
 *
 * fn:id(string* $srcval) => element*
 */
class PATHAN_EXPORT FunctionId : public DataItemFunction
{
public:
  static const XMLCh name[];

  /**
   * Constructor.
   */
  FunctionId(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);
  
  virtual DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  /** 
   * Returns the sequence of element nodes with ID values matching the value 
   * of one of the IDREF values supplied in $srcval. 
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;

private:
  /* This DOMNodeFilter will ensure that only the elements with ID values matching the value 
   * of one or more of the IDREF values supplied is iterated over.*/
  class IdNodeFilter : public XERCES_CPP_NAMESPACE_QUALIFIER DOMNodeFilter{
    
  public:
    IdNodeFilter(std::vector<const XMLCh*> list);
    short acceptNode (const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode * node) const;
    
  private:
    std::vector<const XMLCh*> _values;
    std::vector<const XMLCh*> _returnedVals;
  };
  
};

#endif // _FUNCTIONID_HPP

