/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _FUNCTIONGETHOURSFROMDATETIME_HPP
#define _FUNCTIONGETHOURSFROMDATETIME_HPP

#include <pathan/Pathan.hpp>

#include <pathan/dataItem/DataItemFunction.hpp>

/**
 * Getter for the hours component of dateTime
 *
 * hours-from-dateTime(dateTime $srcval) => integer
 */
class PATHAN_EXPORT FunctionHoursFromDateTime : public DataItemFunction
{
public:
  static const XMLCh name[];


  /**
   * Constructor.
   */
  FunctionHoursFromDateTime(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);

  DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);

  /**
   * Returns an integer representing the hours component in the value of
   * $srcval.
   */
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;
};

#endif // _FUNCTIONGETHOURSFROMDATETIME_HPP



