/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/*

  Distinct-values function
  
*/

#ifndef _FUNCTIONDISTINCTVALUES_HPP
#define _FUNCTIONDISTINCTVALUES_HPP

#include <pathan/Pathan.hpp>

#include <pathan/functionAPI/ConstantFoldingFunction.hpp>

// Distinct values is not really an aggregate function, but since its behaviour is so
// similar (in terms of sequence validation) we will extend from it.
class PATHAN_EXPORT FunctionDistinctValues : public ConstantFoldingFunction
{
public:
  static const XMLCh name[];

  FunctionDistinctValues(const VectorOfDataItems &args, XPath2MemoryManager* memMgr);
  
  Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;

private:  
  Sequence validateSequence(Sequence sequence, DynamicContext* context) const;
  // is the type specified by the given URI/Name pair a numeric one?
  bool isNumericType(const XMLCh* typeURI, const XMLCh* typeName, const DynamicContext* context) const;
};

#endif // _FUNCTIONDISTINCTVALUES_HPP
