/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/**
 * xs:TYP(item $srcval) => TYP 
**/

#ifndef _FUNCTIONCONSTRUCTOR_HPP
#define _FUNCTIONCONSTRUCTOR_HPP

#include <pathan/Pathan.hpp>

#include <pathan/functionAPI/ConstantFoldingFunction.hpp>
#include <pathan/internal/factory/FuncFactory.hpp>

#include <xercesc/util/XercesDefs.hpp>


class PATHAN_EXPORT FunctionConstructor : public ConstantFoldingFunction
{
public:
  ///Constructor. Sets arg def to NOT_OPTIONAL.
  FunctionConstructor(const XMLCh* nsURI, const XMLCh* typeName, const VectorOfDataItems &args, XPath2MemoryManager* memMgr);
  
  virtual Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;

  static const XMLCh XMLChConstructorURI[];
  static const XMLCh XMLChXPath2DatatypesURI[];
};


class ConstructorFactory : public FuncFactory
{
public:

  ConstructorFactory(const XMLCh* uri, const XMLCh* type)
  {
	  _uri=uri;
	  _type=type;
  };

  DataItem *createInstance(const VectorOfDataItems &args, XPath2MemoryManager* memMgr) const
  {
	  return new FunctionConstructor(_uri,_type,args,memMgr);
  };

  const XMLCh *getName() const
  {
    return _type;
  }

  const XMLCh *getURI() const
  {
    return _uri;
  }

protected:
  const XMLCh *_uri;
  const XMLCh *_type;
};


#endif // _FUNCTIONCONSTRUCTOR_HPP
