/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _DATATYPELOOKUP_HPP
#define _DATATYPELOOKUP_HPP

#include <pathan/Pathan.hpp>
#include <xercesc/util/XercesDefs.hpp>
#include <xercesc/util/RefHashTableOf.hpp>

class DatatypeFactory;
class DocumentCache;
class XPath2MemoryManager;

class PATHAN_EXPORT DatatypeLookup
{
public:
  DatatypeLookup(const DocumentCache* dc, XPath2MemoryManager* memMgr);
  virtual ~DatatypeLookup();

  ///returns the appropriate Datatype object
  const DatatypeFactory* lookupDatatype(const XMLCh* typeURI, const XMLCh* typeName) const;

private:
  DatatypeLookup & operator= (const DatatypeLookup& r);
  DatatypeLookup(const DatatypeLookup &other);

  // add a primitive datatype to the table
  void insertDatatype(DatatypeFactory *datatype);
    
  ///function to create the table
  void createTable();
	
private:
  /// Quick lookup for datatypes by name. Datatypes pointed to are not unique.
  XERCES_CPP_NAMESPACE_QUALIFIER RefHashTableOf< DatatypeFactory > fDatatypeTable;
    
  const DocumentCache *fDocumentCache;

  XPath2MemoryManager* fMemMgr;
};

#endif 
