/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _STATICANALYSISEXCEPTION_HPP
#define _STATICANALYSISEXCEPTION_HPP

#include <pathan/Pathan.hpp>

#include <pathan/exceptions/DSLException.hpp>
#include <pathan/internal/DOMutils/XStr.hpp>

/** 
 * This means that an error was found in the static analysis of the expression
 */

class PATHAN_EXPORT StaticAnalysisException : public DSLException
{
public:
  StaticAnalysisException(const XMLCh* const functionName, const XMLCh* const reason, const char *file, int line)
    : DSLException(X("StaticAnalysisException"), functionName, reason, file, line) {};
};

#endif // _STATICANALYSISEXCEPTION_HPP
