/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _STATICRESOLUTIONCONTEXT_HPP
#define _STATICRESOLUTIONCONTEXT_HPP

#include <string>

#include <pathan/Pathan.hpp>
#include <pathan/dataItem/DataItemFor.hpp>

#include <xercesc/util/RefHash2KeysTableOf.hpp>
#include <xercesc/util/StringPool.hpp>

class XPath2MemoryManager;

typedef XERCES_CPP_NAMESPACE_QUALIFIER RefHash2KeysTableOf<int> VariableAccessSet;
typedef XERCES_CPP_NAMESPACE_QUALIFIER RefHash2KeysTableOfEnumerator<int> VariableAccessSetEnumerator;

/**
 * Records access to various parts of the context during static resolution.
 */
class PATHAN_EXPORT StaticResolutionContext
{
public:
  StaticResolutionContext(XPath2MemoryManager* memMgr);

  /// Clears all the information in this StaticResolutionContext
  void clear();

  /** Overrides all the other flags, and never allows this sub-expression
      to be constant folded. */
  void forceNoFolding(bool value);
  bool isNoFoldingForced() const;

  void contextItemUsed(bool value);
  void contextPositionUsed(bool value);
  void contextSizeUsed(bool value);
  bool isContextSizeUsed() const;
  /** Returns true if any of the context item flags have been used */
  bool areContextFlagsUsed() const;

  void currentTimeUsed(bool value);
  void implicitTimezoneUsed(bool value);
  void availableDocumentsUsed(bool value);
  void availableCollectionsUsed(bool value);
  bool areDocsOrCollectionsUsed() const;

  void variableUsed(const XMLCh *namespaceURI, const XMLCh *name);
  bool removeVariable(const XMLCh *namespaceURI, const XMLCh *name);
  bool isVariableUsed(const XMLCh *namespaceURI, const XMLCh *name);

  /** Sets the members of this StaticResolutionContext from the given StaticResolutionContext */
  void add(const StaticResolutionContext *o);

  /** Returns true if flags are set, or variables have been used */
  bool isUsed() const;

  std::string toString() const;

private:
  StaticResolutionContext(const StaticResolutionContext &o);
  StaticResolutionContext &operator=(const StaticResolutionContext &o);

  bool _contextItem;
  bool _contextPosition;
  bool _contextSize;
  bool _currentTime;
  bool _implicitTimezone;
  bool _availableDocuments;
  bool _availableCollections;
  bool _forceNoFolding;

  VariableAccessSet _dynamicVariables;
  XERCES_CPP_NAMESPACE_QUALIFIER XMLStringPool _uriPool;
  XPath2MemoryManager* _memMgr;
};

#endif
