/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _DATAITEMSTEP_HPP
#define _DATAITEMSTEP_HPP

#include <pathan/Pathan.hpp>

#include <pathan/dataItem/DataItemImpl.hpp>

class NavStepImpl;

///this class calculates a node list based on a context
class PATHAN_EXPORT DataItemStep : public DataItemImpl
{
public:
  //constuctor that takes the step this DataItem is refuring to
  DataItemStep(NavStepImpl* step, XPath2MemoryManager* memMgr);
  ~DataItemStep();

  virtual DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);
  virtual Result createResult(DynamicContext* context, int flags=0) const;
  virtual Result postPredicateResultHook(Result &result, DynamicContext* context, int flags=0) const;
  // override default from DataItem
  virtual unsigned int getStaticProperties() const;

  const NavStepImpl *getNavStep() const;
  void setNavStep(NavStepImpl *nav);

private:

  NavStepImpl* _step;

};

#endif
