/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _DataItemNav_HPP
#define _DataItemNav_HPP

#include <set>
#include <vector>
#include "../Pathan.hpp"

#include "DataItemImpl.hpp"
#include "../Sequence.hpp"

#include "SingleResult.hpp"
#include "../Node.hpp"
#include <xercesc/dom/DOMNode.hpp>

class NavStepImpl;

///this class calculates a node list based on a context
class PATHAN_EXPORT DataItemNav : public DataItemImpl
{
public:
  class StepInfo {
  public:
    StepInfo() : usesContextSize(false), step(0) {}
    StepInfo(DataItem *s) : usesContextSize(false), step(s) {}
    StepInfo(DataItem *s, bool cs) : usesContextSize(cs), step(s) {}
    bool usesContextSize;
    DataItem *step;
  };
  typedef std::vector<StepInfo,PathanAllocator<StepInfo> > Steps;

  DataItemNav(XPath2MemoryManager* memMgr);
  virtual ~DataItemNav();
	

  /** Add a new NavigationStep to the sequence of navigation steps to
      be performed. This operation is used by parse tree classes to
      turn themselves into an optimised, reusable navigation. **/
  void addStep(const StepInfo &step);

  /** Add a new NavigationStep to the sequence of navigation steps to
      be performed. This operation is used by parse tree classes to
      turn themselves into an optimised, reusable navigation. **/
  void addStep(NavStepImpl* step);

  /** Add a new NavigationStep to the start of the sequence of
      navigation steps to be performed.**/
  void addStepFront(DataItem* step);

  ///set the "go to root of tree first" flag.
  void setGotoRootFirst(bool gotoRoot);

  virtual Result createResult(DynamicContext* context, int flags=0) const;

  virtual DataItem* staticResolution(StaticContext *context, StaticResolutionContext *src);
	
  bool getGotoRootFirst() const;
  const Steps &getSteps() const;
  bool getIsSorted() const;
	
protected:
  class GotoRootResult : public SingleResult
  {
  public:
    GotoRootResult(DynamicContext *context);
    Item::Ptr getSingleResult(DynamicContext *context) const;
    std::string asString(DynamicContext *context, int indent) const;
  };

  class StepResult : public ResultImpl
  {
  public:
    StepResult(const Result &parent, DataItem *step, unsigned int contextSize, int flags, DynamicContext *context);

    Item::Ptr next(DynamicContext *context);
    std::string asString(DynamicContext *context, int indent) const;

  private:
    bool initialised_;
    int flags_;
    Result parent_;
    const DataItem *step_;
    Result stepResult_;
    unsigned int contextPos_;
    unsigned int contextSize_;
    Item::Ptr contextItem_;
  };

  bool _gotoRoot;
  mutable int _isSorted;
  //list of steps to be performed.
  Steps _steps;
};

#endif


