/*
 * Copyright (c) 2004, Parthenon Computing Limited, All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _NODECONSTUCTOR_HPP
#define _NODECONSTUCTOR_HPP

#include "ItemConstructor.hpp"
#include <xercesc/util/XercesDefs.hpp>

XERCES_CPP_NAMESPACE_BEGIN
class DOMNode;
XERCES_CPP_NAMESPACE_END

class PATHAN_EXPORT NodeConstructor : public ItemConstructor {
public:
  NodeConstructor(const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node);

  virtual Item::Ptr createItem(const DynamicContext* context) const;
  virtual std::string asString(const DynamicContext* context) const;

private:
  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *_node;
};

#endif

