#!/bin/bash

currentdir=`pwd`


#check that XERCESCROOT exists
cd $XERCESCROOT
if test $? != 0 
  then
    echo "$0 : XERCESCROOT must be set"
    exit 1
fi

#setup a copy of the Xerces/Pathan srcs
cd $currentdir
rm -rf src
mkdir src

#copy the sources, and remove XERCES_CPP_NAMESPACE_QUALIFIER from the Pathan headers
cp -r ../src/* src/
cp -r ../include/* src/
find . -name *.hpp -or -name *.h | xargs perl -pi -e "s/XERCES_CPP_NAMESPACE_QUALIFIER//g"
cp -r $XERCESCROOT/src/xercesc/* src/

#run doxygen
doxygen

#copy the stylesheet over top since doxygen seems to generate a blank one everytime
cp html/apiDocs/api.css html/apiDocs/PathanApi.css
