//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: QueryPlanCommand.cpp,v 1.5 2005/04/05 16:44:29 bostic Exp $
//

#include "QueryPlanCommand.hpp"

using namespace DbXml;
using namespace std;

string QueryPlanCommand::getCommandName() const
{
	return "queryPlan";
}

string QueryPlanCommand::getCommandNameCompat() const
{
	return "qplan";
}

string QueryPlanCommand::getBriefHelp() const
{
	return "Prints the query plan for the specified query expression";
}

string QueryPlanCommand::getMoreHelp() const
{
	return
		string("Usage: queryPlan <queryExpression>\n") +
		string("This command parses the queryExpression into an\n") +
		string("XmlQueryExpression, and calls getQueryPlan().");
}

void QueryPlanCommand::execute(Args &args, Environment &env)
{
	if(args.size() != 2) {
		throw CommandException("Wrong number of arguments");
	}
	
	if(env.txn()) {
		XmlQueryExpression expr = env.db().prepare(*env.txn(), args[1],
							   env.context());
		cout << expr.getQueryPlan();
	} else {
		XmlQueryExpression expr = env.db().prepare(args[1],
							   env.context());
		cout << expr.getQueryPlan();
	}
}

