//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: PrintCommand.cpp,v 1.9 2005/05/18 22:56:08 jsnelson Exp $
//

#include "PrintCommand.hpp"
#include <fstream>

using namespace DbXml;
using namespace std;

string PrintCommand::getCommandName() const
{
	return "print";
}

string PrintCommand::getCommandNameCompat() const
{
	return "printNames";
}

string PrintCommand::getBriefHelp() const
{
	return "Prints most recent results, optionally to a file";
}

string PrintCommand::getMoreHelp() const
{
	return
		string("Usage: print | printNames [pathToFile]\n") +
		string("If \"print\" is used, the most recent results are printed,\n") +
		string("using XmlValue::asString().\n") +
		string("If the \"printNames\" form is used, the results are turned\n") +
		string("into document names and printed, if possible.  If the results\n") +
		string("cannot be converted, the command will fail.  If the optional\n")+
		string("pathToFile parameter is specified, the output is written to\n")+
		string("the named file, rather than to stdout.\n");
}

void PrintCommand::execute(Args &args, Environment &env)
{
	if(args.size() > 2) {
		throw CommandException("Wrong number of arguments");
	}
	bool content = true;
	bool toFile = false;
	ofstream outputFile;
	if ((args[0] == "printNames") ||
	    (args[0] == "printnames"))
		content = false;
	if (args.size() == 2) {
		outputFile.open(args[1].c_str(), ofstream::out|ofstream::trunc|
				ofstream::binary);
		toFile = true;
	}
	env.testResults();
	env.results()->reset();
	XmlValue value;
	ostream &output = (toFile ? (ostream &)outputFile : cout);
	while(env.results()->next(value)) {
		if (content)
			output << value.asString() << endl;
		else {
			output << value.asDocument().getName() << endl;
		}
	}
	if (toFile)
		outputFile.close();
}

