//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: IndexLookupCommand.cpp,v 1.7 2005/04/05 16:44:28 bostic Exp $
//

#include "IndexLookupCommand.hpp"

using namespace DbXml;
using namespace std;

string IndexLookupCommand::getCommandNameCompat() const
{
	return "indexlookup";
}

string IndexLookupCommand::getCommandName() const
{
	return "lookupIndex";
}

string IndexLookupCommand::getBriefHelp() const
{
	return "Performs index lookup in the default container";
}

string IndexLookupCommand::getMoreHelp() const
{
	return
		string("Usage: lookupIndex <indexDescription> <namespaceUri> <nodeName>\n") +
		string("\t[<parentNodeNamespaceUri> <parentNodeName> <value> ]\n") +
		string("Example -- lookup all documents in document name index:\n") +
		string("\tlookupIndex node-metadata-equality-string \\\n") +
		string("\t    http://www.sleepycat.com/2002/dbxml name\n") +
		string("Example -- lookup a specific document in document name index:\n") +
		string("\tlookupIndex node-metadata-equality-string \\\n") +
		string("\t    http://www.sleepycat.com/2002/dbxml name \"\" \"\" myDocument\n") +
		string("The optional parent URI and name are used for edge indexes\n") +
		string("Indexes available can be found using the 'listIndexes' command.");
}

void IndexLookupCommand::execute(Args &args, Environment &env)
{
	if(args.size() < 4 || args.size() > 7 || args.size() == 5) {
		throw CommandException("Wrong number of arguments");
	}
	env.testContainer();
	env.deleteResults();

	XmlValue value;
	if(args.size() == 7) {
		// need to use type coercion in order
		// to support lookup on non-string indexes
		XmlValue::Type type = XmlIndexSpecification::getValueType(
			args[1]);
		value = XmlValue(type, args[6]);
	}

	if(env.txn()) {
		if(args.size() == 4 || args[5] == "") {
			env.results() = new XmlResults(env.container()->
						       lookupIndex(*env.txn(),
								   env.context(),
								   args[2], args[3],
								   args[1], value,
								   DBXML_LAZY_DOCS));
		} else {
			env.results() = new XmlResults(env.container()->
						       lookupIndex(*env.txn(),
								   env.context(),
								   args[2], args[3],
								   args[4], args[5],
								   args[1], value,
								   DBXML_LAZY_DOCS));
		}
	} else {
		if(args.size() == 4 || args[5] == "") {
			env.results() = new XmlResults(env.container()->
						       lookupIndex(env.context(),
								   args[2], args[3],
								   args[1], value,
								   DBXML_LAZY_DOCS));
		} else {
			env.results() = new XmlResults(env.container()->
						       lookupIndex(env.context(),
								   args[2], args[3],
								   args[4], args[5],
								   args[1], value,
								   DBXML_LAZY_DOCS));
		}
	}

	if(env.context().getEvaluationType() == XmlQueryContext::Eager) {
		if(env.verbose()) cout << env.results()->size() << " objects returned for eager index lookup '"
				       << args[1] << "'" << endl << endl;
	} else {
		if(env.verbose()) cout << "Lazy index lookup '" << args[1] << "' completed" << endl << endl;
	}
}

