//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: GetMetaDataCommand.cpp,v 1.1 2005/04/04 21:45:02 gmf Exp $
//

#include "GetMetaDataCommand.hpp"

using namespace DbXml;
using namespace std;

string GetMetaDataCommand::getCommandName() const
{
	return "getMetaData";
}

string GetMetaDataCommand::getBriefHelp() const
{
	return "Get a metadata item from the named document";
}

string GetMetaDataCommand::getMoreHelp() const
{
	return
		string("Usage: getMetaData <docName> <metaDataUri> <metaDataName>\n")+
		string("Get a metaData item from the named document.  This method\n")+
		string("resets the default results to the returned value.\n")+
		string("This command is equivalent to the query expression:\n")+
		string("\tfor $i in doc('containerName/docName') return dbxml:metadata('metaDataUri:metaDataName', $i)\n");
}

void GetMetaDataCommand::execute(Args &args, Environment &env)
{
	if (args.size() != 4)
		throw CommandException("Wrong number of arguments");
	env.testContainer();
	env.deleteResults();
	const string &docname = args[1];
	const string &uri = args[2];
	const string &name = args[3];
	bool gotOne = false;
	XmlValue value;
	// DBXML_LAZY_DOCS because we're not getting content
	// Value is aggressively copied, so there's no
	// transaction issue.
	if(env.txn()) {
		XmlTransaction myTxn = env.childTransaction();
		XmlDocument doc = env.container()->getDocument(
			myTxn, docname, DBXML_LAZY_DOCS);
		gotOne = doc.getMetaData(uri, name, value);
		myTxn.commit();
	} else {
		XmlDocument doc = env.container()->getDocument(
			docname, DBXML_LAZY_DOCS);
		gotOne = doc.getMetaData(uri, name, value);
	}
	if (gotOne) {
		XmlResults res = env.db().createResults();
		res.add(value);
		env.results() = new XmlResults(res);
	}
	if(env.verbose()) {
		string fullname = "";
		if (!uri.empty())
			fullname = uri + ":";
		fullname += name;
		if (gotOne)
			cout << "Retrieved metadata item '";
		else
			cout << "Could not find metadata item '";
		cout << fullname << "' in document, " << docname << endl;
	}
}

