//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: DebugCommand.cpp,v 1.16 2005/04/05 16:44:28 bostic Exp $
//

#include "DebugCommand.hpp"

#include <xquery/XQContext.hpp>
#include <xquery/XQEvaluator.hpp>
#include <xquery/XQQuery.hpp>

#include <db_cxx.h>
#include "ScopedDbt.hpp"
#include "ID.hpp"

#include "UTF8.hpp"
#include "QueryContext.hpp"
#include "PrintDataItemTree.hpp"
#include "OperationContext.hpp"
#include "Document.hpp"
#include "TransactedContainer.hpp"
#include "optimizer/CollectionAndDocOptimizer.hpp"
#include "optimizer/ContainerContextOptimizer.hpp"
#include "optimizer/QueryPlanGenerator.hpp"

#include <pathan/internal/XPath2MemoryManagerImpl.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/PathanExpression.hpp>
#include <pathan/internal/dom-extensions/PathanExpressionImpl.hpp>
#include <pathan/PathanEngine.hpp>
#include <pathan/PathanException.hpp>
#include <pathan/exceptions/DSLException.hpp>

using namespace DbXml;
using namespace std;

string DebugCommand::getCommandName() const
{
	return "debug";
}

string DebugCommand::getBriefHelp() const
{
	return "Debug command -- internal use only";
}

string DebugCommand::getMoreHelp() const
{
	return "";
}

#define DB_TEST 0
#define QUERY_TEST 1

void DebugCommand::execute(Args &args, Environment &env)
{
	if(args.size() != 2) {
		throw CommandException("Wrong number of arguments");
	}

	try {
#if DB_TEST
		DbEnv *env = new DbEnv(0);
		env->open("TESTDIR",
			  DB_CREATE|DB_INIT_LOCK|DB_INIT_LOG|DB_INIT_MPOOL|
			  DB_INIT_TXN, 0);
		Db db(env, 0);
		db.open(0, "testdb", "testdb", DB_RECNO, DB_CREATE, 0);

		u_int32_t idt = 0;
		DbtIn key(&idt, sizeof(idt));

		DbtOut data;
		data.set("frank", 6);

		{
			ID id;
			id.setThisFromDbt(key, false);
			Buffer tmp(data.get_data(), data.get_size(), true);
			cerr << "id = " << id << ", value = " << tmp.asString() << endl;
		}

		db.put(0, &key, &data, DB_APPEND);

		{
			ID id;
			id.setThisFromDbt(key, false);
			Buffer tmp(data.get_data(), data.get_size(), true);
			cerr << "id = " << id << ", value = " << tmp.asString() << endl;
		}

		db.close(0);
#endif

#if QUERY_TEST
		ReferenceMinder minder;
		((QueryContext&)env.context()).setMinder(&minder);
		if(env.txn()) {
			((QueryContext&)env.context()).setTransaction(*env.txn());
		}
		else {
			((QueryContext&)env.context()).setTransaction(0);
		}

		XPath2MemoryManagerImpl mm;

		XQContext *context = ((QueryContext&)env.context()).createXQContext(env.txn() ? *env.txn() : 0, mm);

		XQQuery *query = XQEvaluator::parse(UTF8ToXMLCh(args[1]).str(), context, false);

		OutputTree *before = new OutputTree("Initial tree", context);
		// ContainerContextOptimizer *containerise = new ContainerContextOptimizer(args[2], args[3] == "true", context, before);
		// OutputTree *afterContainerise = new OutputTree("After Containerisation", context, containerise);
		StaticResolver *sr = new StaticResolver(context, before);
		OutputTree *afterStatic = new OutputTree("After Static Resolution", context, sr);
		CollectionAndDocOptimizer *cad = new CollectionAndDocOptimizer(minder, context, afterStatic);
		OutputTree *afterCandD = new OutputTree("After Collection And Doc Optimisation", context, cad);
		QueryPlanGenerator *qpGen = new QueryPlanGenerator(((QueryContext&)env.context()).getManager(), 0, context, afterCandD);
		OutputTree optimizer("After Raw Query Plan Generation", context, qpGen);

		optimizer.startOptimize(query);

		cout << "Global Query Plan: " << endl;
		if(qpGen->getQueryPlan() != 0) cout << qpGen->getQueryPlan()->toString(false) << endl;

		XQContext *context2 = ((QueryContext&)env.context()).createDynamicXQContext(env.txn() ? *env.txn() : 0, context, mm);
		Result result(query->evaluate(context2));

		cout << "Results:\n";
		Item::Ptr item;
		while((item = result.next(context2)) != NULLRCP) {
// 			if(item->isNode()) {
// 				static const XMLCh foo_prefix[] = { 'n', 'a', 'd', 's', 0 };
// 				static const XMLCh foo_uri[] = { 'u', 'r', 'n', ':', 't', 'a', 'r', 't', 's', 0 };
// 				static const XMLCh foo[] = { 'f', 'o', 'o', '_', 't', 'a', 'r', 't', 's', 0 };
// 				static const XMLCh bar_foo[] = { 'b', 'a', 'r', ':', 'f', 'o', 'o', '_', 't', 'a', 'r', 't', 's', 0 };
// 				static const XMLCh type[] = { 't', 'y', 'p', 'e', 0 };

// 				cout << "--------------------\n\n";

// 				XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node =
// 				const_cast<XERCES_CPP_NAMESPACE_QUALIFIER DOMNode*>
// 					(((const Node*)(const Item*)item)->getDOMNode());
// 				Document *doc = minder.findDocument(node);
// 				XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *domdoc =
// 					node->getOwnerDocument() ? node->getOwnerDocument() :
// 					(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*)node;

// 				if(node->getNodeType() == XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ELEMENT_NODE ||
// 				   node->getNodeType() == XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ATTRIBUTE_NODE) {
// 					domdoc->renameNode(node, foo_uri, bar_foo);
// 				}

// 				cout << XMLChToUTF8(item->asString(context2)).str() << endl;

// 				doc->setContentAsDOM(domdoc);

// 				doc->getContainer()->updateDocument(env.txn() != 0 ? ((Transaction*)*env.txn()) : 0, *doc, env.uc(), 0);

// 				const Dbt *content = doc->getContentAsDbt();
// 				cout << "new content: \"" << string((char*)content->get_data(), content->get_size()) << "\""<< endl;
// 			}
// 			else {
				cout << XMLChToUTF8(item->asString(context2)).str() << endl;
// 			}
		}
#endif
	}
	catch (const PathanException &e) {
		throw CommandException(XMLChToUTF8(e.getString()).str());
	}
	catch (const XERCES_CPP_NAMESPACE_QUALIFIER DOMException &e) {
		throw CommandException(XMLChToUTF8(e.msg).str());
	}
	catch(const DSLException &e) {
		throw CommandException(XMLChToUTF8(e.getError()).str());
	}
	catch(XERCES_CPP_NAMESPACE_QUALIFIER XMLException &e) {
		throw CommandException(XMLChToUTF8(e.getMessage()).str());
	}
	catch(DbException &e) {
		throw XmlException(e);
	}
}

