#!/usr/bin/env python
#
# Setup script for Berkeley DB XML package
# $Id: setup.py,v 1.88 2005/05/24 14:39:33 gmf Exp $

import os, sys
from distutils.core import setup, Extension

#
# Posix:
#
# db_home, xquery_home, pathan_home, and xerces_home are
# set based on the arguments  passed to the configure script.
# This can be overridden with the --with-berkeleydb, --with-xquery, 
# --with-xerces, and --with-pathan arguments.
#
# Windows: may require further editing to reflect site specifics.
#
if os.name == "posix":
  db_home = "@DB_DIR@"
  xerces_home = "@XERCES_DIR@"
  pathan_home = "@PATHAN_DIR@"
  xquery_home = "@XQUERY_DIR@"
else:
  xerces_home = "../../../xerces-c-src_2_6_0"
  pathan_home = "../../../pathan"
  xquery_home = "../../../xquery-1.1.0"
  db_home = "../../../db-4.3.28"

for arg in sys.argv:
  if arg.startswith('--with-berkeleydb='):
    db_home = arg.split('=')[1]
  elif arg.startswith('--with-xerces='):
    xerces_home = arg.split('=')[1]
  elif arg.startswith('--with-pathan='):
    pathan_home = arg.split('=')[1]
  elif arg.startswith('--with-xquery='):
    xquery_home = arg.split('=')[1]

sys.argv = filter(lambda x: not x.startswith("--with-"), sys.argv)

debug = "--debug" in sys.argv or "-g" in sys.argv

# setup complains when passed debug flags for install
if "install" in sys.argv and not "build" in sys.argv:
  sys.argv = filter(lambda x: (x != "--debug") and (x != "-g"), sys.argv)

if os.name == "posix":
  INCLUDES =    ["../../include",
                 os.path.join(db_home, "include")]

  LIBDIRS =     ["../../build_unix/.libs",
                 os.path.join(db_home, "lib"),
                 os.path.join(pathan_home, "lib"),
                 os.path.join(xquery_home, "lib"),
                 os.path.join(xerces_home, "lib")]

  LIBS =        ["dbxml-2.1",
                 "db_cxx-4.3",
                 "xquery", "pathan", "xerces-c"]

  DATAFILES =   []

elif os.name == "nt":
  INCLUDES =    ["../../include",
                 os.path.join(db_home, "build_win32"),
                 os.path.join(db_home, "dbinc")]

  if debug:
    LIBDIRS =   ["../../../lib",
                 "../../build_win32/Debug",
                 os.path.join(db_home, "build_win32/Debug"),
                 os.path.join(pathan_home, "lib"),
                 os.path.join(xquery_home, "lib"),
                 os.path.join(xerces_home, "Build/Win32/VC7")]
  
    LIBS =      ["libdbxml21D",
                 "libdb43D", "libxquery11d",
                 "PathanD_7.1", "xerces-c_2D"]

    DATAFILES = [("", ["../../../bin/debug/libdbxml21D.dll",
                       "../../../bin/debug/libdb43D.dll",
                       "../../../bin/debug/libxquery11d.dll",
                       "../../../bin/debug/PathanD_7.1.dll",
                       "../../../bin/debug/xerces-c_2_6D.dll"])]
  else:
    LIBDIRS =   ["../../../lib",
                 "../../build_win32/Release",
                 os.path.join(db_home, "build_win32/Release"),
                 os.path.join(xquery_home, "lib"),
                 os.path.join(pathan_home, "lib"),
                 os.path.join(xerces_home, "Build/Win32/VC7")]
  
    LIBS =      ["libdbxml21",
                 "libdb43", "libxquery11",
                 "Pathan_7.1", "xerces-c_2"]

    DATAFILES = [("", ["../../../bin/libdbxml21.dll",
                       "../../../bin/libdb43.dll",
                       "../../../bin/libxquery11.dll",
                       "../../../bin/Pathan_7.1.dll",
                       "../../../bin/xerces-c_2_6.dll"])]

else:
  print "I don't know anything about your platform '%s'." % os.name
  print "Please check the build instructions for more information"
  sys.exit(1)

# Now run with whatever settings we've got
setup(name = "dbxml",
      version = "2.1.8",
      description = "Berkeley DB XML Python API",
      author = "Sleepycat Software",
      author_email = "support@sleepycat.com",
      url = "http://www.sleepycat.com/products/xml.shtml",
      py_modules = ["dbxml"],
      ext_modules = [Extension("_dbxml", ["dbxml_python_wrap.cpp"],
                               include_dirs = INCLUDES,
                               library_dirs = LIBDIRS,
                               libraries = LIBS)],
      data_files = DATAFILES)
