/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.24
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON
#define SWIG_DIRECTORS

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif


#ifndef SWIG_TEMPLATE_DISAMBIGUATOR
#  if defined(__SUNPRO_CC) 
#    define SWIG_TEMPLATE_DISAMBIGUATOR template
#  else
#    define SWIG_TEMPLATE_DISAMBIGUATOR 
#  endif
#endif


#include <Python.h>

/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "1"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
#define SWIG_QUOTE_STRING(x) #x
#define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
#define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
#define SWIG_TYPE_TABLE_NAME
#endif

#include <string.h>

#ifndef SWIGINLINE
#if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#  define SWIGINLINE inline
#else
#  define SWIGINLINE
#endif
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/
#ifndef SWIGRUNTIME
#define SWIGRUNTIME static
#endif
#ifndef SWIGRUNTIMEINLINE
#define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Register a type mapping with the type-checking
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeRegisterTL(swig_type_info **tl, swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *tl;
  while (tc) {
    /* check simple type equivalence */
    int typeequiv = (strcmp(tc->name, ti->name) == 0);   
    /* check full type equivalence, resolving typedefs */
    if (!typeequiv) {
      /* only if tc is not a typedef (no '|' on it) */
      if (tc->str && ti->str && !strstr(tc->str,"|")) {
	typeequiv = SWIG_TypeEquiv(ti->str,tc->str);
      }
    }
    if (typeequiv) {
      /* Already exists in the table.  Just add additional types to the list */
      if (ti->clientdata) tc->clientdata = ti->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *tl;
  *tl = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;

  return ret;
}

/*
  Check the typename
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/*
  Search for a swig_type_info structure
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryTL(swig_type_info *tl, const char *name) {
  swig_type_info *ty = tl;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientDataTL(swig_type_info *tl, swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata) return;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = tl;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientDataTL(tl,tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register int d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/*
  This function will propagate the clientdata field of type to any new
  swig_type_info structures that have been added into the list of
  equivalent types.  It is like calling SWIG_TypeClientData(type,
  clientdata) a second time.
*/
SWIGRUNTIME void
SWIG_PropagateClientDataTL(swig_type_info *tl, swig_type_info *type) {
  swig_type_info *equiv = type->next;
  swig_type_info *tc;
  if (!type->clientdata) return;
  while (equiv) {
    if (!equiv->converter) {
      tc = tl;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0) && !tc->clientdata)
          SWIG_TypeClientDataTL(tl,tc, type->clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/


#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if !defined(STATIC_LINKED)
#    define SWIGEXPORT(a) __declspec(dllexport) a
#  else
#    define SWIGEXPORT(a) a
#  endif
#else
#  define SWIGEXPORT(a) a
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*************************************************************************/


/* The static type info list */

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;
  

/* Register a type mapping with the type-checking */
static swig_type_info *
SWIG_TypeRegister(swig_type_info *ti) {
  return SWIG_TypeRegisterTL(swig_type_list_handle, ti);
}

/* Search for a swig_type_info structure */
static swig_type_info *
SWIG_TypeQuery(const char *name) {
  return SWIG_TypeQueryTL(*swig_type_list_handle, name);
}

/* Set the clientdata field for a type */
static void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientDataTL(*swig_type_list_handle, ti, clientdata);
}

/* This function will propagate the clientdata field of type to
* any new swig_type_info structures that have been added into the list
* of equivalent types.  It is like calling
* SWIG_TypeClientData(type, clientdata) a second time.
*/
static void
SWIG_PropagateClientData(swig_type_info *type) {
  SWIG_PropagateClientDataTL(*swig_type_list_handle, type);
}

#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------
 * SWIG API. Portion that goes into the runtime
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * for internal method declarations
 * ----------------------------------------------------------------------------- */

#ifndef SWIGINTERN
#define SWIGINTERN static 
#endif

#ifndef SWIGINTERNSHORT
#ifdef __cplusplus
#define SWIGINTERNSHORT static inline 
#else /* C case */
#define SWIGINTERNSHORT static 
#endif /* __cplusplus */
#endif


/*
  Exception handling in wrappers
*/
#define SWIG_fail                goto fail
#define SWIG_arg_fail(arg)       SWIG_Python_ArgFail(arg)
#define SWIG_append_errmsg(msg)   SWIG_Python_AddErrMesg(msg,0)
#define SWIG_preppend_errmsg(msg) SWIG_Python_AddErrMesg(msg,1)
#define SWIG_type_error(type,obj) SWIG_Python_TypeError(type,obj)
#define SWIG_null_ref(type)       SWIG_Python_NullRef(type)

/*
  Contract support
*/
#define SWIG_contract_assert(expr, msg) \
 if (!(expr)) { PyErr_SetString(PyExc_RuntimeError, (char *) msg ); goto fail; } else

/* -----------------------------------------------------------------------------
 * Constant declarations
 * ----------------------------------------------------------------------------- */

/* Constant Types */
#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4
#define SWIG_PY_BINARY  5

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;


/* -----------------------------------------------------------------------------
 * Alloc. memory flags
 * ----------------------------------------------------------------------------- */
#define SWIG_OLDOBJ  1
#define SWIG_NEWOBJ  SWIG_OLDOBJ + 1
#define SWIG_PYSTR   SWIG_NEWOBJ + 1

#ifdef __cplusplus
}
#endif


/***********************************************************************
 * pyrun.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags)    SWIG_Python_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags)       SWIG_Python_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags)  SWIG_Python_MustGetPtr(p, type, argnum, flags)
 

/* Python-specific SWIG API */
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags)   SWIG_Python_ConvertPacked(obj, ptr, sz, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type)              SWIG_Python_NewPackedObj(ptr, sz, type)


/* -----------------------------------------------------------------------------
 * Pointer declarations
 * ----------------------------------------------------------------------------- */
/*
  Use SWIG_NO_COBJECT_TYPES to force the use of strings to represent
  C/C++ pointers in the python side. Very useful for debugging, but
  not always safe.
*/
#if !defined(SWIG_NO_COBJECT_TYPES) && !defined(SWIG_COBJECT_TYPES)
#  define SWIG_COBJECT_TYPES
#endif

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2


#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * Create a new pointer string 
 * ----------------------------------------------------------------------------- */

#ifndef SWIG_BUFFER_SIZE
#define SWIG_BUFFER_SIZE 1024
#endif

#if defined(SWIG_COBJECT_TYPES)
#if !defined(SWIG_COBJECT_PYTHON)
/* -----------------------------------------------------------------------------
 * Implements a simple Swig Object type, and use it instead of PyCObject
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *ptr;
  const char *desc;
} PySwigObject;

/* Declarations for objects of type PySwigObject */

SWIGRUNTIME int
PySwigObject_print(PySwigObject *v, FILE *fp, int flags)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result))) {
    fputs("<Swig Object at ", fp); fputs(result, fp); fputs(">", fp);
    return 0; 
  } else {
    return 1; 
  }
}
  
SWIGRUNTIME PyObject *
PySwigObject_repr(PySwigObject *v)
{
  char result[SWIG_BUFFER_SIZE];
  return SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result)) ?
    PyString_FromFormat("<Swig Object at %s>", result) : 0;
}

SWIGRUNTIME PyObject *
PySwigObject_str(PySwigObject *v)
{
  char result[SWIG_BUFFER_SIZE];
  return SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result)) ?
    PyString_FromString(result) : 0;
}

SWIGRUNTIME PyObject *
PySwigObject_long(PySwigObject *v)
{
  return PyLong_FromUnsignedLong((unsigned long) v->ptr);
}

SWIGRUNTIME PyObject *
PySwigObject_oct(PySwigObject *v)
{
  char buf[100];
  unsigned long x = (unsigned long)v->ptr;
  if (x == 0)
    strcpy(buf, "0");
  else
    PyOS_snprintf(buf, sizeof(buf), "0%lo", x);
  return PyString_FromString(buf);
}

SWIGRUNTIME PyObject *
PySwigObject_hex(PySwigObject *v)
{
  char buf[100];
  PyOS_snprintf(buf, sizeof(buf), "0x%lx", (unsigned long)v->ptr);
  return PyString_FromString(buf);
}

SWIGRUNTIME int
PySwigObject_compare(PySwigObject *v, PySwigObject *w)
{
  int c = strcmp(v->desc, w->desc);
  if (c) {
    return c;
  } else {
    void *i = v->ptr;
    void *j = w->ptr;
    return (i < j) ? -1 : (i > j) ? 1 : 0;
  }
}

SWIGRUNTIME void
PySwigObject_dealloc(PySwigObject *self)
{
  PyObject_DEL(self);
}

SWIGRUNTIME PyTypeObject*
PySwigObject_GetType() {
  static char PySwigObject_Type__doc__[] = 
    "Swig object carries a C/C++ instance pointer";
  
  static PyNumberMethods PySwigObject_as_number = {
    (binaryfunc)0, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)0, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0, /*nb_remainder*/
    (binaryfunc)0, /*nb_divmod*/
    (ternaryfunc)0,/*nb_power*/
    (unaryfunc)0,  /*nb_negative*/
    (unaryfunc)0,  /*nb_positive*/
    (unaryfunc)0,  /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    0,		   /*nb_invert*/
    0,		   /*nb_lshift*/
    0,		   /*nb_rshift*/
    0,		   /*nb_and*/
    0,		   /*nb_xor*/
    0,		   /*nb_or*/
    (coercion)0,   /*nb_coerce*/
    (unaryfunc)PySwigObject_long, /*nb_int*/
    (unaryfunc)PySwigObject_long, /*nb_long*/
    (unaryfunc)0,                 /*nb_float*/
    (unaryfunc)PySwigObject_oct,  /*nb_oct*/
    (unaryfunc)PySwigObject_hex,  /*nb_hex*/
#if PY_VERSION_HEX >= 0x02000000
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_true_divide */ 
#endif
  };

  static int type_init = 0;  
  static PyTypeObject PySwigObject_Type;

  if (!type_init) {
    PyTypeObject tmp = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,					/*ob_size*/
    "PySwigObject",			/*tp_name*/
    sizeof(PySwigObject),		/*tp_basicsize*/
    0,					/*tp_itemsize*/
    /* methods */
    (destructor)PySwigObject_dealloc,	/*tp_dealloc*/
    (printfunc)PySwigObject_print,	/*tp_print*/
    (getattrfunc)0,			/*tp_getattr*/
    (setattrfunc)0,			/*tp_setattr*/
    (cmpfunc)PySwigObject_compare,	/*tp_compare*/
    (reprfunc)PySwigObject_repr,	/*tp_repr*/
    &PySwigObject_as_number,	        /*tp_as_number*/
    0,					/*tp_as_sequence*/
    0,					/*tp_as_mapping*/
    (hashfunc)0,			/*tp_hash*/
    (ternaryfunc)0,			/*tp_call*/
    (reprfunc)PySwigObject_str,		/*tp_str*/
    /* Space for future expansion */
    0L,0L,0L,0L,
    PySwigObject_Type__doc__, 	        /* Documentation string */
#if PY_VERSION_HEX >= 0x02000000
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
    0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
    0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };

    PySwigObject_Type = tmp;
    type_init = 1;
  }

  return &PySwigObject_Type;
}

SWIGRUNTIME PyObject *
PySwigObject_FromVoidPtrAndDesc(void *ptr, const char *desc)
{
  PySwigObject *self = PyObject_NEW(PySwigObject, PySwigObject_GetType());
  if (self == NULL) return NULL;
  self->ptr = ptr;
  self->desc = desc;
  return (PyObject *)self;
}

SWIGRUNTIMEINLINE void *
PySwigObject_AsVoidPtr(PyObject *self)
{
  return ((PySwigObject *)self)->ptr;
}

SWIGRUNTIMEINLINE const char *
PySwigObject_GetDesc(PyObject *self)
{
  return ((PySwigObject *)self)->desc;
}

SWIGRUNTIMEINLINE int
PySwigObject_Check(PyObject *op) {
  return ((op)->ob_type == PySwigObject_GetType()) 
    || (strcmp((op)->ob_type->tp_name,"PySwigObject") == 0);
}

/* -----------------------------------------------------------------------------
 * Implements a simple Swig Packed type, and use it instead of string
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *pack;
  const char *desc;
  size_t size;
} PySwigPacked;

SWIGRUNTIME int
PySwigPacked_print(PySwigPacked *v, FILE *fp, int flags)
{
  char result[SWIG_BUFFER_SIZE];
  fputs("<Swig Packed ", fp); 
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    fputs("at ", fp); 
    fputs(result, fp); 
  }
  fputs(v->desc,fp); 
  fputs(">", fp);
  return 0; 
}
  
SWIGRUNTIME PyObject *
PySwigPacked_repr(PySwigPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    return PyString_FromFormat("<Swig Packed at %s%s>", result, v->desc);
  } else {
    return PyString_FromFormat("<Swig Packed %s>", v->desc);
  }  
}

SWIGRUNTIME PyObject *
PySwigPacked_str(PySwigPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))){
    return PyString_FromFormat("%s%s", result, v->desc);
  } else {
    return PyString_FromFormat("%s", v->desc);
  }  
}

SWIGRUNTIME int
PySwigPacked_compare(PySwigPacked *v, PySwigPacked *w)
{
  int c = strcmp(v->desc, w->desc);
  if (c) {
    return c;
  } else {
    size_t i = v->size;
    size_t j = w->size;
    int s = (i < j) ? -1 : (i > j) ? 1 : 0;
    return s ? s : strncmp((char *)v->pack, (char *)w->pack, 2*v->size);
  }
}

SWIGRUNTIME void
PySwigPacked_dealloc(PySwigPacked *self)
{
  free(self->pack);
  PyObject_DEL(self);
}

SWIGRUNTIME PyTypeObject*
PySwigPacked_GetType() {
  static char PySwigPacked_Type__doc__[] = 
    "Swig object carries a C/C++ instance pointer";
  static int type_init = 0;
  
  static PyTypeObject PySwigPacked_Type;
  if (!type_init) {
    PyTypeObject tmp = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,					/*ob_size*/
    "PySwigPacked",			/*tp_name*/
    sizeof(PySwigPacked),		/*tp_basicsize*/
    0,					/*tp_itemsize*/
    /* methods */
    (destructor)PySwigPacked_dealloc,	/*tp_dealloc*/
    (printfunc)PySwigPacked_print,	/*tp_print*/
    (getattrfunc)0,			/*tp_getattr*/
    (setattrfunc)0,			/*tp_setattr*/
    (cmpfunc)PySwigPacked_compare,	/*tp_compare*/
    (reprfunc)PySwigPacked_repr,	/*tp_repr*/
    0,	                                /*tp_as_number*/
    0,					/*tp_as_sequence*/
    0,					/*tp_as_mapping*/
    (hashfunc)0,			/*tp_hash*/
    (ternaryfunc)0,			/*tp_call*/
    (reprfunc)PySwigPacked_str,		/*tp_str*/
    /* Space for future expansion */
    0L,0L,0L,0L,
    PySwigPacked_Type__doc__, 	        /* Documentation string */
#if PY_VERSION_HEX >= 0x02000000
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000         
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
    0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
    0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };

    PySwigPacked_Type = tmp;
    type_init = 1;
  }
  
      

  return &PySwigPacked_Type;
}

SWIGRUNTIME PyObject *
PySwigPacked_FromDataAndDesc(void *ptr, size_t size, const char *desc)
{
  PySwigPacked *self = PyObject_NEW(PySwigPacked, PySwigPacked_GetType());
  if (self == NULL) {
    return NULL;
  } else {
    void *pack = malloc(size);
    memcpy(pack, ptr, size);
    self->pack = pack;
    self->desc = desc;
    self->size = size;
    return (PyObject *) self;
  }
}

SWIGRUNTIMEINLINE const char *
PySwigPacked_UnpackData(PyObject *obj, void *ptr, size_t size)
{
  PySwigPacked *self = (PySwigPacked *)obj;
  if (self->size != size) return 0;
  memcpy(ptr, self->pack, size);
  return self->desc;
}

SWIGRUNTIMEINLINE const char *
PySwigPacked_GetDesc(PyObject *self)
{
  return ((PySwigPacked *)self)->desc;
}

SWIGRUNTIMEINLINE int
PySwigPacked_Check(PyObject *op) {
  return ((op)->ob_type == PySwigPacked_GetType()) 
    || (strcmp((op)->ob_type->tp_name,"PySwigPacked") == 0);
}

#else
/* -----------------------------------------------------------------------------
 * Use the old Python PyCObject instead of PySwigObject
 * ----------------------------------------------------------------------------- */

#define PySwigObject_GetDesc(obj)	           PyCObject_GetDesc(obj)
#define PySwigObject_Check(obj)	           PyCObject_Check(obj)
#define PySwigObject_AsVoidPtr(obj)	   PyCObject_AsVoidPtr(obj)
#define PySwigObject_FromVoidPtrAndDesc(p, d)  PyCObject_FromVoidPtrAndDesc(p, d, NULL)

#endif

#endif

/* -----------------------------------------------------------------------------
 * errors manipulation
 * ----------------------------------------------------------------------------- */

SWIGRUNTIME void
SWIG_Python_TypeError(const char *type, PyObject *obj)
{
  if (type) {
#if defined(SWIG_COBJECT_TYPES)
    if (PySwigObject_Check(obj)) {
      const char *otype = (const char *) PySwigObject_GetDesc(obj);
      if (otype) {
	PyErr_Format(PyExc_TypeError, "a '%s' is expected, 'PySwigObject(%s)' is received",
		     type, otype);
	return;
      }
    } else 
#endif      
    {
      const char *otype = (obj ? obj->ob_type->tp_name : 0); 
      if (otype) {
	PyObject *str = PyObject_Str(obj);
	const char *cstr = str ? PyString_AsString(str) : 0;
	if (cstr) {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s(%s)' is received",
		       type, otype, cstr);
	} else {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s' is received",
		       type, otype);
	}
	Py_DECREF(str);
	return;
      }
    }   
    PyErr_Format(PyExc_TypeError, "a '%s' is expected", type);
  } else {
    PyErr_Format(PyExc_TypeError, "unexpected type is received");
  }
}

SWIGRUNTIMEINLINE void
SWIG_Python_NullRef(const char *type)
{
  if (type) {
    PyErr_Format(PyExc_TypeError, "null reference of type '%s' was received",type);
  } else {
    PyErr_Format(PyExc_TypeError, "null reference was received");
  }
}

SWIGRUNTIME int
SWIG_Python_AddErrMesg(const char* mesg, int infront)
{
  if (PyErr_Occurred()) {
    PyObject *type = 0;
    PyObject *value = 0;
    PyObject *traceback = 0;
    PyErr_Fetch(&type, &value, &traceback);
    if (value) {
      PyObject *old_str = PyObject_Str(value);
      Py_XINCREF(type);
      PyErr_Clear();
      if (infront) {
	PyErr_Format(type, "%s %s", mesg, PyString_AsString(old_str));
      } else {
	PyErr_Format(type, "%s %s", PyString_AsString(old_str), mesg);
      }
      Py_DECREF(old_str);
    }
    return 1;
  } else {
    return 0;
  }
}

SWIGRUNTIME int
SWIG_Python_ArgFail(int argnum)
{
  if (PyErr_Occurred()) {
    /* add information about failing argument */
    char mesg[256];
    sprintf(mesg, "argument number %d:", argnum);
    return SWIG_Python_AddErrMesg(mesg, 1);
  } else {
    return 0;
  }
}


/* -----------------------------------------------------------------------------
 * pointers/data manipulation
 * ----------------------------------------------------------------------------- */

/* Convert a pointer value */
SWIGRUNTIME int
SWIG_Python_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  const char *c = 0;
  static PyObject *SWIG_this = 0;
  int    newref = 0;
  PyObject  *pyobj = 0;
  void *vptr;
  
  if (!obj) return 0;
  if (obj == Py_None) {
    *ptr = 0;
    return 0;
  }

#ifdef SWIG_COBJECT_TYPES
  if (!(PySwigObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PySwigObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  }  
  vptr = PySwigObject_AsVoidPtr(obj);
  c = (const char *) PySwigObject_GetDesc(obj);
  if (newref) { Py_DECREF(obj); }
  goto type_check;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AS_STRING(obj);
  /* Pointer values must start with leading underscore */
  c = SWIG_UnpackVoidPtr(c, &vptr, ty->name);
  if (newref) { Py_DECREF(obj); }
  if (!c) goto type_error;
#endif

type_check:

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,vptr);
  } else {
    *ptr = vptr;
  }

  if ((pyobj) && (flags & SWIG_POINTER_DISOWN)) {
    PyObject_SetAttrString(pyobj,(char*)"thisown",Py_False);
  }
  return 0;

type_error:
  PyErr_Clear();
  if (pyobj && !obj) {    
    obj = pyobj;
    if (PyCFunction_Check(obj)) {
      /* here we get the method pointer for callbacks */
      char *doc = (((PyCFunctionObject *)obj) -> m_ml -> ml_doc);
      c = doc ? strstr(doc, "swig_ptr: ") : 0;
      if (c) {
	c = SWIG_UnpackVoidPtr(c + 10, &vptr, ty->name);
	if (!c) goto type_error;
	goto type_check;
      }
    }
  }
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
    } else {
      SWIG_Python_TypeError("C/C++ pointer", obj);
    }
  }
  return -1;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME void *
SWIG_Python_MustGetPtr(PyObject *obj, swig_type_info *ty, int argnum, int flags) {
  void *result;
  if (SWIG_Python_ConvertPtr(obj, &result, ty, flags) == -1) {
    PyErr_Clear();
    if (flags & SWIG_POINTER_EXCEPTION) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
      SWIG_Python_ArgFail(argnum);
    }
  }
  return result;
}

/* Convert a packed value value */
SWIGRUNTIME int
SWIG_Python_ConvertPacked(PyObject *obj, void *ptr, size_t sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  const char *c = 0;

#if defined(SWIG_COBJECT_TYPES) && !defined(SWIG_COBJECT_PYTHON)
  c = PySwigPacked_UnpackData(obj, ptr, sz);
#else
  if ((!obj) || (!PyString_Check(obj))) goto type_error;
  c = PyString_AS_STRING(obj);
  /* Pointer values must start with leading underscore */
  c = SWIG_UnpackDataName(c, ptr, sz, ty->name);
#endif
  if (!c) goto type_error;
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return 0;

type_error:
  PyErr_Clear();
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
    } else {
      SWIG_Python_TypeError("C/C++ packed data", obj);
    }
  }
  return -1;
}  

/* Create a new array object */
SWIGRUNTIME PyObject *
SWIG_Python_NewPointerObj(void *ptr, swig_type_info *type, int own) {
  PyObject *robj = 0;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PySwigObject_FromVoidPtrAndDesc((void *) ptr, (char *)type->name);
#else
  {
    char result[SWIG_BUFFER_SIZE];
    robj = SWIG_PackVoidPtr(result, ptr, type->name, sizeof(result)) ?
      PyString_FromString(result) : 0;
  }
#endif
  if (!robj || (robj == Py_None)) return robj;
  if (type->clientdata) {
    PyObject *inst;
    PyObject *args = Py_BuildValue((char*)"(O)", robj);
    Py_DECREF(robj);
    inst = PyObject_CallObject((PyObject *) type->clientdata, args);
    Py_DECREF(args);
    if (inst) {
      if (own) {
        PyObject_SetAttrString(inst,(char*)"thisown",Py_True);
      }
      robj = inst;
    }
  }
  return robj;
}

SWIGRUNTIME PyObject *
SWIG_Python_NewPackedObj(void *ptr, size_t sz, swig_type_info *type) {
  PyObject *robj = 0;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#if defined(SWIG_COBJECT_TYPES) && !defined(SWIG_COBJECT_PYTHON)
  robj = PySwigPacked_FromDataAndDesc((void *) ptr, sz, (char *)type->name);
#else
  {
    char result[SWIG_BUFFER_SIZE];
    robj = SWIG_PackDataName(result, ptr, sz, type->name, sizeof(result)) ?
      PyString_FromString(result) : 0;
  }
#endif
  return robj;
}

/* -----------------------------------------------------------------------------*
 *  Get type list 
 * -----------------------------------------------------------------------------*/

#ifdef SWIG_LINK_RUNTIME
void *SWIG_ReturnGlobalTypeList(void *);
#endif

SWIGRUNTIME swig_type_info **
SWIG_Python_GetTypeListHandle() {
  static void *type_pointer = (void *)0;
  /* first check if module already created */
  if (!type_pointer) {
#ifdef SWIG_LINK_RUNTIME
    type_pointer = SWIG_ReturnGlobalTypeList((void *)0);
#else
    type_pointer = PyCObject_Import((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
				    (char*)"type_pointer" SWIG_TYPE_TABLE_NAME);
    if (PyErr_Occurred()) {
      PyErr_Clear();
      type_pointer = (void *)0;
    }
  }
#endif
  return (swig_type_info **) type_pointer;
}

/*
  Search for a swig_type_info structure
 */
SWIGRUNTIMEINLINE swig_type_info *
SWIG_Python_GetTypeList() {
  swig_type_info **tlh = SWIG_Python_GetTypeListHandle();
  return tlh ? *tlh : (swig_type_info*)0;
}

#define SWIG_Runtime_GetTypeList SWIG_Python_GetTypeList 

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_std__size_t swig_types[0] 
#define  SWIGTYPE_size_t swig_types[1] 
#define  SWIGTYPE_p_XmlManager swig_types[2] 
#define  SWIGTYPE_p_XmlResults swig_types[3] 
#define  SWIGTYPE_p_XmlUpdateContext swig_types[4] 
#define  SWIGTYPE_p_XmlQueryContext swig_types[5] 
#define  SWIGTYPE_p_XmlIndexSpecification swig_types[6] 
#define  SWIGTYPE_p_XmlValue swig_types[7] 
#define  SWIGTYPE_p_XmlStatistics swig_types[8] 
#define  SWIGTYPE_p_unsigned_int swig_types[9] 
#define  SWIGTYPE_p_char swig_types[10] 
#define  SWIGTYPE_p_XmlResolver swig_types[11] 
#define  SWIGTYPE_p_XmlInputStream swig_types[12] 
#define  SWIGTYPE_p_XmlMetaData swig_types[13] 
#define  SWIGTYPE_p_XmlQueryExpression swig_types[14] 
#define  SWIGTYPE_p_DbTxn swig_types[15] 
#define  SWIGTYPE_std__ptrdiff_t swig_types[16] 
#define  SWIGTYPE_ptrdiff_t swig_types[17] 
#define  SWIGTYPE_p_XmlContainer swig_types[18] 
#define  SWIGTYPE_p_DbEnv swig_types[19] 
#define  SWIGTYPE_p_XmlModify swig_types[20] 
#define  SWIGTYPE_p_XmlTransaction swig_types[21] 
#define  SWIGTYPE_p_XmlDocument swig_types[22] 
#define  SWIGTYPE_p_XmlData swig_types[23] 
#define  SWIGTYPE_p_int swig_types[24] 
#define  SWIGTYPE_p_XmlMetaDataIterator swig_types[25] 
#define  SWIGTYPE_p_XmlIndexDeclaration swig_types[26] 
static swig_type_info *swig_types[28];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= _dbxml.so
  ------------------------------------------------*/
#define SWIG_init    init_dbxml

#define SWIG_name    "_dbxml"

#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_exception_(int code, const char *msg) {
  switch(code) {
  case SWIG_MemoryError:
    PyErr_SetString(PyExc_MemoryError,msg);
    break;
  case SWIG_IOError:
    PyErr_SetString(PyExc_IOError,msg);
    break;
  case SWIG_RuntimeError:
    PyErr_SetString(PyExc_RuntimeError,msg);
    break;
  case SWIG_IndexError:
    PyErr_SetString(PyExc_IndexError,msg);
    break;
  case SWIG_TypeError:
    PyErr_SetString(PyExc_TypeError,msg);
    break;
  case SWIG_DivisionByZero:
    PyErr_SetString(PyExc_ZeroDivisionError,msg);
    break;
  case SWIG_OverflowError:
    PyErr_SetString(PyExc_OverflowError,msg);
    break;
  case SWIG_SyntaxError:
    PyErr_SetString(PyExc_SyntaxError,msg);
    break;
  case SWIG_ValueError:
    PyErr_SetString(PyExc_ValueError,msg);
    break;
  case SWIG_SystemError:
    PyErr_SetString(PyExc_SystemError,msg);
    break;
  default:
    PyErr_SetString(PyExc_RuntimeError,msg);
    break;
  }
}

#define SWIG_exception(a,b) { SWIG_exception_(a,b); SWIG_fail; }


#include <stdexcept>


#include "db_cxx.h"
#include "dbxml/DbXml.hpp"
#include <errno.h>
#include <fstream>

using namespace DbXml;

class XmlIndexDeclaration {
public:
	XmlIndexDeclaration() {}
	XmlIndexDeclaration(const std::string &uri, const std::string &name, const std::string &index) : uri(uri), name(name), index(index) {}
#ifndef SWIGJAVA	
	const std::string &get_uri() const { return uri; }
	const std::string &get_name() const { return name; }
	const std::string &get_index() const { return index; }
#endif
	std::string uri, name, index;
};

class XmlMetaData {
public:
	XmlMetaData() {}
	XmlMetaData(const std::string &uri, const std::string &name, const
		    XmlValue &value) : uri(uri), name(name), value(value) {}
	
	const std::string &get_uri() const { return uri; }
	const std::string &get_name() const { return name; }
	const XmlValue &get_value() const { return value; }
	std::string uri, name;
	XmlValue value;
};



#include <string>


static void throwPyUserException() {
	PyObject *type = 0;
	PyObject *value = 0;
	PyObject *traceback = 0;
	PyErr_Fetch(&type, &value, &traceback);
	if (value) {
		char buf[1024];
		PyObject *str = PyObject_Str(value);
		Py_XINCREF(type);
		PyErr_Clear();
		PyOS_snprintf(buf, sizeof(buf), "Error from Python user code: %s", PyString_AsString(str));
		Py_DECREF(str);
		//PyErr_Print();
		throw XmlException(XmlException::INTERNAL_ERROR,
				   buf);
	}
}


/* Copied from bsddb3 source. This will break if bsddb3 changes, but
   that would be very unlikely, since this is pretty much the standard
   way to do Python wrappers ;) */

typedef struct {
    PyObject_HEAD
    DB_ENV*     db_env;
    int         flags;             /* saved flags from open() */
    int         closed;
    int         getReturnsNone;
} DBEnvObject;

typedef struct {
    PyObject_HEAD
    DB_TXN*         txn;
} DBTxnObject;


  /*@/usr/local/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_int PyInt_FromLong
/*@@*/


SWIGINTERN PyObject *
SWIG_FromCharPtr(const char* cptr)
{ 
  if (cptr) {
    size_t size = strlen(cptr);
    if (size > INT_MAX) {
      return SWIG_NewPointerObj((char*)(cptr), 
				SWIG_TypeQuery("char *"), 0);
    } else {
      if (size != 0) {
	return PyString_FromStringAndSize(cptr, size);
      } else {
	return PyString_FromString(cptr);
      }
    }
  }
  Py_INCREF(Py_None);
  return Py_None;
}


#include <limits.h>


SWIGINTERNSHORT int
  SWIG_CheckUnsignedLongInRange(unsigned long value,
				unsigned long max_value,
				const char *errmsg) 
{
  if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError,
		   "value %lu is greater than '%s' minimum %lu",
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
 }


SWIGINTERN int
  SWIG_AsVal_unsigned_SS_long(PyObject *obj, unsigned long *val) 
{
  if (PyInt_Check(obj)) {
    long v = PyInt_AS_LONG(obj);
    if (v >= 0) {
      if (val) *val = v;
      return 1;
    }   
  }
  if (PyLong_Check(obj)) {
    unsigned long v = PyLong_AsUnsignedLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  } 
  if (val) {
    SWIG_type_error("unsigned long", obj);
  }
  return 0;
}


#if UINT_MAX != ULONG_MAX
SWIGINTERN int
  SWIG_AsVal_unsigned_SS_int(PyObject *obj, unsigned int *val)
{ 
  const char* errmsg = val ? "unsigned int" : (char*)0;
  unsigned long v;
  if (SWIG_AsVal_unsigned_SS_long(obj, &v)) {
    if (SWIG_CheckUnsignedLongInRange(v, INT_MAX, errmsg)) {
      if (val) *val = (unsigned int)(v);
      return 1;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    SWIG_type_error(errmsg, obj);
  }
  return 0;    
}
#else
SWIGINTERNSHORT unsigned int
  SWIG_AsVal_unsigned_SS_int(PyObject *obj, unsigned int *val)
{
  return SWIG_AsVal_unsigned_SS_long(obj,(unsigned long *)val);
}
#endif


SWIGINTERNSHORT unsigned int
SWIG_As_unsigned_SS_int(PyObject* obj)
{
  unsigned int v;
  if (!SWIG_AsVal_unsigned_SS_int(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(unsigned int));
  }
  return v;
}

  
SWIGINTERNSHORT int
SWIG_Check_unsigned_SS_int(PyObject* obj)
{
  return SWIG_AsVal_unsigned_SS_int(obj, (unsigned int*)0);
}


  /*@/usr/local/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_long PyInt_FromLong
/*@@*/


SWIGINTERNSHORT PyObject* 
  SWIG_From_unsigned_SS_long(unsigned long value)
{
  return (value > LONG_MAX) ?
    PyLong_FromUnsignedLong(value) 
    : PyInt_FromLong((long)(value)); 
}


#if UINT_MAX < LONG_MAX
/*@/usr/local/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_unsigned_SS_int SWIG_From_long
/*@@*/
#else
/*@/usr/local/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_unsigned_SS_int SWIG_From_unsigned_SS_long
/*@@*/
#endif


SWIGINTERN int
  SWIG_CheckLongInRange(long value, long min_value, long max_value,
			const char *errmsg)
{
  if (value < min_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError, 
		   "value %ld is less than '%s' minimum %ld", 
		   value, errmsg, min_value);
    }
    return 0;    
  } else if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError,
		   "value %ld is greater than '%s' maximum %ld", 
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
}


SWIGINTERN int
  SWIG_AsVal_long(PyObject * obj, long* val)
{
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AS_LONG(obj);
    return 1;
  }
  if (PyLong_Check(obj)) {
    long v = PyLong_AsLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  }
  if (val) {
    SWIG_type_error("long", obj);
  }
  return 0;
 }


#if INT_MAX != LONG_MAX
SWIGINTERN int
  SWIG_AsVal_int(PyObject *obj, int *val)
{ 
  const char* errmsg = val ? "int" : (char*)0;
  long v;
  if (SWIG_AsVal_long(obj, &v)) {
    if (SWIG_CheckLongInRange(v, INT_MIN,INT_MAX, errmsg)) {
      if (val) *val = (int)(v);
      return 1;
    } else {
      return 0;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    SWIG_type_error(errmsg, obj);
  }
  return 0;    
}
#else
SWIGINTERNSHORT int
  SWIG_AsVal_int(PyObject *obj, int *val)
{
  return SWIG_AsVal_long(obj,(long*)val);
}
#endif


SWIGINTERNSHORT int
SWIG_As_int(PyObject* obj)
{
  int v;
  if (!SWIG_AsVal_int(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(int));
  }
  return v;
}

  
SWIGINTERNSHORT int
SWIG_Check_int(PyObject* obj)
{
  return SWIG_AsVal_int(obj, (int*)0);
}


SWIGINTERNSHORT PyObject *
SWIG_FromCharArray(const char* carray, size_t size)
{
  if (size > INT_MAX) {
    return Py_None;    
  } else {
    return PyString_FromStringAndSize(carray, (int)(size));
  }
}


SWIGINTERNSHORT PyObject*
  SWIG_From_std_string(const std::string& s)
  {
    return SWIG_FromCharArray(s.data(), s.size());
  }


/* returns SWIG_OLDOBJ if the input is a raw char*, SWIG_PYSTR if is a PyString */
SWIGINTERN int
SWIG_AsCharPtrAndSize(PyObject *obj, char** cptr, size_t* psize)
{
  static swig_type_info* pchar_info = 0;
  char* vptr = 0;
  if (!pchar_info) pchar_info = SWIG_TypeQuery("char *");
  if (SWIG_ConvertPtr(obj, (void**)&vptr, pchar_info, 0) != -1) {
    if (cptr) *cptr = vptr;
    if (psize) *psize = vptr ? (strlen(vptr) + 1) : 0;
    return SWIG_OLDOBJ;
  } else {
    PyErr_Clear();
    if (PyString_Check(obj)) {
      if (cptr) {
	*cptr = PyString_AS_STRING(obj);
	if (psize) {
	  *psize = PyString_GET_SIZE(obj) + 1;
	}
      }
      return SWIG_PYSTR;
    }
  }
  if (cptr) {
    SWIG_type_error("char *", obj);
  }
  return 0;
}


  SWIGINTERN int
    SWIG_AsPtr_std_string(PyObject* obj, std::string **val)
    {
      static swig_type_info* string_info = SWIG_TypeQuery("std::string *");
      std::string *vptr;    
      if (SWIG_ConvertPtr(obj, (void**)&vptr, string_info, 0) != -1) {
	if (val) *val = vptr;
	return SWIG_OLDOBJ;
      } else {
	PyErr_Clear();
	char* buf = 0 ; size_t size = 0;
	if (SWIG_AsCharPtrAndSize(obj, &buf, &size)) {
	  if (buf) {
	    if (val) *val = new std::string(buf, size - 1);
	    return SWIG_NEWOBJ;
	  }
	} else {
	  PyErr_Clear();
	}  
	if (val) {
	  PyErr_SetString(PyExc_TypeError,"a string is expected");
	}
	return 0;
      }
    }

static XmlInputStream *XmlManager_createStdInInputStream(XmlManager const *self){
		return self->createStdInInputStream();
	}
static XmlInputStream *XmlManager_createLocalFileInputStream(XmlManager const *self,std::string const &filename){
		return self->createLocalFileInputStream(filename);
	}

SWIGINTERNSHORT int
SWIG_AsCharPtr(PyObject *obj, char **val)
{
  if (SWIG_AsCharPtrAndSize(obj, val, (size_t*)(0))) {
    return 1;
  }
  if (val) {
    PyErr_Clear();
    SWIG_type_error("char *", obj);
  }
  return 0;
}


SWIGINTERN int
  SWIG_AsVal_bool(PyObject *obj, bool *val)
{
  if (obj == Py_True) {
    if (val) *val = true;
    return 1;
  }
  if (obj == Py_False) {
    if (val) *val = false;
    return 1;
  }
  int res = 0;
  if (SWIG_AsVal_int(obj, &res)) {    
    if (val) *val = res ? true : false;
    return 1;
  } else {
    PyErr_Clear();
  }  
  if (val) {
    SWIG_type_error("bool", obj);
  }
  return 0;
}


SWIGINTERNSHORT bool
SWIG_As_bool(PyObject* obj)
{
  bool v;
  if (!SWIG_AsVal_bool(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(bool));
  }
  return v;
}

  
SWIGINTERNSHORT int
SWIG_Check_bool(PyObject* obj)
{
  return SWIG_AsVal_bool(obj, (bool*)0);
}

static XmlInputStream *XmlManager_createMemBufInputStream__SWIG_0(XmlManager const *self,char const *bytes,unsigned int const count,char const *id,bool const adopt=false){
		return self->createMemBufInputStream(bytes,
						     count,
						     id, adopt);
	}
static XmlInputStream *XmlManager_createMemBufInputStream__SWIG_2(XmlManager const *self,char const *bytes,unsigned int const count,bool const copyBuffer){
		return self->createMemBufInputStream(bytes,
						     count,
						     copyBuffer);
	}
static XmlInputStream *XmlManager_createURLInputStream__SWIG_0(XmlManager const *self,std::string const &baseId,std::string const &systemId,std::string const &publicId){
		return self->createURLInputStream(baseId, systemId, publicId);
	}
static XmlInputStream *XmlManager_createURLInputStream__SWIG_1(XmlManager const *self,std::string const &baseId,std::string const &systemId){
		return self->createURLInputStream(baseId, systemId);
	}
static XmlContainer *XmlManager_createContainer__SWIG_0(XmlManager *self,std::string const &name){
		return new XmlContainer(self->createContainer(name));
	}
static XmlContainer *XmlManager_createContainer__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &name){
		return new XmlContainer(self->createContainer(txn, name));
	}
static XmlContainer *XmlManager_openContainer__SWIG_0(XmlManager *self,XmlTransaction &txn,std::string const &name){
		return new XmlContainer(self->openContainer(txn, name));
	}
static XmlContainer *XmlManager_openContainer__SWIG_1(XmlManager *self,std::string const &name){
		return new XmlContainer(self->openContainer(name));
	}
static XmlContainer *XmlManager_createContainer__SWIG_2(XmlManager *self,std::string const &name,u_int32_t flags,enum XmlContainer::ContainerType type=XmlContainer::NodeContainer,int mode=0){
		return new XmlContainer(
			self->createContainer(name, flags, type, mode));
	 }
static XmlContainer *XmlManager_createContainer__SWIG_5(XmlManager *self,XmlTransaction &txn,std::string const &name,u_int32_t flags,enum XmlContainer::ContainerType type=XmlContainer::NodeContainer,int mode=0){
		return new XmlContainer(self->createContainer(txn, name, flags,
							      type, mode));
        }
static XmlContainer *XmlManager_openContainer__SWIG_2(XmlManager *self,std::string const &name,u_int32_t flags){
		return new XmlContainer(self->openContainer(name, flags));
        }
static XmlContainer *XmlManager_openContainer__SWIG_3(XmlManager *self,XmlTransaction &txn,std::string const &name,u_int32_t flags){
		return new XmlContainer(self->openContainer(txn, name, flags));
        }
static void XmlManager_dumpContainer(XmlManager *self,std::string const &name,char const *filename){
		std::ofstream out(filename);
		self->dumpContainer(name, &out);
		out.close();
	}
static void XmlManager_loadContainer(XmlManager *self,std::string const &name,char const *filename,XmlUpdateContext &uc){
		std::ifstream in(filename);
		unsigned long lineno = 0;
		self->loadContainer(name, &in, &lineno, uc);
		in.close();
	}
static void XmlManager_verifyContainer__SWIG_0(XmlManager *self,std::string const &name,char const *filename,u_int32_t flags=0){
		std::ofstream out;
		if (flags & DB_SALVAGE)
			out.open(filename);
		self->verifyContainer(name, &out, flags);
		if (flags & DB_SALVAGE)
			out.close();
	}
static XmlDocument *XmlManager_createDocument(XmlManager *self){
		return new XmlDocument(self->createDocument());
	}
static XmlQueryContext *XmlManager_createQueryContext__SWIG_0(XmlManager *self,enum XmlQueryContext::ReturnType rt,enum XmlQueryContext::EvaluationType et){
		return new XmlQueryContext(self->createQueryContext(rt, et));
	}
static XmlQueryContext *XmlManager_createQueryContext__SWIG_1(XmlManager *self){
		return new XmlQueryContext(self->createQueryContext(
			XmlQueryContext::LiveValues, XmlQueryContext::Eager));
	}
static XmlQueryContext *XmlManager_createQueryContext__SWIG_2(XmlManager *self,enum XmlQueryContext::ReturnType rt){
		return new XmlQueryContext(self->createQueryContext(rt, XmlQueryContext::Eager));
	}
static XmlUpdateContext *XmlManager_createUpdateContext(XmlManager *self){
		return new XmlUpdateContext(self->createUpdateContext());
	}
static XmlQueryExpression *XmlManager_prepare__SWIG_0(XmlManager *self,std::string const &query,XmlQueryContext &context){
		return new XmlQueryExpression(self->prepare(query, context));
	}
static XmlQueryExpression *XmlManager_prepare__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context){
		return new XmlQueryExpression(self->prepare(
						      txn,query, context));
	}
static XmlResults *XmlManager_query__SWIG_0(XmlManager *self,std::string const &query,XmlQueryContext &context,u_int32_t flags){
		return new XmlResults(self->query(query, context, flags));
	}
static XmlResults *XmlManager_query__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context,u_int32_t flags){
		return new XmlResults(self->query(txn, query, context, flags));
	}
static XmlResults *XmlManager_query__SWIG_2(XmlManager *self,std::string const &query,XmlQueryContext &context){
		return new XmlResults(self->query(query, context, 0));
	}
static XmlResults *XmlManager_query__SWIG_3(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context){
		return new XmlResults(self->query(txn, query, context, 0));
	}
static XmlResults *XmlManager_createResults(XmlManager *self){
		return new XmlResults(self->createResults());
	}
static XmlModify *XmlManager_createModify(XmlManager *self){
		return new XmlModify(self->createModify());
	}
static XmlTransaction *XmlManager_createTransaction__SWIG_0(XmlManager *self,DbTxn *toAdopt){
		return new XmlTransaction(self->createTransaction(toAdopt));
        }
static XmlTransaction *XmlManager_createTransaction__SWIG_1(XmlManager *self,u_int32_t flags){
		return new XmlTransaction(self->createTransaction(flags));
	}
static XmlTransaction *XmlManager_createTransaction__SWIG_2(XmlManager *self){
		return new XmlTransaction(self->createTransaction((u_int32_t)0));
        }
static void XmlManager_setLogLevel(enum LogLevel level,bool enabled){
		DbXml::setLogLevel(level, enabled);
	}
static void XmlManager_setLogCategory(enum LogCategory category,bool enabled){
		DbXml::setLogCategory(category, enabled);
	}
static int XmlManager_get_version_major(){
		int major;
		(void)dbxml_version(&major, NULL, NULL);
		return major;
	}
static int XmlManager_get_version_minor(){
		int minor;
		(void)dbxml_version(NULL, &minor, NULL);
		return minor;
	}
static int XmlManager_get_version_patch(){
		int patch;
		(void)dbxml_version(NULL, NULL, &patch);
		return patch;
	}
static char const *XmlManager_get_version_string(){
		return dbxml_version(NULL, NULL, NULL);
	}

SWIGINTERNSHORT PyObject*
  SWIG_From_bool(bool value)
{
  PyObject *obj = value ? Py_True : Py_False;
  Py_INCREF(obj);
  return obj;
}

static XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_0(XmlContainer const *self){
		return new XmlIndexSpecification(self->getIndexSpecification());
	}
static XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_1(XmlContainer const *self,XmlTransaction &txn){
		 return new XmlIndexSpecification(
			 self->getIndexSpecification(txn));
        }
static XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_2(XmlContainer const *self,XmlTransaction &txn,u_int32_t flags){
		 return new XmlIndexSpecification(
			 self->getIndexSpecification(txn, flags));
	 }
static XmlDocument *XmlContainer_getDocument__SWIG_0(XmlContainer *self,std::string const &name){
		return new XmlDocument(self->getDocument(name, 0));
	}
static XmlDocument *XmlContainer_getDocument__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &name){
		return new XmlDocument(self->getDocument(txn, name, 0));
	}
static XmlDocument *XmlContainer_getDocument__SWIG_2(XmlContainer *self,std::string const &name,u_int32_t flags){
		return new XmlDocument(self->getDocument(name, flags));
	}
static XmlDocument *XmlContainer_getDocument__SWIG_3(XmlContainer *self,XmlTransaction &txn,std::string const &name,u_int32_t flags){
		return new XmlDocument(self->getDocument(txn, name, flags));
	}
static XmlResults *XmlContainer_getAllDocuments__SWIG_0(XmlContainer *self,u_int32_t flags){
		   return new XmlResults(self->getAllDocuments(flags));
	}
static XmlResults *XmlContainer_getAllDocuments__SWIG_1(XmlContainer *self,XmlTransaction &txn,u_int32_t flags){
		   return new XmlResults(self->getAllDocuments(txn, flags));
	}
static XmlResults *XmlContainer_lookupIndex__SWIG_0(XmlContainer *self,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
		return new XmlResults(
			self->lookupIndex(context, uri, name, index,
					  value, flags));
	}
static XmlResults *XmlContainer_lookupIndex__SWIG_3(XmlContainer *self,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
		return new XmlResults(self->lookupIndex(context, uri, name,
							parent_uri, parent_name,
							index, value, flags));
	}
static XmlResults *XmlContainer_lookupIndex__SWIG_6(XmlContainer *self,XmlTransaction &txn,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
                return new XmlResults(self->lookupIndex(txn, context, uri, name,
							index, value, flags));
        }
static XmlResults *XmlContainer_lookupIndex__SWIG_9(XmlContainer *self,XmlTransaction &txn,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
	        return new XmlResults(self->lookupIndex(txn, context, uri, name,
							parent_uri, parent_name,
							index, value, flags));
	}
static XmlStatistics *XmlContainer_lookupStatistics__SWIG_0(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(uri, name, index,
								value));
	}
static XmlStatistics *XmlContainer_lookupStatistics__SWIG_2(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(uri, name,
								parent_uri,
								parent_name,
								index, value));
	}
static XmlStatistics *XmlContainer_lookupStatistics__SWIG_4(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(txn, uri, name,
								index, value));
	}
static XmlStatistics *XmlContainer_lookupStatistics__SWIG_6(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(txn, uri, name,
								parent_uri,
								parent_name,
								index, value));
	}
static std::string XmlDocument_getContentAsString(XmlDocument const *self){
		std::string s;
		return self->getContent(s);
	}
static XmlData const *XmlDocument_getContent(XmlDocument const *self){
		return new XmlData(self->getContent());
	}
static XmlMetaDataIterator *XmlDocument_getMetaDataIterator(XmlDocument const *self){
		return new XmlMetaDataIterator(self->getMetaDataIterator());
	}
static XmlMetaData *XmlMetaDataIterator_next(XmlMetaDataIterator *self){
		XmlMetaData *idecl = new XmlMetaData;
		if (self->next(idecl->uri, idecl->name, idecl->value))
			return idecl;
		else
			delete idecl;
		return NULL;
	}
static XmlValue *XmlQueryContext_getVariableValue(XmlQueryContext const *self,std::string const &name){
		XmlValue *value = new XmlValue;
		if (self->getVariableValue(name, *value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
static XmlValue *XmlResults_next__SWIG_0(XmlResults *self){
		XmlValue *value = new XmlValue;
		if (self->next(*value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
static XmlValue *XmlResults_previous__SWIG_0(XmlResults *self){
		XmlValue *value = new XmlValue;
		if (self->previous(*value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
static XmlValue *XmlResults_peek__SWIG_0(XmlResults *self){
		XmlValue *value = new XmlValue;
		if (self->peek(*value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}

SWIGINTERN int
  SWIG_AsVal_double(PyObject *obj, double *val)
{
  if (PyFloat_Check(obj)) {
    if (val) *val = PyFloat_AS_DOUBLE(obj);
    return 1;
  }  
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AS_LONG(obj);
    return 1;
  }
  if (PyLong_Check(obj)) {
    double v = PyLong_AsDouble(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  }
  if (val) {
    SWIG_type_error("double", obj);
  }
  return 0;
}


SWIGINTERNSHORT double
SWIG_As_double(PyObject* obj)
{
  double v;
  if (!SWIG_AsVal_double(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(double));
  }
  return v;
}

  
SWIGINTERNSHORT int
SWIG_Check_double(PyObject* obj)
{
  return SWIG_AsVal_double(obj, (double*)0);
}


  /*@/usr/local/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_double PyFloat_FromDouble
/*@@*/


  /*@/usr/local/share/swig/1.3.24/python/pymacros.swg,66,SWIG_define@*/
#define SWIG_From_short PyInt_FromLong
/*@@*/

static XmlValue *XmlValue_getParentNode(XmlValue const *self){
		return new XmlValue(self->getParentNode());
	}
static XmlValue *XmlValue_getFirstChild(XmlValue const *self){
		return new XmlValue(self->getFirstChild());
	}
static XmlValue *XmlValue_getLastChild(XmlValue const *self){
		return new XmlValue(self->getLastChild());
	}
static XmlValue *XmlValue_getPreviousSibling(XmlValue const *self){
		return new XmlValue(self->getPreviousSibling());
	}
static XmlValue *XmlValue_getNextSibling(XmlValue const *self){
		return new XmlValue(self->getNextSibling());
	}
static XmlResults *XmlValue_getAttributes(XmlValue const *self){
		return new XmlResults(self->getAttributes());
	}
static XmlValue *XmlValue_getOwnerElement(XmlValue const *self){
		return new XmlValue(self->getOwnerElement());
	}
static void XmlValue_setValue(XmlValue &to,XmlValue const &from){
		to = from;
	}
static XmlIndexDeclaration *XmlIndexSpecification_find(XmlIndexSpecification *self,std::string const &uri,std::string const &name){
		XmlIndexDeclaration *idecl =
			new XmlIndexDeclaration(uri, name, "");
		if (self->find(idecl->uri, idecl->name, idecl->index))
			return idecl;
		else {
			delete idecl;
			return NULL;
		}
	}
static XmlIndexDeclaration *XmlIndexSpecification_next(XmlIndexSpecification *self){
		XmlIndexDeclaration *idecl = new XmlIndexDeclaration;
		if (self->next(idecl->uri, idecl->name, idecl->index))
			return idecl;
		else {
			delete idecl;
			return NULL;
		}
	}
static XmlResults *XmlQueryExpression_execute__SWIG_0(XmlQueryExpression const *self,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(context, flags));
	}
static XmlResults *XmlQueryExpression_execute__SWIG_2(XmlQueryExpression const *self,XmlValue const &contextItem,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(
			self->execute(contextItem, context, flags));
	}
static XmlResults *XmlQueryExpression_execute__SWIG_4(XmlQueryExpression const *self,XmlTransaction &txn,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(txn, context, flags));
	}
static XmlResults *XmlQueryExpression_execute__SWIG_6(XmlQueryExpression const *self,XmlTransaction &txn,XmlValue const &contextItem,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(txn, contextItem,
						    context, flags));
	}
static void XmlInputStream_freeMemory(XmlInputStream *self){
		delete self;
	}
static XmlTransaction *XmlTransaction_createChild__SWIG_0(XmlTransaction *self,u_int32_t flags=0){
		return new XmlTransaction(self->createChild(flags));
	}
static void XmlTransaction_commit__SWIG_1(XmlTransaction *self){
	  self->commit(0);
	}


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "dbxml_python_wrap.h"

/***********************************************************************
 * director.swg
 *
 *     This file contains support for director classes that proxy
 *     method calls from C++ to Python extensions.
 *
 * Author : Mark Rose (mrose@stm.lbl.gov)
 ************************************************************************/

#ifdef __cplusplus

namespace Swig {
  /* base class for director exceptions */
  DirectorException::~DirectorException() {
  }

  /* simple thread abstraction for pthreads on win32 */
  Director::~Director() {
    swig_decref(); 
  }

  bool Director::swig_up = false;

#ifdef __PTHREAD__
  MUTEX_INIT(Director::swig_mutex_up);
  pthread_t Director::swig_mutex_thread;
  bool Director::swig_mutex_active = false;
#endif

}

#endif /* __cplusplus */

SwigDirector_XmlInputStream::SwigDirector_XmlInputStream(PyObject* self) : Swig::Director(self) {
    
}



unsigned int SwigDirector_XmlInputStream::curPos() const {
    unsigned int c_result ;
    PyObject *result;
    
    if (swig_get_up()) {
        throw Swig::DirectorPureVirtualException();
    }
    result = PyObject_CallMethod(swig_get_self(), (char *)"curPos", NULL);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
                throwPyUserException();
            }
        }
    }
    {
        c_result = (unsigned int)(SWIG_As_unsigned_SS_int(result));
        if (PyErr_Occurred()) 
        throw Swig::DirectorTypeMismatchException("Error converting Python object using SWIG_As_unsigned_SS_int");
    }
    Py_XDECREF(result);
    return (unsigned int) c_result;
}


unsigned int SwigDirector_XmlInputStream::readBytes(char *toFill, unsigned int const maxToRead) {
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    unsigned int c_result ;
    PyObject *result;
    
    if (swig_get_up()) {
        throw Swig::DirectorPureVirtualException();
    }
    obj0 = SWIG_NewPointerObj((char*)(toFill), SWIGTYPE_p_char, 0);
    {
        obj1 = SWIG_From_unsigned_SS_int((unsigned int)(maxToRead)); 
    }
    result = PyObject_CallMethod(swig_get_self(), (char *)"readBytes", (char *)"(OO)" ,obj0,obj1);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
                throwPyUserException();
            }
        }
    }
    {
        c_result = (unsigned int)(SWIG_As_unsigned_SS_int(result));
        if (PyErr_Occurred()) 
        throw Swig::DirectorTypeMismatchException("Error converting Python object using SWIG_As_unsigned_SS_int");
    }
    Py_XDECREF(obj0);
    Py_XDECREF(obj1);
    Py_XDECREF(result);
    return (unsigned int) c_result;
}


SwigDirector_XmlInputStream::~SwigDirector_XmlInputStream() {
}

SwigDirector_XmlResolver::SwigDirector_XmlResolver(PyObject *self): XmlResolver(), Swig::Director(self) {
    
}



bool SwigDirector_XmlResolver::resolveDocument(XmlTransaction *txn, XmlManager &mgr, std::string const &uri, XmlValue &res) const {
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    bool c_result ;
    PyObject *result;
    
    if (swig_get_up()) {
        return XmlResolver::resolveDocument(txn,mgr,uri,res);
    }
    obj0 = SWIG_NewPointerObj(txn, SWIGTYPE_p_XmlTransaction, 0);
    obj1 = SWIG_NewPointerObj(&mgr, SWIGTYPE_p_XmlManager, 0);
    {
        obj2 = SWIG_From_std_string((std::string)(uri)); 
    }
    obj3 = SWIG_NewPointerObj(&res, SWIGTYPE_p_XmlValue, 0);
    result = PyObject_CallMethod(swig_get_self(), (char *)"resolveDocument", (char *)"(OOOO)" ,obj0,obj1,obj2,obj3);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
                throwPyUserException();
            }
        }
    }
    {
        c_result = (bool)(SWIG_As_bool(result));
        if (PyErr_Occurred()) 
        throw Swig::DirectorTypeMismatchException("Error converting Python object using SWIG_As_bool");
    }
    Py_XDECREF(obj0);
    Py_XDECREF(obj1);
    Py_XDECREF(obj2);
    Py_XDECREF(obj3);
    Py_XDECREF(result);
    return (bool) c_result;
}


SwigDirector_XmlResolver::~SwigDirector_XmlResolver() {
}

bool SwigDirector_XmlResolver::resolveCollection(XmlTransaction *txn, XmlManager &mgr, std::string const &uri, XmlResults &res) const {
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    bool c_result ;
    PyObject *result;
    
    if (swig_get_up()) {
        return XmlResolver::resolveCollection(txn,mgr,uri,res);
    }
    obj0 = SWIG_NewPointerObj(txn, SWIGTYPE_p_XmlTransaction, 0);
    obj1 = SWIG_NewPointerObj(&mgr, SWIGTYPE_p_XmlManager, 0);
    {
        obj2 = SWIG_From_std_string((std::string)(uri)); 
    }
    obj3 = SWIG_NewPointerObj(&res, SWIGTYPE_p_XmlResults, 0);
    result = PyObject_CallMethod(swig_get_self(), (char *)"resolveCollection", (char *)"(OOOO)" ,obj0,obj1,obj2,obj3);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
                throwPyUserException();
            }
        }
    }
    {
        c_result = (bool)(SWIG_As_bool(result));
        if (PyErr_Occurred()) 
        throw Swig::DirectorTypeMismatchException("Error converting Python object using SWIG_As_bool");
    }
    Py_XDECREF(obj0);
    Py_XDECREF(obj1);
    Py_XDECREF(obj2);
    Py_XDECREF(obj3);
    Py_XDECREF(result);
    return (bool) c_result;
}


XmlInputStream *SwigDirector_XmlResolver::resolveSchema(XmlTransaction *txn, XmlManager &mgr, std::string const &schemaLocation, std::string const &nameSpace) const {
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    XmlInputStream *c_result ;
    PyObject *result;
    
    if (swig_get_up()) {
        return XmlResolver::resolveSchema(txn,mgr,schemaLocation,nameSpace);
    }
    obj0 = SWIG_NewPointerObj(txn, SWIGTYPE_p_XmlTransaction, 0);
    obj1 = SWIG_NewPointerObj(&mgr, SWIGTYPE_p_XmlManager, 0);
    {
        obj2 = SWIG_From_std_string((std::string)(schemaLocation)); 
    }
    {
        obj3 = SWIG_From_std_string((std::string)(nameSpace)); 
    }
    result = PyObject_CallMethod(swig_get_self(), (char *)"resolveSchema", (char *)"(OOOO)" ,obj0,obj1,obj2,obj3);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
                throwPyUserException();
            }
        }
    }
    if ((SWIG_ConvertPtr(result,(void **)(&c_result),
    SWIGTYPE_p_XmlInputStream,SWIG_POINTER_EXCEPTION | 0 )) == -1)
    throw Swig::DirectorTypeMismatchException("Pointer conversion failed.");
    Py_XDECREF(obj0);
    Py_XDECREF(obj1);
    Py_XDECREF(obj2);
    Py_XDECREF(obj3);
    Py_XDECREF(result);
    return (XmlInputStream *) c_result;
}


XmlInputStream *SwigDirector_XmlResolver::resolveEntity(XmlTransaction *txn, XmlManager &mgr, std::string const &systemId, std::string const &publicId) const {
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    XmlInputStream *c_result ;
    PyObject *result;
    
    if (swig_get_up()) {
        return XmlResolver::resolveEntity(txn,mgr,systemId,publicId);
    }
    obj0 = SWIG_NewPointerObj(txn, SWIGTYPE_p_XmlTransaction, 0);
    obj1 = SWIG_NewPointerObj(&mgr, SWIGTYPE_p_XmlManager, 0);
    {
        obj2 = SWIG_From_std_string((std::string)(systemId)); 
    }
    {
        obj3 = SWIG_From_std_string((std::string)(publicId)); 
    }
    result = PyObject_CallMethod(swig_get_self(), (char *)"resolveEntity", (char *)"(OOOO)" ,obj0,obj1,obj2,obj3);
    if (result == NULL) {
        PyObject *error = PyErr_Occurred();
        {
            if (error != NULL) {
                throwPyUserException();
            }
        }
    }
    if ((SWIG_ConvertPtr(result,(void **)(&c_result),
    SWIGTYPE_p_XmlInputStream,SWIG_POINTER_EXCEPTION | 0 )) == -1)
    throw Swig::DirectorTypeMismatchException("Pointer conversion failed.");
    Py_XDECREF(obj0);
    Py_XDECREF(obj1);
    Py_XDECREF(obj2);
    Py_XDECREF(obj3);
    Py_XDECREF(result);
    return (XmlInputStream *) c_result;
}


#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_new_XmlManager__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlManager")) goto fail;
    {
        try {
            result = (XmlManager *)new XmlManager();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlManager, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlManager__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    u_int32_t arg1 ;
    XmlManager *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlManager",&obj0)) goto fail;
    {
        arg1 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlManager *)new XmlManager(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlManager, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlManager__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    DbEnv *arg1 = (DbEnv *) 0 ;
    u_int32_t arg2 ;
    XmlManager *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:new_XmlManager",&obj0,&obj1)) goto fail;
    {
        arg1 = (obj0 == Py_None) ? 
        NULL : DbEnv::wrap_DB_ENV(((DBEnvObject *)obj0)->db_env);
    }
    {
        arg2 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (XmlManager *)new XmlManager(arg1,arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlManager, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlManager(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlManager__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        _v = SWIG_Check_unsigned_SS_int(argv[0]);
        if (_v) {
            return _wrap_new_XmlManager__SWIG_1(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            /* This would be a typecheck for a DbEnv *; just succeed */
            _v = 1; 
        }
        if (_v) {
            _v = SWIG_Check_unsigned_SS_int(argv[1]);
            if (_v) {
                return _wrap_new_XmlManager__SWIG_2(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlManager'");
    return NULL;
}


static PyObject *_wrap_delete_XmlManager(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlManager",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_setDefaultContainerFlags(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    u_int32_t arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_setDefaultContainerFlags",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->setDefaultContainerFlags(arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_getDefaultContainerFlags(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    u_int32_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_getDefaultContainerFlags",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (u_int32_t)(arg1)->getDefaultContainerFlags();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_setDefaultPageSize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    u_int32_t arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_setDefaultPageSize",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->setDefaultPageSize(arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_getDefaultPageSize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    u_int32_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_getDefaultPageSize",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (u_int32_t)(arg1)->getDefaultPageSize();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_setDefaultContainerType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    enum XmlContainer::ContainerType arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_setDefaultContainerType",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlContainer::ContainerType)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->setDefaultContainerType((enum XmlContainer::ContainerType )arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_getDefaultContainerType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    enum XmlContainer::ContainerType result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_getDefaultContainerType",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (enum XmlContainer::ContainerType)(arg1)->getDefaultContainerType();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_From_int((result));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_getDbEnv(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    DbEnv *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_getDbEnv",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (DbEnv *)(arg1)->getDbEnv();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_DbEnv, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_getHome(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_getHome",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                std::string const &_result_ref = ((XmlManager const *)arg1)->getHome();
                result = (std::string *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(*result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_registerResolver(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlResolver *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_registerResolver",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlResolver, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlResolver");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->registerResolver((XmlResolver const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_removeContainer__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_removeContainer",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            (arg1)->removeContainer((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_removeContainer__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_removeContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            (arg1)->removeContainer(*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_removeContainer(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[4];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_XmlManager_removeContainer__SWIG_0(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    return _wrap_XmlManager_removeContainer__SWIG_1(self,args);
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_removeContainer'");
    return NULL;
}


static PyObject *_wrap_XmlManager_renameContainer__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_renameContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            (arg1)->renameContainer((std::string const &)*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_renameContainer__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_renameContainer",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        try {
            (arg1)->renameContainer(*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlManager_renameContainer(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    return _wrap_XmlManager_renameContainer__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        return _wrap_XmlManager_renameContainer__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_renameContainer'");
    return NULL;
}


static PyObject *_wrap_XmlManager_upgradeContainer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_upgradeContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->upgradeContainer((std::string const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_createStdInInputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlInputStream *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_createStdInInputStream",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlInputStream *)XmlManager_createStdInInputStream((XmlManager const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createLocalFileInputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    XmlInputStream *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_createLocalFileInputStream",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (XmlInputStream *)XmlManager_createLocalFileInputStream((XmlManager const *)arg1,(std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 0);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_createMemBufInputStream__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    char *arg2 = (char *) 0 ;
    unsigned int arg3 ;
    char *arg4 = (char *) 0 ;
    bool arg5 ;
    XmlInputStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlManager_createMemBufInputStream",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = (unsigned int const)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    if (!SWIG_AsCharPtr(obj3, (char**)&arg4)) {
        SWIG_arg_fail(4);SWIG_fail;
    }
    {
        arg5 = (bool const)(SWIG_As_bool(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_0((XmlManager const *)arg1,(char const *)arg2,arg3,(char const *)arg4,arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createMemBufInputStream__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    char *arg2 = (char *) 0 ;
    unsigned int arg3 ;
    char *arg4 = (char *) 0 ;
    XmlInputStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_createMemBufInputStream",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = (unsigned int const)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    if (!SWIG_AsCharPtr(obj3, (char**)&arg4)) {
        SWIG_arg_fail(4);SWIG_fail;
    }
    {
        try {
            result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_0((XmlManager const *)arg1,(char const *)arg2,arg3,(char const *)arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createMemBufInputStream__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    char *arg2 = (char *) 0 ;
    unsigned int arg3 ;
    bool arg4 ;
    XmlInputStream *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_createMemBufInputStream",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = (unsigned int const)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (bool const)(SWIG_As_bool(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_2((XmlManager const *)arg1,(char const *)arg2,arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createMemBufInputStream(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[6];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsCharPtr(argv[1], (char **)(0));
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    _v = SWIG_AsCharPtr(argv[3], (char **)(0));
                    if (_v) {
                        return _wrap_XmlManager_createMemBufInputStream__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsCharPtr(argv[1], (char **)(0));
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    _v = SWIG_Check_bool(argv[3]);
                    if (_v) {
                        return _wrap_XmlManager_createMemBufInputStream__SWIG_2(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsCharPtr(argv[1], (char **)(0));
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    _v = SWIG_AsCharPtr(argv[3], (char **)(0));
                    if (_v) {
                        _v = SWIG_Check_bool(argv[4]);
                        if (_v) {
                            return _wrap_XmlManager_createMemBufInputStream__SWIG_0(self,args);
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_createMemBufInputStream'");
    return NULL;
}


static PyObject *_wrap_XmlManager_createURLInputStream__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlInputStream *result;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_createURLInputStream",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        try {
            result = (XmlInputStream *)XmlManager_createURLInputStream__SWIG_0((XmlManager const *)arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 0);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlManager_createURLInputStream__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlInputStream *result;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_createURLInputStream",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            result = (XmlInputStream *)XmlManager_createURLInputStream__SWIG_1((XmlManager const *)arg1,(std::string const &)*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 0);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_createURLInputStream(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    return _wrap_XmlManager_createURLInputStream__SWIG_1(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        return _wrap_XmlManager_createURLInputStream__SWIG_0(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_createURLInputStream'");
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    XmlContainer *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_createContainer",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_createContainer__SWIG_0(arg1,(std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlContainer *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_createContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_createContainer__SWIG_1(arg1,*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_openContainer__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlContainer *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_openContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_openContainer__SWIG_0(arg1,*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_openContainer__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    XmlContainer *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_openContainer",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_openContainer__SWIG_1(arg1,(std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    u_int32_t arg3 ;
    enum XmlContainer::ContainerType arg4 ;
    int arg5 ;
    XmlContainer *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlManager_createContainer",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        arg3 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (enum XmlContainer::ContainerType)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (int)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_createContainer__SWIG_2(arg1,(std::string const &)*arg2,arg3,(enum XmlContainer::ContainerType )arg4,arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    u_int32_t arg3 ;
    enum XmlContainer::ContainerType arg4 ;
    XmlContainer *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_createContainer",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        arg3 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (enum XmlContainer::ContainerType)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_createContainer__SWIG_2(arg1,(std::string const &)*arg2,arg3,(enum XmlContainer::ContainerType )arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer__SWIG_4(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    u_int32_t arg3 ;
    XmlContainer *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_createContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        arg3 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_createContainer__SWIG_2(arg1,(std::string const &)*arg2,arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer__SWIG_5(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    u_int32_t arg4 ;
    enum XmlContainer::ContainerType arg5 ;
    int arg6 ;
    XmlContainer *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlManager_createContainer",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (enum XmlContainer::ContainerType)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = (int)(SWIG_As_int(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_createContainer__SWIG_5(arg1,*arg2,(std::string const &)*arg3,arg4,(enum XmlContainer::ContainerType )arg5,arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer__SWIG_6(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    u_int32_t arg4 ;
    enum XmlContainer::ContainerType arg5 ;
    XmlContainer *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlManager_createContainer",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (enum XmlContainer::ContainerType)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_createContainer__SWIG_5(arg1,*arg2,(std::string const &)*arg3,arg4,(enum XmlContainer::ContainerType )arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer__SWIG_7(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    u_int32_t arg4 ;
    XmlContainer *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_createContainer",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_createContainer__SWIG_5(arg1,*arg2,(std::string const &)*arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_createContainer(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[7];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_XmlManager_createContainer__SWIG_0(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    return _wrap_XmlManager_createContainer__SWIG_1(self,args);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    return _wrap_XmlManager_createContainer__SWIG_4(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlManager_createContainer__SWIG_7(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    _v = SWIG_Check_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlManager_createContainer__SWIG_3(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        _v = SWIG_Check_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlManager_createContainer__SWIG_6(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    _v = SWIG_Check_int(argv[3]);
                    if (_v) {
                        _v = SWIG_Check_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlManager_createContainer__SWIG_2(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        _v = SWIG_Check_int(argv[4]);
                        if (_v) {
                            _v = SWIG_Check_int(argv[5]);
                            if (_v) {
                                return _wrap_XmlManager_createContainer__SWIG_5(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_createContainer'");
    return NULL;
}


static PyObject *_wrap_XmlManager_openContainer__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    u_int32_t arg3 ;
    XmlContainer *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_openContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        arg3 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_openContainer__SWIG_2(arg1,(std::string const &)*arg2,arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_openContainer__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    u_int32_t arg4 ;
    XmlContainer *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_openContainer",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)XmlManager_openContainer__SWIG_3(arg1,*arg2,(std::string const &)*arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_openContainer(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_XmlManager_openContainer__SWIG_1(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    return _wrap_XmlManager_openContainer__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    return _wrap_XmlManager_openContainer__SWIG_2(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlManager_openContainer__SWIG_3(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_openContainer'");
    return NULL;
}


static PyObject *_wrap_XmlManager_dumpContainer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    char *arg3 = (char *) 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_dumpContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) {
        SWIG_arg_fail(3);SWIG_fail;
    }
    {
        try {
            XmlManager_dumpContainer(arg1,(std::string const &)*arg2,(char const *)arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_loadContainer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    char *arg3 = (char *) 0 ;
    XmlUpdateContext *arg4 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_loadContainer",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) {
        SWIG_arg_fail(3);SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            XmlManager_loadContainer(arg1,(std::string const &)*arg2,(char const *)arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_verifyContainer__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    char *arg3 = (char *) 0 ;
    u_int32_t arg4 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_verifyContainer",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) {
        SWIG_arg_fail(3);SWIG_fail;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            XmlManager_verifyContainer__SWIG_0(arg1,(std::string const &)*arg2,(char const *)arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_verifyContainer__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    char *arg3 = (char *) 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_verifyContainer",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    if (!SWIG_AsCharPtr(obj2, (char**)&arg3)) {
        SWIG_arg_fail(3);SWIG_fail;
    }
    {
        try {
            XmlManager_verifyContainer__SWIG_0(arg1,(std::string const &)*arg2,(char const *)arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_verifyContainer(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsCharPtr(argv[2], (char **)(0));
                if (_v) {
                    return _wrap_XmlManager_verifyContainer__SWIG_1(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsCharPtr(argv[2], (char **)(0));
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlManager_verifyContainer__SWIG_0(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_verifyContainer'");
    return NULL;
}


static PyObject *_wrap_XmlManager_createDocument(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlDocument *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_createDocument",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlDocument *)XmlManager_createDocument(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlDocument, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createQueryContext__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    enum XmlQueryContext::ReturnType arg2 ;
    enum XmlQueryContext::EvaluationType arg3 ;
    XmlQueryContext *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_createQueryContext",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlQueryContext::ReturnType)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum XmlQueryContext::EvaluationType)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlQueryContext *)XmlManager_createQueryContext__SWIG_0(arg1,(enum XmlQueryContext::ReturnType )arg2,(enum XmlQueryContext::EvaluationType )arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryContext, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createQueryContext__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlQueryContext *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_createQueryContext",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlQueryContext *)XmlManager_createQueryContext__SWIG_1(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryContext, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createQueryContext__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    enum XmlQueryContext::ReturnType arg2 ;
    XmlQueryContext *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_createQueryContext",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlQueryContext::ReturnType)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (XmlQueryContext *)XmlManager_createQueryContext__SWIG_2(arg1,(enum XmlQueryContext::ReturnType )arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryContext, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createQueryContext(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[4];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlManager_createQueryContext__SWIG_1(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_int(argv[1]);
            if (_v) {
                return _wrap_XmlManager_createQueryContext__SWIG_2(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_int(argv[1]);
            if (_v) {
                _v = SWIG_Check_int(argv[2]);
                if (_v) {
                    return _wrap_XmlManager_createQueryContext__SWIG_0(self,args);
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_createQueryContext'");
    return NULL;
}


static PyObject *_wrap_XmlManager_createUpdateContext(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlUpdateContext *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_createUpdateContext",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlUpdateContext *)XmlManager_createUpdateContext(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlUpdateContext, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_prepare__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    XmlQueryExpression *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_prepare",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlQueryExpression *)XmlManager_prepare__SWIG_0(arg1,(std::string const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryExpression, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_prepare__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlQueryContext *arg4 = 0 ;
    XmlQueryExpression *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_prepare",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlQueryExpression *)XmlManager_prepare__SWIG_1(arg1,*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryExpression, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_prepare(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlManager_prepare__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlManager_prepare__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_prepare'");
    return NULL;
}


static PyObject *_wrap_XmlManager_query__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    u_int32_t arg4 ;
    XmlResults *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_query",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlManager_query__SWIG_0(arg1,(std::string const &)*arg2,*arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_query__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlQueryContext *arg4 = 0 ;
    u_int32_t arg5 ;
    XmlResults *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlManager_query",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlManager_query__SWIG_1(arg1,*arg2,(std::string const &)*arg3,*arg4,arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_query__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    std::string *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    XmlResults *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlManager_query",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlManager_query__SWIG_2(arg1,(std::string const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlManager_query__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlQueryContext *arg4 = 0 ;
    XmlResults *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlManager_query",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlManager_query__SWIG_3(arg1,*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlManager_query(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[6];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlManager_query__SWIG_2(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlManager_query__SWIG_3(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlManager_query__SWIG_0(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        _v = SWIG_Check_unsigned_SS_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlManager_query__SWIG_1(self,args);
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_query'");
    return NULL;
}


static PyObject *_wrap_XmlManager_createResults(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_createResults",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlResults *)XmlManager_createResults(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createModify(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlModify *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_createModify",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlModify *)XmlManager_createModify(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlModify, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createTransaction__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlTransaction *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_createTransaction",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (obj1 == Py_None) ?
        NULL : DbTxn::wrap_DB_TXN(((DBTxnObject *)obj1)->txn);
    }
    {
        try {
            result = (XmlTransaction *)XmlManager_createTransaction__SWIG_0(arg1,arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlTransaction, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createTransaction__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    u_int32_t arg2 ;
    XmlTransaction *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_createTransaction",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (XmlTransaction *)XmlManager_createTransaction__SWIG_1(arg1,arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlTransaction, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createTransaction__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlManager *arg1 = (XmlManager *) 0 ;
    XmlTransaction *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlManager_createTransaction",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlTransaction *)XmlManager_createTransaction__SWIG_2(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlTransaction, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_createTransaction(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlManager_createTransaction__SWIG_2(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_unsigned_SS_int(argv[1]);
            if (_v) {
                return _wrap_XmlManager_createTransaction__SWIG_1(self,args);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlManager, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                /* This would be a typecheck for a DbTxn *; just succeed */
                _v = 1; 
            }
            if (_v) {
                return _wrap_XmlManager_createTransaction__SWIG_0(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlManager_createTransaction'");
    return NULL;
}


static PyObject *_wrap_XmlManager_setLogLevel(PyObject *, PyObject *args) {
    PyObject *resultobj;
    enum LogLevel arg1 ;
    bool arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_setLogLevel",&obj0,&obj1)) goto fail;
    {
        arg1 = (enum LogLevel)(SWIG_As_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        arg2 = (bool)(SWIG_As_bool(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            XmlManager_setLogLevel((enum LogLevel )arg1,arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_setLogCategory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    enum LogCategory arg1 ;
    bool arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlManager_setLogCategory",&obj0,&obj1)) goto fail;
    {
        arg1 = (enum LogCategory)(SWIG_As_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        arg2 = (bool)(SWIG_As_bool(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            XmlManager_setLogCategory((enum LogCategory )arg1,arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_get_version_major(PyObject *, PyObject *args) {
    PyObject *resultobj;
    int result;
    
    if(!PyArg_ParseTuple(args,(char *)":XmlManager_get_version_major")) goto fail;
    {
        try {
            result = (int)XmlManager_get_version_major();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_get_version_minor(PyObject *, PyObject *args) {
    PyObject *resultobj;
    int result;
    
    if(!PyArg_ParseTuple(args,(char *)":XmlManager_get_version_minor")) goto fail;
    {
        try {
            result = (int)XmlManager_get_version_minor();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_get_version_patch(PyObject *, PyObject *args) {
    PyObject *resultobj;
    int result;
    
    if(!PyArg_ParseTuple(args,(char *)":XmlManager_get_version_patch")) goto fail;
    {
        try {
            result = (int)XmlManager_get_version_patch();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlManager_get_version_string(PyObject *, PyObject *args) {
    PyObject *resultobj;
    char *result;
    
    if(!PyArg_ParseTuple(args,(char *)":XmlManager_get_version_string")) goto fail;
    {
        try {
            result = (char *)XmlManager_get_version_string();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlManager_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlManager, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlContainer__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlContainer")) goto fail;
    {
        try {
            result = (XmlContainer *)new XmlContainer();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlContainer__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = 0 ;
    XmlContainer *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlContainer",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlContainer");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlContainer *)new XmlContainer((XmlContainer const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlContainer, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlContainer(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlContainer__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlContainer__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlContainer'");
    return NULL;
}


static PyObject *_wrap_delete_XmlContainer(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlContainer",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_sync(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlContainer_sync",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            (arg1)->sync();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_close(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlContainer_close",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            (arg1)->close();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_addAlias(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    bool result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlContainer_addAlias",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (bool)(arg1)->addAlias((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_removeAlias(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    bool result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlContainer_removeAlias",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (bool)(arg1)->removeAlias((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_getManager(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlManager *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlContainer_getManager",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                XmlManager &_result_ref = (arg1)->getManager();
                result = (XmlManager *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlManager, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getName(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlContainer_getName",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                std::string const &_result_ref = ((XmlContainer const *)arg1)->getName();
                result = (std::string *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(*result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getContainerType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    enum XmlContainer::ContainerType result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlContainer_getContainerType",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (enum XmlContainer::ContainerType)((XmlContainer const *)arg1)->getContainerType();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_From_int((result));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_setIndexSpecification__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlIndexSpecification *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_setIndexSpecification",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlIndexSpecification");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->setIndexSpecification((XmlIndexSpecification const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_addIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlUpdateContext *arg5 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_addIndex",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlContainer_addIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    enum XmlIndexSpecification::Type arg4 ;
    enum XmlValue::Type arg5 ;
    XmlUpdateContext *arg6 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_addIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (enum XmlIndexSpecification::Type)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (enum XmlValue::Type)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj5, (void **)&arg6, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(6)) SWIG_fail;
        if (arg6 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,(enum XmlIndexSpecification::Type )arg4,(enum XmlValue::Type )arg5,*arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlUpdateContext *arg5 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_deleteIndex",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlContainer_replaceIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlUpdateContext *arg5 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_replaceIndex",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlContainer_addDefaultIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_addDefaultIndex",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->addDefaultIndex((std::string const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteDefaultIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_deleteDefaultIndex",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteDefaultIndex((std::string const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_replaceDefaultIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_replaceDefaultIndex",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->replaceDefaultIndex((std::string const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_setIndexSpecification__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlIndexSpecification *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_setIndexSpecification",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlIndexSpecification");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->setIndexSpecification(*arg2,(XmlIndexSpecification const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_setIndexSpecification(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlContainer_setIndexSpecification__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_setIndexSpecification__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_setIndexSpecification'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_addIndex__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlUpdateContext *arg6 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_addIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj5, (void **)&arg6, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(6)) SWIG_fail;
        if (arg6 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            (arg1)->addIndex(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,*arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlContainer_addIndex__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    enum XmlIndexSpecification::Type arg5 ;
    enum XmlValue::Type arg6 ;
    XmlUpdateContext *arg7 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOO:XmlContainer_addIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        arg5 = (enum XmlIndexSpecification::Type)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = (enum XmlValue::Type)(SWIG_As_int(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj6, (void **)&arg7, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(7)) SWIG_fail;
        if (arg7 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
    }
    {
        try {
            (arg1)->addIndex(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(enum XmlIndexSpecification::Type )arg5,(enum XmlValue::Type )arg6,*arg7);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlContainer_addIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[8];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 7); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            return _wrap_XmlContainer_addIndex__SWIG_0(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            {
                                void *ptr = 0;
                                if (SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                    _v = 0;
                                    PyErr_Clear();
                                } else {
                                    _v = (ptr != 0);
                                }
                            }
                            if (_v) {
                                return _wrap_XmlContainer_addIndex__SWIG_2(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_int(argv[3]);
                    if (_v) {
                        _v = SWIG_Check_int(argv[4]);
                        if (_v) {
                            {
                                void *ptr = 0;
                                if (SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                    _v = 0;
                                    PyErr_Clear();
                                } else {
                                    _v = (ptr != 0);
                                }
                            }
                            if (_v) {
                                return _wrap_XmlContainer_addIndex__SWIG_1(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 7) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_Check_int(argv[4]);
                        if (_v) {
                            _v = SWIG_Check_int(argv[5]);
                            if (_v) {
                                {
                                    void *ptr = 0;
                                    if (SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                        _v = 0;
                                        PyErr_Clear();
                                    } else {
                                        _v = (ptr != 0);
                                    }
                                }
                                if (_v) {
                                    return _wrap_XmlContainer_addIndex__SWIG_3(self,args);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_addIndex'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlUpdateContext *arg6 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_deleteIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj5, (void **)&arg6, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(6)) SWIG_fail;
        if (arg6 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteIndex(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,*arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[7];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            return _wrap_XmlContainer_deleteIndex__SWIG_0(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            {
                                void *ptr = 0;
                                if (SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                    _v = 0;
                                    PyErr_Clear();
                                } else {
                                    _v = (ptr != 0);
                                }
                            }
                            if (_v) {
                                return _wrap_XmlContainer_deleteIndex__SWIG_1(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_deleteIndex'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_replaceIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlUpdateContext *arg6 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_replaceIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj5, (void **)&arg6, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(6)) SWIG_fail;
        if (arg6 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            (arg1)->replaceIndex(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,*arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlContainer_replaceIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[7];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            return _wrap_XmlContainer_replaceIndex__SWIG_0(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            {
                                void *ptr = 0;
                                if (SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                    _v = 0;
                                    PyErr_Clear();
                                } else {
                                    _v = (ptr != 0);
                                }
                            }
                            if (_v) {
                                return _wrap_XmlContainer_replaceIndex__SWIG_1(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_replaceIndex'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_addDefaultIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_addDefaultIndex",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->addDefaultIndex(*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_addDefaultIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlContainer_addDefaultIndex__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_addDefaultIndex__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_addDefaultIndex'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteDefaultIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_deleteDefaultIndex",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteDefaultIndex(*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteDefaultIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlContainer_deleteDefaultIndex__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_deleteDefaultIndex__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_deleteDefaultIndex'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_replaceDefaultIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_replaceDefaultIndex",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->replaceDefaultIndex(*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_replaceDefaultIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlContainer_replaceDefaultIndex__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_replaceDefaultIndex__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_replaceDefaultIndex'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlDocument *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    u_int32_t arg4 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->putDocument(*arg2,*arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlDocument *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_putDocument",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->putDocument(*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    u_int32_t arg5 ;
    std::string result;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->putDocument((std::string const &)*arg2,(std::string const &)*arg3,*arg4,arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    std::string result;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->putDocument((std::string const &)*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteDocument__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlDocument *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_deleteDocument",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteDocument(*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteDocument__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_deleteDocument",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteDocument((std::string const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_updateDocument__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlDocument *arg2 = 0 ;
    XmlUpdateContext *arg3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_updateDocument",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->updateDocument(*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_4(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    XmlInputStream *arg3 = (XmlInputStream *) 0 ;
    XmlUpdateContext *arg4 = 0 ;
    u_int32_t arg5 ;
    std::string result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(3)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->putDocument((std::string const &)*arg2,arg3,*arg4,arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_5(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    XmlInputStream *arg3 = (XmlInputStream *) 0 ;
    XmlUpdateContext *arg4 = 0 ;
    std::string result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(3)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->putDocument((std::string const &)*arg2,arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_6(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlInputStream *arg4 = (XmlInputStream *) 0 ;
    XmlUpdateContext *arg5 = 0 ;
    u_int32_t arg6 ;
    std::string result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(4)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,arg4,*arg5,arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_7(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlInputStream *arg4 = (XmlInputStream *) 0 ;
    XmlUpdateContext *arg5 = 0 ;
    std::string result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(4)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_8(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlDocument *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    u_int32_t arg5 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            (arg1)->putDocument(*arg2,*arg3,*arg4,arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_9(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlDocument *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->putDocument(*arg2,*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_10(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlUpdateContext *arg5 = 0 ;
    u_int32_t arg6 ;
    std::string result;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5,arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument__SWIG_11(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlUpdateContext *arg5 = 0 ;
    std::string result;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_putDocument",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlContainer_putDocument(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[7];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlContainer_putDocument__SWIG_1(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlContainer_putDocument__SWIG_0(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_putDocument__SWIG_9(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlInputStream, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_putDocument__SWIG_5(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_putDocument__SWIG_3(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        _v = SWIG_Check_unsigned_SS_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlContainer_putDocument__SWIG_8(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlInputStream, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            return _wrap_XmlContainer_putDocument__SWIG_7(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            return _wrap_XmlContainer_putDocument__SWIG_11(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlInputStream, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        _v = SWIG_Check_unsigned_SS_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlContainer_putDocument__SWIG_4(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        _v = SWIG_Check_unsigned_SS_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlContainer_putDocument__SWIG_2(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlInputStream, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            _v = SWIG_Check_unsigned_SS_int(argv[5]);
                            if (_v) {
                                return _wrap_XmlContainer_putDocument__SWIG_6(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            _v = SWIG_Check_unsigned_SS_int(argv[5]);
                            if (_v) {
                                return _wrap_XmlContainer_putDocument__SWIG_10(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_putDocument'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteDocument__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlDocument *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_deleteDocument",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteDocument(*arg2,*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteDocument__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_deleteDocument",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteDocument(*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_deleteDocument(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlContainer_deleteDocument__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlContainer_deleteDocument__SWIG_1(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_deleteDocument__SWIG_2(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_deleteDocument__SWIG_3(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_deleteDocument'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_updateDocument__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlDocument *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_updateDocument",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->updateDocument(*arg2,*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_updateDocument(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlContainer_updateDocument__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlContainer_updateDocument__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_updateDocument'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_getNumDocuments__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    size_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlContainer_getNumDocuments",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (arg1)->getNumDocuments();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_long((unsigned long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getNumDocuments__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    size_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlContainer_getNumDocuments",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (arg1)->getNumDocuments(*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_long((unsigned long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getNumDocuments(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlContainer_getNumDocuments__SWIG_0(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                return _wrap_XmlContainer_getNumDocuments__SWIG_1(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_getNumDocuments'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_getIndexSpecification__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlIndexSpecification *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlContainer_getIndexSpecification",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_0((XmlContainer const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlIndexSpecification, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getIndexSpecification__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlIndexSpecification *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlContainer_getIndexSpecification",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_1((XmlContainer const *)arg1,*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlIndexSpecification, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getIndexSpecification__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    u_int32_t arg3 ;
    XmlIndexSpecification *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_getIndexSpecification",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_2((XmlContainer const *)arg1,*arg2,arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlIndexSpecification, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getIndexSpecification(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[4];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlContainer_getIndexSpecification__SWIG_0(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                return _wrap_XmlContainer_getIndexSpecification__SWIG_1(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    return _wrap_XmlContainer_getIndexSpecification__SWIG_2(self,args);
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_getIndexSpecification'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_getDocument__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    XmlDocument *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlContainer_getDocument",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (XmlDocument *)XmlContainer_getDocument__SWIG_0(arg1,(std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlDocument, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_getDocument__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlDocument *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_getDocument",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            result = (XmlDocument *)XmlContainer_getDocument__SWIG_1(arg1,*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlDocument, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_getDocument__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    u_int32_t arg3 ;
    XmlDocument *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_getDocument",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        arg3 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlDocument *)XmlContainer_getDocument__SWIG_2(arg1,(std::string const &)*arg2,arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlDocument, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlContainer_getDocument__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    u_int32_t arg4 ;
    XmlDocument *result;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_getDocument",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlDocument *)XmlContainer_getDocument__SWIG_3(arg1,*arg2,(std::string const &)*arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlDocument, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlContainer_getDocument(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_XmlContainer_getDocument__SWIG_0(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    return _wrap_XmlContainer_getDocument__SWIG_1(self,args);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    return _wrap_XmlContainer_getDocument__SWIG_2(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlContainer_getDocument__SWIG_3(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_getDocument'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_getAllDocuments__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    u_int32_t arg2 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlContainer_getAllDocuments",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_getAllDocuments__SWIG_0(arg1,arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getAllDocuments__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    u_int32_t arg3 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlContainer_getAllDocuments",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_getAllDocuments__SWIG_1(arg1,*arg2,arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlContainer_getAllDocuments(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[4];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_unsigned_SS_int(argv[1]);
            if (_v) {
                return _wrap_XmlContainer_getAllDocuments__SWIG_0(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    return _wrap_XmlContainer_getAllDocuments__SWIG_1(self,args);
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_getAllDocuments'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlQueryContext *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlValue *arg6 = 0 ;
    u_int32_t arg7 ;
    XmlResults *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj5, (void **)&arg6, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(6)) SWIG_fail;
        if (arg6 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        arg7 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj6)); 
        if (SWIG_arg_fail(7)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6,arg7);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlQueryContext *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlValue *arg6 = 0 ;
    XmlResults *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj5, (void **)&arg6, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(6)) SWIG_fail;
        if (arg6 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlQueryContext *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlResults *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlQueryContext *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    std::string *arg7 = 0 ;
    XmlValue *arg8 = 0 ;
    u_int32_t arg9 ;
    XmlResults *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    int res7 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    PyObject * obj8 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7,&obj8)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res7 = SWIG_AsPtr_std_string(obj6, &ptr);
        if (!res7) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj6);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
        arg7 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj7, (void **)&arg8, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(8)) SWIG_fail;
        if (arg8 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(8)) SWIG_fail;
    }
    {
        arg9 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj8)); 
        if (SWIG_arg_fail(9)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8,arg9);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_4(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlQueryContext *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    std::string *arg7 = 0 ;
    XmlValue *arg8 = 0 ;
    XmlResults *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    int res7 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res7 = SWIG_AsPtr_std_string(obj6, &ptr);
        if (!res7) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj6);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
        arg7 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj7, (void **)&arg8, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(8)) SWIG_fail;
        if (arg8 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(8)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_5(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlQueryContext *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    std::string *arg7 = 0 ;
    XmlResults *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    int res7 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res7 = SWIG_AsPtr_std_string(obj6, &ptr);
        if (!res7) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj6);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
        arg7 = ptr;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_6(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    XmlValue *arg7 = 0 ;
    u_int32_t arg8 ;
    XmlResults *result;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj6, (void **)&arg7, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(7)) SWIG_fail;
        if (arg7 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
    }
    {
        arg8 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj7)); 
        if (SWIG_arg_fail(8)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7,arg8);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_7(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    XmlValue *arg7 = 0 ;
    XmlResults *result;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj6, (void **)&arg7, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(7)) SWIG_fail;
        if (arg7 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_8(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    XmlResults *result;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_9(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    std::string *arg7 = 0 ;
    std::string *arg8 = 0 ;
    XmlValue *arg9 = 0 ;
    u_int32_t arg10 ;
    XmlResults *result;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    int res7 = 0 ;
    int res8 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    PyObject * obj8 = 0 ;
    PyObject * obj9 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7,&obj8,&obj9)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res7 = SWIG_AsPtr_std_string(obj6, &ptr);
        if (!res7) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj6);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
        arg7 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res8 = SWIG_AsPtr_std_string(obj7, &ptr);
        if (!res8) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj7);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(8)) SWIG_fail;
        arg8 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj8, (void **)&arg9, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(9)) SWIG_fail;
        if (arg9 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(9)) SWIG_fail;
    }
    {
        arg10 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj9)); 
        if (SWIG_arg_fail(10)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8,(XmlValue const &)*arg9,arg10);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    if (res8 == SWIG_NEWOBJ) delete arg8;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    if (res8 == SWIG_NEWOBJ) delete arg8;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_10(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    std::string *arg7 = 0 ;
    std::string *arg8 = 0 ;
    XmlValue *arg9 = 0 ;
    XmlResults *result;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    int res7 = 0 ;
    int res8 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    PyObject * obj8 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7,&obj8)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res7 = SWIG_AsPtr_std_string(obj6, &ptr);
        if (!res7) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj6);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
        arg7 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res8 = SWIG_AsPtr_std_string(obj7, &ptr);
        if (!res8) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj7);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(8)) SWIG_fail;
        arg8 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj8, (void **)&arg9, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(9)) SWIG_fail;
        if (arg9 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(9)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8,(XmlValue const &)*arg9);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    if (res8 == SWIG_NEWOBJ) delete arg8;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    if (res8 == SWIG_NEWOBJ) delete arg8;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex__SWIG_11(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    std::string *arg7 = 0 ;
    std::string *arg8 = 0 ;
    XmlResults *result;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    int res7 = 0 ;
    int res8 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOOO:XmlContainer_lookupIndex",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res7 = SWIG_AsPtr_std_string(obj6, &ptr);
        if (!res7) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj6);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
        arg7 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res8 = SWIG_AsPtr_std_string(obj7, &ptr);
        if (!res8) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj7);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(8)) SWIG_fail;
        arg8 = ptr;
    }
    {
        try {
            result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    if (res8 == SWIG_NEWOBJ) delete arg8;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    if (res8 == SWIG_NEWOBJ) delete arg8;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[11];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 10); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            return _wrap_XmlContainer_lookupIndex__SWIG_2(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            {
                                void *ptr = 0;
                                if (SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                    _v = 0;
                                    PyErr_Clear();
                                } else {
                                    _v = (ptr != 0);
                                }
                            }
                            if (_v) {
                                return _wrap_XmlContainer_lookupIndex__SWIG_1(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                return _wrap_XmlContainer_lookupIndex__SWIG_8(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 7) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            {
                                void *ptr = 0;
                                if (SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                    _v = 0;
                                    PyErr_Clear();
                                } else {
                                    _v = (ptr != 0);
                                }
                            }
                            if (_v) {
                                _v = SWIG_Check_unsigned_SS_int(argv[6]);
                                if (_v) {
                                    return _wrap_XmlContainer_lookupIndex__SWIG_0(self,args);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 7) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                {
                                    void *ptr = 0;
                                    if (SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                        _v = 0;
                                        PyErr_Clear();
                                    } else {
                                        _v = (ptr != 0);
                                    }
                                }
                                if (_v) {
                                    return _wrap_XmlContainer_lookupIndex__SWIG_7(self,args);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 7) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                _v = SWIG_AsPtr_std_string(argv[6], (std::string**)(0));
                                if (_v) {
                                    return _wrap_XmlContainer_lookupIndex__SWIG_5(self,args);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 8) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                _v = SWIG_AsPtr_std_string(argv[6], (std::string**)(0));
                                if (_v) {
                                    {
                                        void *ptr = 0;
                                        if (SWIG_ConvertPtr(argv[7], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                            _v = 0;
                                            PyErr_Clear();
                                        } else {
                                            _v = (ptr != 0);
                                        }
                                    }
                                    if (_v) {
                                        return _wrap_XmlContainer_lookupIndex__SWIG_4(self,args);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 8) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                {
                                    void *ptr = 0;
                                    if (SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                        _v = 0;
                                        PyErr_Clear();
                                    } else {
                                        _v = (ptr != 0);
                                    }
                                }
                                if (_v) {
                                    _v = SWIG_Check_unsigned_SS_int(argv[7]);
                                    if (_v) {
                                        return _wrap_XmlContainer_lookupIndex__SWIG_6(self,args);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 8) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                _v = SWIG_AsPtr_std_string(argv[6], (std::string**)(0));
                                if (_v) {
                                    _v = SWIG_AsPtr_std_string(argv[7], (std::string**)(0));
                                    if (_v) {
                                        return _wrap_XmlContainer_lookupIndex__SWIG_11(self,args);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 9) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                _v = SWIG_AsPtr_std_string(argv[6], (std::string**)(0));
                                if (_v) {
                                    _v = SWIG_AsPtr_std_string(argv[7], (std::string**)(0));
                                    if (_v) {
                                        {
                                            void *ptr = 0;
                                            if (SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                                _v = 0;
                                                PyErr_Clear();
                                            } else {
                                                _v = (ptr != 0);
                                            }
                                        }
                                        if (_v) {
                                            return _wrap_XmlContainer_lookupIndex__SWIG_10(self,args);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 9) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                _v = SWIG_AsPtr_std_string(argv[6], (std::string**)(0));
                                if (_v) {
                                    {
                                        void *ptr = 0;
                                        if (SWIG_ConvertPtr(argv[7], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                            _v = 0;
                                            PyErr_Clear();
                                        } else {
                                            _v = (ptr != 0);
                                        }
                                    }
                                    if (_v) {
                                        _v = SWIG_Check_unsigned_SS_int(argv[8]);
                                        if (_v) {
                                            return _wrap_XmlContainer_lookupIndex__SWIG_3(self,args);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 10) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                _v = SWIG_AsPtr_std_string(argv[6], (std::string**)(0));
                                if (_v) {
                                    _v = SWIG_AsPtr_std_string(argv[7], (std::string**)(0));
                                    if (_v) {
                                        {
                                            void *ptr = 0;
                                            if (SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                                _v = 0;
                                                PyErr_Clear();
                                            } else {
                                                _v = (ptr != 0);
                                            }
                                        }
                                        if (_v) {
                                            _v = SWIG_Check_unsigned_SS_int(argv[9]);
                                            if (_v) {
                                                return _wrap_XmlContainer_lookupIndex__SWIG_9(self,args);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_lookupIndex'");
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlValue *arg5 = 0 ;
    XmlStatistics *result;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_lookupStatistics",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(XmlValue const &)*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlStatistics *result;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlContainer_lookupStatistics",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        try {
            result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    XmlValue *arg7 = 0 ;
    XmlStatistics *result;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOO:XmlContainer_lookupStatistics",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj6, (void **)&arg7, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(7)) SWIG_fail;
        if (arg7 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
    }
    {
        try {
            result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_2(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    XmlStatistics *result;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_lookupStatistics",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        try {
            result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_2(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics__SWIG_4(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlValue *arg6 = 0 ;
    XmlStatistics *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlContainer_lookupStatistics",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj5, (void **)&arg6, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(6)) SWIG_fail;
        if (arg6 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_4(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics__SWIG_5(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlStatistics *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlContainer_lookupStatistics",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        try {
            result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_4(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics__SWIG_6(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    std::string *arg7 = 0 ;
    XmlValue *arg8 = 0 ;
    XmlStatistics *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    int res7 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    PyObject * obj7 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOOO:XmlContainer_lookupStatistics",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6,&obj7)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res7 = SWIG_AsPtr_std_string(obj6, &ptr);
        if (!res7) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj6);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
        arg7 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj7, (void **)&arg8, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(8)) SWIG_fail;
        if (arg8 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(8)) SWIG_fail;
    }
    {
        try {
            result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_6(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics__SWIG_7(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    XmlTransaction *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    std::string *arg6 = 0 ;
    std::string *arg7 = 0 ;
    XmlStatistics *result;
    int res3 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    int res6 = 0 ;
    int res7 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    PyObject * obj6 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOOO:XmlContainer_lookupStatistics",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5,&obj6)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlContainer, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res6 = SWIG_AsPtr_std_string(obj5, &ptr);
        if (!res6) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj5);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(6)) SWIG_fail;
        arg6 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res7 = SWIG_AsPtr_std_string(obj6, &ptr);
        if (!res7) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj6);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(7)) SWIG_fail;
        arg7 = ptr;
    }
    {
        try {
            result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_6(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    if (res6 == SWIG_NEWOBJ) delete arg6;
    if (res7 == SWIG_NEWOBJ) delete arg7;
    return NULL;
}


static PyObject *_wrap_XmlContainer_lookupStatistics(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[9];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 8); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        return _wrap_XmlContainer_lookupStatistics__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            return _wrap_XmlContainer_lookupStatistics__SWIG_5(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            return _wrap_XmlContainer_lookupStatistics__SWIG_0(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            {
                                void *ptr = 0;
                                if (SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                    _v = 0;
                                    PyErr_Clear();
                                } else {
                                    _v = (ptr != 0);
                                }
                            }
                            if (_v) {
                                return _wrap_XmlContainer_lookupStatistics__SWIG_4(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                return _wrap_XmlContainer_lookupStatistics__SWIG_3(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 7) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                _v = SWIG_AsPtr_std_string(argv[6], (std::string**)(0));
                                if (_v) {
                                    return _wrap_XmlContainer_lookupStatistics__SWIG_7(self,args);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 7) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                {
                                    void *ptr = 0;
                                    if (SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                        _v = 0;
                                        PyErr_Clear();
                                    } else {
                                        _v = (ptr != 0);
                                    }
                                }
                                if (_v) {
                                    return _wrap_XmlContainer_lookupStatistics__SWIG_2(self,args);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (argc == 8) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlContainer, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_AsPtr_std_string(argv[5], (std::string**)(0));
                            if (_v) {
                                _v = SWIG_AsPtr_std_string(argv[6], (std::string**)(0));
                                if (_v) {
                                    {
                                        void *ptr = 0;
                                        if (SWIG_ConvertPtr(argv[7], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                                            _v = 0;
                                            PyErr_Clear();
                                        } else {
                                            _v = (ptr != 0);
                                        }
                                    }
                                    if (_v) {
                                        return _wrap_XmlContainer_lookupStatistics__SWIG_6(self,args);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlContainer_lookupStatistics'");
    return NULL;
}


static PyObject * XmlContainer_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlContainer, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlDocument__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlDocument")) goto fail;
    {
        try {
            result = (XmlDocument *)new XmlDocument();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlDocument, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlDocument__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = 0 ;
    XmlDocument *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlDocument",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlDocument *)new XmlDocument((XmlDocument const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlDocument, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlDocument(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlDocument__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlDocument__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlDocument'");
    return NULL;
}


static PyObject *_wrap_delete_XmlDocument(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlDocument",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlDocument_setName(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlDocument_setName",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            (arg1)->setName((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlDocument_getName(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlDocument_getName",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlDocument const *)arg1)->getName();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlDocument_setContent(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    XmlData *arg2 = 0 ;
    XmlData xml_data2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlDocument_setContent",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        xml_data2.set_data(PyString_AsString(obj1));
        xml_data2.set_size(PyString_Size(obj1));
        arg2 = &xml_data2;
    }
    {
        try {
            (arg1)->setContent((XmlData const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlDocument_getContentAsXmlInputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    XmlInputStream *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlDocument_getContentAsXmlInputStream",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlInputStream *)((XmlDocument const *)arg1)->getContentAsXmlInputStream();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlDocument_setContentAsXmlInputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    XmlInputStream *arg2 = (XmlInputStream *) 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlDocument_setContentAsXmlInputStream",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    {
        try {
            (arg1)->setContentAsXmlInputStream(arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlDocument_fetchAllData(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlDocument_fetchAllData",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            (arg1)->fetchAllData();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlDocument_setMetaData__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlValue *arg4 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlDocument_setMetaData",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            (arg1)->setMetaData((std::string const &)*arg2,(std::string const &)*arg3,(XmlValue const &)*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlDocument_getMetaData__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlValue *arg4 = 0 ;
    bool result;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlDocument_getMetaData",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (bool)(arg1)->getMetaData((std::string const &)*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlDocument_removeMetaData(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlDocument_removeMetaData",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            (arg1)->removeMetaData((std::string const &)*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlDocument_setMetaData__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlData *arg4 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    XmlData xml_data4 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlDocument_setMetaData",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        xml_data4.set_data(PyString_AsString(obj3));
        xml_data4.set_size(PyString_Size(obj3));
        arg4 = &xml_data4;
    }
    {
        try {
            (arg1)->setMetaData((std::string const &)*arg2,(std::string const &)*arg3,(XmlData const &)*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlDocument_setMetaData(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlDocument_setMetaData__SWIG_0(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlData, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlDocument_setMetaData__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlDocument_setMetaData'");
    return NULL;
}


static PyObject *_wrap_XmlDocument_getMetaData__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlData *arg4 = 0 ;
    bool result;
    int res2 = 0 ;
    int res3 = 0 ;
    XmlData xml_data4 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlDocument_getMetaData",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        xml_data4.set_data(PyString_AsString(obj3));
        xml_data4.set_size(PyString_Size(obj3));
        arg4 = &xml_data4;
    }
    {
        try {
            result = (bool)(arg1)->getMetaData((std::string const &)*arg2,(std::string const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlDocument_getMetaData(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[5];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlDocument_getMetaData__SWIG_0(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlData, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlDocument_getMetaData__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlDocument_getMetaData'");
    return NULL;
}


static PyObject *_wrap_XmlDocument_getContentAsString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlDocument_getContentAsString",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = XmlDocument_getContentAsString((XmlDocument const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlDocument_getContent(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    XmlData *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlDocument_getContent",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlData *)XmlDocument_getContent((XmlDocument const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        if (result) {
            resultobj =
            PyString_FromStringAndSize((char *)result->get_data(),
            result->get_size());
            delete result; // done with new XmlData
        } else
        resultobj = NULL;
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlDocument_getMetaDataIterator(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    XmlMetaDataIterator *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlDocument_getMetaDataIterator",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlMetaDataIterator *)XmlDocument_getMetaDataIterator((XmlDocument const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlMetaDataIterator, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlDocument_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlDocument, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlMetaDataIterator(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaDataIterator *arg1 = 0 ;
    XmlMetaDataIterator *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlMetaDataIterator",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlMetaDataIterator, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlMetaDataIterator");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlMetaDataIterator *)new XmlMetaDataIterator((XmlMetaDataIterator const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlMetaDataIterator, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_XmlMetaDataIterator(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaDataIterator *arg1 = (XmlMetaDataIterator *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlMetaDataIterator",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlMetaDataIterator, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlMetaDataIterator_reset(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaDataIterator *arg1 = (XmlMetaDataIterator *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlMetaDataIterator_reset",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlMetaDataIterator, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            (arg1)->reset();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlMetaDataIterator_next(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaDataIterator *arg1 = (XmlMetaDataIterator *) 0 ;
    XmlMetaData *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlMetaDataIterator_next",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlMetaDataIterator, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlMetaData *)XmlMetaDataIterator_next(arg1);
            
            if (!result) {
                PyErr_SetString(PyExc_StopIteration,
                "End of results.");
                return NULL;
            }
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlMetaData, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlMetaDataIterator_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlMetaDataIterator, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_XmlMetaData(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaData *arg1 = (XmlMetaData *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlMetaData",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlMetaData, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlMetaData_get_uri(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaData *arg1 = (XmlMetaData *) 0 ;
    std::string *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlMetaData_get_uri",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlMetaData, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                std::string const &_result_ref = ((XmlMetaData const *)arg1)->get_uri();
                result = (std::string *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(*result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlMetaData_get_name(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaData *arg1 = (XmlMetaData *) 0 ;
    std::string *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlMetaData_get_name",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlMetaData, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                std::string const &_result_ref = ((XmlMetaData const *)arg1)->get_name();
                result = (std::string *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(*result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlMetaData_get_value(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaData *arg1 = (XmlMetaData *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlMetaData_get_value",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlMetaData, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                XmlValue const &_result_ref = ((XmlMetaData const *)arg1)->get_value();
                result = (XmlValue *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlMetaData(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlMetaData *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlMetaData")) goto fail;
    {
        try {
            result = (XmlMetaData *)new XmlMetaData();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlMetaData, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlMetaData_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlMetaData, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlQueryContext__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlQueryContext")) goto fail;
    {
        try {
            result = (XmlQueryContext *)new XmlQueryContext();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryContext, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlQueryContext__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = 0 ;
    XmlQueryContext *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlQueryContext",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlQueryContext *)new XmlQueryContext((XmlQueryContext const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryContext, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlQueryContext(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlQueryContext__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlQueryContext__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlQueryContext'");
    return NULL;
}


static PyObject *_wrap_delete_XmlQueryContext(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlQueryContext",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_setNamespace(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlQueryContext_setNamespace",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            (arg1)->setNamespace((std::string const &)*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_getNamespace(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    std::string result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlQueryContext_getNamespace",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (arg1)->getNamespace((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_removeNamespace(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlQueryContext_removeNamespace",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            (arg1)->removeNamespace((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_clearNamespaces(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlQueryContext_clearNamespaces",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            (arg1)->clearNamespaces();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_setVariableValue(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    XmlValue *arg3 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlQueryContext_setVariableValue",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->setVariableValue((std::string const &)*arg2,(XmlValue const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_setBaseURI(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlQueryContext_setBaseURI",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            (arg1)->setBaseURI((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_getBaseURI(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlQueryContext_getBaseURI",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlQueryContext const *)arg1)->getBaseURI();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_setReturnType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    enum XmlQueryContext::ReturnType arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlQueryContext_setReturnType",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlQueryContext::ReturnType)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->setReturnType((enum XmlQueryContext::ReturnType )arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_getReturnType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    enum XmlQueryContext::ReturnType result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlQueryContext_getReturnType",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (enum XmlQueryContext::ReturnType)((XmlQueryContext const *)arg1)->getReturnType();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_From_int((result));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_setEvaluationType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    enum XmlQueryContext::EvaluationType arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlQueryContext_setEvaluationType",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlQueryContext::EvaluationType)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->setEvaluationType((enum XmlQueryContext::EvaluationType )arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_getEvaluationType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    enum XmlQueryContext::EvaluationType result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlQueryContext_getEvaluationType",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (enum XmlQueryContext::EvaluationType)((XmlQueryContext const *)arg1)->getEvaluationType();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_From_int((result));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryContext_getVariableValue(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    XmlValue *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlQueryContext_getVariableValue",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (XmlValue *)XmlQueryContext_getVariableValue((XmlQueryContext const *)arg1,(std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject * XmlQueryContext_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlQueryContext, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlResults__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlResults")) goto fail;
    {
        try {
            result = (XmlResults *)new XmlResults();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_XmlResults(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlResults",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlResults__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = 0 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlResults",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlResults");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)new XmlResults((XmlResults const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlResults(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlResults__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlResults__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlResults'");
    return NULL;
}


static PyObject *_wrap_XmlResults_hasNext(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlResults_hasNext",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)(arg1)->hasNext();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_hasPrevious(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlResults_hasPrevious",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)(arg1)->hasPrevious();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_next__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlResults_next",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlResults_next__SWIG_0(arg1);
            
            if (!result) {
                PyErr_SetString(PyExc_StopIteration,
                "End of results.");
                return NULL;
            }
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_previous__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlResults_previous",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlResults_previous__SWIG_0(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_peek__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlResults_peek",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlResults_peek__SWIG_0(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_next__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlDocument *arg2 = 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlResults_next",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (bool)(arg1)->next(*arg2);
            
            if (!result) {
                PyErr_SetString(PyExc_StopIteration,
                "End of results.");
                return NULL;
            }
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_next(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlResults_next__SWIG_0(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                return _wrap_XmlResults_next__SWIG_1(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlResults_next'");
    return NULL;
}


static PyObject *_wrap_XmlResults_previous__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlDocument *arg2 = 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlResults_previous",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (bool)(arg1)->previous(*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_previous(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlResults_previous__SWIG_0(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                return _wrap_XmlResults_previous__SWIG_1(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlResults_previous'");
    return NULL;
}


static PyObject *_wrap_XmlResults_peek__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlDocument *arg2 = 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlResults_peek",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (bool)(arg1)->peek(*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_peek(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlResults_peek__SWIG_0(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                return _wrap_XmlResults_peek__SWIG_1(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlResults_peek'");
    return NULL;
}


static PyObject *_wrap_XmlResults_reset(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlResults_reset",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            (arg1)->reset();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_size(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    size_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlResults_size",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlResults const *)arg1)->size();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_long((unsigned long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResults_add(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlValue *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlResults_add",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->add((XmlValue const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlResults_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlResults, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlUpdateContext__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlUpdateContext *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlUpdateContext")) goto fail;
    {
        try {
            result = (XmlUpdateContext *)new XmlUpdateContext();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlUpdateContext, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlUpdateContext__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlUpdateContext *arg1 = 0 ;
    XmlUpdateContext *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlUpdateContext",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlUpdateContext *)new XmlUpdateContext((XmlUpdateContext const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlUpdateContext, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlUpdateContext(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlUpdateContext__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlUpdateContext__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlUpdateContext'");
    return NULL;
}


static PyObject *_wrap_delete_XmlUpdateContext(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlUpdateContext *arg1 = (XmlUpdateContext *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlUpdateContext",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlUpdateContext_setApplyChangesToContainers(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlUpdateContext *arg1 = (XmlUpdateContext *) 0 ;
    bool arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlUpdateContext_setApplyChangesToContainers",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (bool)(SWIG_As_bool(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->setApplyChangesToContainers(arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlUpdateContext_getApplyChangesToContainers(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlUpdateContext *arg1 = (XmlUpdateContext *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlUpdateContext_getApplyChangesToContainers",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)((XmlUpdateContext const *)arg1)->getApplyChangesToContainers();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlUpdateContext_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlUpdateContext, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlValue__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlValue")) goto fail;
    {
        try {
            result = (XmlValue *)new XmlValue();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlValue__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlValue",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlValue *)new XmlValue((XmlValue const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlValue__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    std::string *arg1 = 0 ;
    XmlValue *result;
    int res1 = 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlValue",&obj0)) goto fail;
    {
        std::string *ptr = (std::string *)0;
        res1 = SWIG_AsPtr_std_string(obj0, &ptr);
        if (!res1) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj0);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
        arg1 = ptr;
    }
    {
        try {
            result = (XmlValue *)new XmlValue((std::string const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    if (res1 == SWIG_NEWOBJ) delete arg1;
    return resultobj;
    fail:
    if (res1 == SWIG_NEWOBJ) delete arg1;
    return NULL;
}


static PyObject *_wrap_new_XmlValue__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    double arg1 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlValue",&obj0)) goto fail;
    {
        arg1 = (double)(SWIG_As_double(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlValue *)new XmlValue(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlValue__SWIG_4(PyObject *, PyObject *args) {
    PyObject *resultobj;
    bool arg1 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlValue",&obj0)) goto fail;
    {
        arg1 = (bool)(SWIG_As_bool(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlValue *)new XmlValue(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlValue__SWIG_5(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlDocument *arg1 = 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlValue",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlDocument, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlDocument");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlValue *)new XmlValue((XmlDocument const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlValue__SWIG_6(PyObject *, PyObject *args) {
    PyObject *resultobj;
    enum XmlValue::Type arg1 ;
    std::string *arg2 = 0 ;
    XmlValue *result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:new_XmlValue",&obj0,&obj1)) goto fail;
    {
        arg1 = (enum XmlValue::Type)(SWIG_As_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = (XmlValue *)new XmlValue((enum XmlValue::Type )arg1,(std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_new_XmlValue__SWIG_7(PyObject *, PyObject *args) {
    PyObject *resultobj;
    enum XmlValue::Type arg1 ;
    XmlData *arg2 = 0 ;
    XmlValue *result;
    XmlData xml_data2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:new_XmlValue",&obj0,&obj1)) goto fail;
    {
        arg1 = (enum XmlValue::Type)(SWIG_As_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        xml_data2.set_data(PyString_AsString(obj1));
        xml_data2.set_size(PyString_Size(obj1));
        arg2 = &xml_data2;
    }
    {
        try {
            result = (XmlValue *)new XmlValue((enum XmlValue::Type )arg1,(XmlData const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlValue(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlValue__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlValue__SWIG_1(self,args);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlDocument, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlValue__SWIG_5(self,args);
        }
    }
    if (argc == 1) {
        int _v;
        _v = SWIG_Check_double(argv[0]);
        if (_v) {
            return _wrap_new_XmlValue__SWIG_3(self,args);
        }
    }
    if (argc == 1) {
        int _v;
        _v = SWIG_AsPtr_std_string(argv[0], (std::string**)(0));
        if (_v) {
            return _wrap_new_XmlValue__SWIG_2(self,args);
        }
    }
    if (argc == 1) {
        int _v;
        _v = SWIG_Check_bool(argv[0]);
        if (_v) {
            return _wrap_new_XmlValue__SWIG_4(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        _v = SWIG_Check_int(argv[0]);
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlData, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                return _wrap_new_XmlValue__SWIG_7(self,args);
            }
        }
    }
    if (argc == 2) {
        int _v;
        _v = SWIG_Check_int(argv[0]);
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_new_XmlValue__SWIG_6(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlValue'");
    return NULL;
}


static PyObject *_wrap_delete_XmlValue(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlValue",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    enum XmlValue::Type result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getType",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (enum XmlValue::Type)((XmlValue const *)arg1)->getType();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_From_int((result));
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_isNull(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_isNull",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)((XmlValue const *)arg1)->isNull();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_isType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    enum XmlValue::Type arg2 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlValue_isType",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlValue::Type)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (bool)((XmlValue const *)arg1)->isType((enum XmlValue::Type )arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_isNumber(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_isNumber",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)((XmlValue const *)arg1)->isNumber();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_isString(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_isString",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)((XmlValue const *)arg1)->isString();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_isBoolean(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_isBoolean",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)((XmlValue const *)arg1)->isBoolean();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_isNode(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_isNode",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)((XmlValue const *)arg1)->isNode();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_asNumber(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    double result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_asNumber",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (double)((XmlValue const *)arg1)->asNumber();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_double((double)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_asString__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_asString",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlValue const *)arg1)->asString();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_asString__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    std::string *arg2 = 0 ;
    std::string result;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlValue_asString",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            result = ((XmlValue const *)arg1)->asString((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlValue_asString(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlValue_asString__SWIG_0(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_XmlValue_asString__SWIG_1(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlValue_asString'");
    return NULL;
}


static PyObject *_wrap_XmlValue_asBoolean(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_asBoolean",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (bool)((XmlValue const *)arg1)->asBoolean();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_asDocument(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlDocument result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_asDocument",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlValue const *)arg1)->asDocument();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        XmlDocument * resultptr;
        resultptr = new XmlDocument((XmlDocument &)(result));
        resultobj = SWIG_NewPointerObj((void *)(resultptr), SWIGTYPE_p_XmlDocument, 1);
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_equals(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlValue *arg2 = 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlValue_equals",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (bool)((XmlValue const *)arg1)->equals((XmlValue const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getNodeName(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getNodeName",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlValue const *)arg1)->getNodeName();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getNodeValue(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getNodeValue",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlValue const *)arg1)->getNodeValue();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getNamespaceURI(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getNamespaceURI",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlValue const *)arg1)->getNamespaceURI();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getPrefix(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getPrefix",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlValue const *)arg1)->getPrefix();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getLocalName(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getLocalName",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlValue const *)arg1)->getLocalName();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getNodeType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    short result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getNodeType",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (short)((XmlValue const *)arg1)->getNodeType();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_short((short)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getParentNode(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getParentNode",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlValue_getParentNode((XmlValue const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getFirstChild(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getFirstChild",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlValue_getFirstChild((XmlValue const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getLastChild(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getLastChild",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlValue_getLastChild((XmlValue const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getPreviousSibling(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getPreviousSibling",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlValue_getPreviousSibling((XmlValue const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getNextSibling(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getNextSibling",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlValue_getNextSibling((XmlValue const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getAttributes(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getAttributes",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlResults *)XmlValue_getAttributes((XmlValue const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_getOwnerElement(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlValue *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlValue_getOwnerElement",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlValue *)XmlValue_getOwnerElement((XmlValue const *)arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlValue, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlValue_setValue(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlValue *arg1 = 0 ;
    XmlValue *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlValue_setValue",&obj0,&obj1)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            XmlValue_setValue(*arg1,(XmlValue const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlValue_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlValue, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlIndexSpecification(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlIndexSpecification")) goto fail;
    {
        try {
            result = (XmlIndexSpecification *)new XmlIndexSpecification();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlIndexSpecification, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_XmlIndexSpecification(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlIndexSpecification",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_addIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    enum XmlIndexSpecification::Type arg4 ;
    enum XmlValue::Type arg5 ;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlIndexSpecification_addIndex",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (enum XmlIndexSpecification::Type)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (enum XmlValue::Type)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,(enum XmlIndexSpecification::Type )arg4,(enum XmlValue::Type )arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_addIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlIndexSpecification_addIndex",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        try {
            (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_addIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[6];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        return _wrap_XmlIndexSpecification_addIndex__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_int(argv[3]);
                    if (_v) {
                        _v = SWIG_Check_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlIndexSpecification_addIndex__SWIG_0(self,args);
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlIndexSpecification_addIndex'");
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_deleteIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    enum XmlIndexSpecification::Type arg4 ;
    enum XmlValue::Type arg5 ;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlIndexSpecification_deleteIndex",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (enum XmlIndexSpecification::Type)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (enum XmlValue::Type)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,(enum XmlIndexSpecification::Type )arg4,(enum XmlValue::Type )arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_deleteIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlIndexSpecification_deleteIndex",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        try {
            (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_deleteIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[6];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        return _wrap_XmlIndexSpecification_deleteIndex__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_int(argv[3]);
                    if (_v) {
                        _v = SWIG_Check_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlIndexSpecification_deleteIndex__SWIG_0(self,args);
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlIndexSpecification_deleteIndex'");
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_replaceIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    enum XmlIndexSpecification::Type arg4 ;
    enum XmlValue::Type arg5 ;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlIndexSpecification_replaceIndex",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        arg4 = (enum XmlIndexSpecification::Type)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (enum XmlValue::Type)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,(enum XmlIndexSpecification::Type )arg4,(enum XmlValue::Type )arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_replaceIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    int res2 = 0 ;
    int res3 = 0 ;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlIndexSpecification_replaceIndex",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        try {
            (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_replaceIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[6];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        return _wrap_XmlIndexSpecification_replaceIndex__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                _v = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
                if (_v) {
                    _v = SWIG_Check_int(argv[3]);
                    if (_v) {
                        _v = SWIG_Check_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlIndexSpecification_replaceIndex__SWIG_0(self,args);
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlIndexSpecification_replaceIndex'");
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_addDefaultIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    enum XmlIndexSpecification::Type arg2 ;
    enum XmlValue::Type arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlIndexSpecification_addDefaultIndex",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlIndexSpecification::Type)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum XmlValue::Type)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->addDefaultIndex((enum XmlIndexSpecification::Type )arg2,(enum XmlValue::Type )arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_addDefaultIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlIndexSpecification_addDefaultIndex",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            (arg1)->addDefaultIndex((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_addDefaultIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[4];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_XmlIndexSpecification_addDefaultIndex__SWIG_1(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_int(argv[1]);
            if (_v) {
                _v = SWIG_Check_int(argv[2]);
                if (_v) {
                    return _wrap_XmlIndexSpecification_addDefaultIndex__SWIG_0(self,args);
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlIndexSpecification_addDefaultIndex'");
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_deleteDefaultIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    enum XmlIndexSpecification::Type arg2 ;
    enum XmlValue::Type arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlIndexSpecification_deleteDefaultIndex",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlIndexSpecification::Type)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum XmlValue::Type)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->deleteDefaultIndex((enum XmlIndexSpecification::Type )arg2,(enum XmlValue::Type )arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_deleteDefaultIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlIndexSpecification_deleteDefaultIndex",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            (arg1)->deleteDefaultIndex((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_deleteDefaultIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[4];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_XmlIndexSpecification_deleteDefaultIndex__SWIG_1(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_int(argv[1]);
            if (_v) {
                _v = SWIG_Check_int(argv[2]);
                if (_v) {
                    return _wrap_XmlIndexSpecification_deleteDefaultIndex__SWIG_0(self,args);
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlIndexSpecification_deleteDefaultIndex'");
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_replaceDefaultIndex__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    enum XmlIndexSpecification::Type arg2 ;
    enum XmlValue::Type arg3 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlIndexSpecification_replaceDefaultIndex",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (enum XmlIndexSpecification::Type)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum XmlValue::Type)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            (arg1)->replaceDefaultIndex((enum XmlIndexSpecification::Type )arg2,(enum XmlValue::Type )arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_replaceDefaultIndex__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlIndexSpecification_replaceDefaultIndex",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            (arg1)->replaceDefaultIndex((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_replaceDefaultIndex(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[4];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
            if (_v) {
                return _wrap_XmlIndexSpecification_replaceDefaultIndex__SWIG_1(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlIndexSpecification, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_int(argv[1]);
            if (_v) {
                _v = SWIG_Check_int(argv[2]);
                if (_v) {
                    return _wrap_XmlIndexSpecification_replaceDefaultIndex__SWIG_0(self,args);
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlIndexSpecification_replaceDefaultIndex'");
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_reset(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlIndexSpecification_reset",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            (arg1)->reset();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_find(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlIndexDeclaration *result;
    int res2 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlIndexSpecification_find",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            result = (XmlIndexDeclaration *)XmlIndexSpecification_find(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlIndexDeclaration, 1);
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_next(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    XmlIndexDeclaration *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlIndexSpecification_next",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlIndexDeclaration *)XmlIndexSpecification_next(arg1);
            
            if (!result) {
                PyErr_SetString(PyExc_StopIteration,
                "End of results.");
                return NULL;
            }
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlIndexDeclaration, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_getDefaultIndex(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlIndexSpecification_getDefaultIndex",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexSpecification, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlIndexSpecification const *)arg1)->getDefaultIndex();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexSpecification_getValueType(PyObject *, PyObject *args) {
    PyObject *resultobj;
    std::string *arg1 = 0 ;
    enum XmlValue::Type result;
    int res1 = 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlIndexSpecification_getValueType",&obj0)) goto fail;
    {
        std::string *ptr = (std::string *)0;
        res1 = SWIG_AsPtr_std_string(obj0, &ptr);
        if (!res1) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj0);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
        arg1 = ptr;
    }
    {
        try {
            result = (enum XmlValue::Type)XmlIndexSpecification::getValueType((std::string const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_From_int((result));
    if (res1 == SWIG_NEWOBJ) delete arg1;
    return resultobj;
    fail:
    if (res1 == SWIG_NEWOBJ) delete arg1;
    return NULL;
}


static PyObject * XmlIndexSpecification_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlIndexSpecification, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_XmlIndexDeclaration(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexDeclaration *arg1 = (XmlIndexDeclaration *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlIndexDeclaration",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexDeclaration, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexDeclaration_get_uri(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexDeclaration *arg1 = (XmlIndexDeclaration *) 0 ;
    std::string *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlIndexDeclaration_get_uri",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexDeclaration, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                std::string const &_result_ref = ((XmlIndexDeclaration const *)arg1)->get_uri();
                result = (std::string *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(*result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexDeclaration_get_name(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexDeclaration *arg1 = (XmlIndexDeclaration *) 0 ;
    std::string *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlIndexDeclaration_get_name",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexDeclaration, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                std::string const &_result_ref = ((XmlIndexDeclaration const *)arg1)->get_name();
                result = (std::string *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(*result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlIndexDeclaration_get_index(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexDeclaration *arg1 = (XmlIndexDeclaration *) 0 ;
    std::string *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlIndexDeclaration_get_index",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlIndexDeclaration, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                std::string const &_result_ref = ((XmlIndexDeclaration const *)arg1)->get_index();
                result = (std::string *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(*result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlIndexDeclaration(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlIndexDeclaration *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlIndexDeclaration")) goto fail;
    {
        try {
            result = (XmlIndexDeclaration *)new XmlIndexDeclaration();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlIndexDeclaration, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlIndexDeclaration_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlIndexDeclaration, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlQueryExpression__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlQueryExpression")) goto fail;
    {
        try {
            result = (XmlQueryExpression *)new XmlQueryExpression();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryExpression, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlQueryExpression__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = 0 ;
    XmlQueryExpression *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlQueryExpression",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlQueryExpression");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlQueryExpression *)new XmlQueryExpression((XmlQueryExpression const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlQueryExpression, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlQueryExpression(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlQueryExpression__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlQueryExpression__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlQueryExpression'");
    return NULL;
}


static PyObject *_wrap_delete_XmlQueryExpression(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlQueryExpression",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_getQuery(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    std::string *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlQueryExpression_getQuery",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            {
                std::string const &_result_ref = ((XmlQueryExpression const *)arg1)->getQuery();
                result = (std::string *) &_result_ref;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(*result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_getQueryPlan(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    std::string result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlQueryExpression_getQueryPlan",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = ((XmlQueryExpression const *)arg1)->getQueryPlan();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_std_string((std::string)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlQueryContext *arg2 = 0 ;
    u_int32_t arg3 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlQueryExpression_execute",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlQueryExpression_execute__SWIG_0((XmlQueryExpression const *)arg1,*arg2,arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlQueryContext *arg2 = 0 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlQueryExpression_execute",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlQueryExpression_execute__SWIG_0((XmlQueryExpression const *)arg1,*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlValue *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    u_int32_t arg4 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlQueryExpression_execute",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlQueryExpression_execute__SWIG_2((XmlQueryExpression const *)arg1,(XmlValue const &)*arg2,*arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlValue *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlQueryExpression_execute",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlQueryExpression_execute__SWIG_2((XmlQueryExpression const *)arg1,(XmlValue const &)*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute__SWIG_4(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    u_int32_t arg4 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlQueryExpression_execute",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlQueryExpression_execute__SWIG_4((XmlQueryExpression const *)arg1,*arg2,*arg3,arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute__SWIG_5(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlQueryExpression_execute",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlQueryExpression_execute__SWIG_4((XmlQueryExpression const *)arg1,*arg2,*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute__SWIG_6(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlValue *arg3 = 0 ;
    XmlQueryContext *arg4 = 0 ;
    u_int32_t arg5 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlQueryExpression_execute",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlQueryExpression_execute__SWIG_6((XmlQueryExpression const *)arg1,*arg2,(XmlValue const &)*arg3,*arg4,arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute__SWIG_7(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlValue *arg3 = 0 ;
    XmlQueryContext *arg4 = 0 ;
    XmlResults *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlQueryExpression_execute",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (XmlResults *)XmlQueryExpression_execute__SWIG_6((XmlQueryExpression const *)arg1,*arg2,(XmlValue const &)*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResults, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlQueryExpression_execute(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[6];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                return _wrap_XmlQueryExpression_execute__SWIG_1(self,args);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_Check_unsigned_SS_int(argv[2]);
                if (_v) {
                    return _wrap_XmlQueryExpression_execute__SWIG_0(self,args);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlQueryExpression_execute__SWIG_3(self,args);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    return _wrap_XmlQueryExpression_execute__SWIG_5(self,args);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlQueryExpression_execute__SWIG_4(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    _v = SWIG_Check_unsigned_SS_int(argv[3]);
                    if (_v) {
                        return _wrap_XmlQueryExpression_execute__SWIG_2(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlQueryExpression_execute__SWIG_7(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        _v = SWIG_Check_unsigned_SS_int(argv[4]);
                        if (_v) {
                            return _wrap_XmlQueryExpression_execute__SWIG_6(self,args);
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlQueryExpression_execute'");
    return NULL;
}


static PyObject * XmlQueryExpression_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlQueryExpression, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_delete_XmlInputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlInputStream *arg1 = (XmlInputStream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlInputStream",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlInputStream_curPos(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlInputStream *arg1 = (XmlInputStream *) 0 ;
    unsigned int result;
    PyObject * obj0 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlInputStream_curPos",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    director = (Swig::Director *)(arg1);
    
    {
        try {
            result = (unsigned int)((XmlInputStream const *)arg1)->curPos();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlInputStream_readBytes(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlInputStream *arg1 = (XmlInputStream *) 0 ;
    char *arg2 = (char *) 0 ;
    unsigned int arg3 ;
    unsigned int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlInputStream_readBytes",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = (unsigned int const)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    director = (Swig::Director *)(arg1);
    
    {
        try {
            result = (unsigned int)(arg1)->readBytes(arg2,arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlInputStream_freeMemory(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlInputStream *arg1 = (XmlInputStream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlInputStream_freeMemory",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            XmlInputStream_freeMemory(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlInputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg1 = (PyObject *) 0 ;
    XmlInputStream *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlInputStream",&obj0)) goto fail;
    arg1 = obj0;
    {
        try {
            if ( arg1 != Py_None ) {
                /* subclassed */
                result = (XmlInputStream *)new SwigDirector_XmlInputStream(arg1);
                
            } else {
                PyErr_SetString(PyExc_RuntimeError,    "accessing abstract class or protected constructor"); 
                SWIG_fail;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_disown_XmlInputStream(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlInputStream *arg1 = (XmlInputStream *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:disown_XmlInputStream",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlInputStream, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        Swig::Director *director = (Swig::Director *)(arg1);
        if (director) director->swig_disown();
    }
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlInputStream_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlInputStream, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlResolver(PyObject *, PyObject *args) {
    PyObject *resultobj;
    PyObject *arg1 = (PyObject *) 0 ;
    XmlResolver *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlResolver",&obj0)) goto fail;
    arg1 = obj0;
    {
        try {
            if ( arg1 != Py_None ) {
                /* subclassed */
                result = (XmlResolver *)new SwigDirector_XmlResolver(arg1);
                
            } else {
                PyErr_SetString(PyExc_RuntimeError,    "accessing abstract class or protected constructor"); 
                SWIG_fail;
            }
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlResolver, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_XmlResolver(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResolver *arg1 = (XmlResolver *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlResolver",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResolver, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlResolver_resolveDocument(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResolver *arg1 = (XmlResolver *) 0 ;
    XmlTransaction *arg2 = (XmlTransaction *) 0 ;
    XmlManager *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlValue *arg5 = 0 ;
    bool result;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlResolver_resolveDocument",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResolver, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlManager");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    director = (Swig::Director *)(arg1);
    
    {
        try {
            result = (bool)((XmlResolver const *)arg1)->resolveDocument(arg2,*arg3,(std::string const &)*arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlResolver_resolveCollection(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResolver *arg1 = (XmlResolver *) 0 ;
    XmlTransaction *arg2 = (XmlTransaction *) 0 ;
    XmlManager *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlResults *arg5 = 0 ;
    bool result;
    int res4 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    Swig::Director *director = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlResolver_resolveCollection",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResolver, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlManager");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlResults");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    director = (Swig::Director *)(arg1);
    
    {
        try {
            result = (bool)((XmlResolver const *)arg1)->resolveCollection(arg2,*arg3,(std::string const &)*arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    return NULL;
}


static PyObject *_wrap_XmlResolver_resolveSchema(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResolver *arg1 = (XmlResolver *) 0 ;
    XmlTransaction *arg2 = (XmlTransaction *) 0 ;
    XmlManager *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlInputStream *result;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    Swig::Director *director = 0;
    Swig::Director *resultdirector = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlResolver_resolveSchema",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResolver, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlManager");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    director = (Swig::Director *)(arg1);
    
    {
        try {
            result = (XmlInputStream *)((XmlResolver const *)arg1)->resolveSchema(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultdirector = (Swig::Director *)(result);
    if (resultdirector) {
        resultobj = resultdirector->swig_get_self();
        Py_INCREF(resultobj);
    } else {
        resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 1);
    }
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlResolver_resolveEntity(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResolver *arg1 = (XmlResolver *) 0 ;
    XmlTransaction *arg2 = (XmlTransaction *) 0 ;
    XmlManager *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    XmlInputStream *result;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    Swig::Director *director = 0;
    Swig::Director *resultdirector = 0;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlResolver_resolveEntity",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResolver, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(2)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlManager, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlManager");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    director = (Swig::Director *)(arg1);
    
    {
        try {
            result = (XmlInputStream *)((XmlResolver const *)arg1)->resolveEntity(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultdirector = (Swig::Director *)(result);
    if (resultdirector) {
        resultobj = resultdirector->swig_get_self();
        Py_INCREF(resultobj);
    } else {
        resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlInputStream, 1);
    }
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_disown_XmlResolver(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlResolver *arg1 = (XmlResolver *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:disown_XmlResolver",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlResolver, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        Swig::Director *director = (Swig::Director *)(arg1);
        if (director) director->swig_disown();
    }
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlResolver_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlResolver, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlModify__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlModify")) goto fail;
    {
        try {
            result = (XmlModify *)new XmlModify();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlModify, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlModify__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = 0 ;
    XmlModify *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlModify",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlModify");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlModify *)new XmlModify((XmlModify const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlModify, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlModify(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlModify__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlModify, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlModify__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlModify'");
    return NULL;
}


static PyObject *_wrap_delete_XmlModify(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlModify",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlModify_addInsertBeforeStep(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlQueryExpression *arg2 = 0 ;
    enum XmlModify::XmlObject arg3 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlModify_addInsertBeforeStep",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryExpression");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum XmlModify::XmlObject)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        try {
            (arg1)->addInsertBeforeStep((XmlQueryExpression const &)*arg2,(enum XmlModify::XmlObject )arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlModify_addInsertAfterStep(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlQueryExpression *arg2 = 0 ;
    enum XmlModify::XmlObject arg3 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlModify_addInsertAfterStep",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryExpression");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum XmlModify::XmlObject)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        try {
            (arg1)->addInsertAfterStep((XmlQueryExpression const &)*arg2,(enum XmlModify::XmlObject )arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlModify_addAppendStep__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlQueryExpression *arg2 = 0 ;
    enum XmlModify::XmlObject arg3 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    int arg6 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:XmlModify_addAppendStep",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryExpression");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum XmlModify::XmlObject)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        arg6 = (int)(SWIG_As_int(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    {
        try {
            (arg1)->addAppendStep((XmlQueryExpression const &)*arg2,(enum XmlModify::XmlObject )arg3,(std::string const &)*arg4,(std::string const &)*arg5,arg6);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlModify_addAppendStep__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlQueryExpression *arg2 = 0 ;
    enum XmlModify::XmlObject arg3 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    int res4 = 0 ;
    int res5 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlModify_addAppendStep",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryExpression");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum XmlModify::XmlObject)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res4 = SWIG_AsPtr_std_string(obj3, &ptr);
        if (!res4) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj3);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
        arg4 = ptr;
    }
    {
        std::string *ptr = (std::string *)0;
        res5 = SWIG_AsPtr_std_string(obj4, &ptr);
        if (!res5) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj4);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
        arg5 = ptr;
    }
    {
        try {
            (arg1)->addAppendStep((XmlQueryExpression const &)*arg2,(enum XmlModify::XmlObject )arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return resultobj;
    fail:
    if (res4 == SWIG_NEWOBJ) delete arg4;
    if (res5 == SWIG_NEWOBJ) delete arg5;
    return NULL;
}


static PyObject *_wrap_XmlModify_addAppendStep(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[7];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlModify, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_Check_int(argv[2]);
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            return _wrap_XmlModify_addAppendStep__SWIG_1(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlModify, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlQueryExpression, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                _v = SWIG_Check_int(argv[2]);
                if (_v) {
                    _v = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
                    if (_v) {
                        _v = SWIG_AsPtr_std_string(argv[4], (std::string**)(0));
                        if (_v) {
                            _v = SWIG_Check_int(argv[5]);
                            if (_v) {
                                return _wrap_XmlModify_addAppendStep__SWIG_0(self,args);
                            }
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlModify_addAppendStep'");
    return NULL;
}


static PyObject *_wrap_XmlModify_addUpdateStep(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlQueryExpression *arg2 = 0 ;
    std::string *arg3 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlModify_addUpdateStep",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryExpression");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            (arg1)->addUpdateStep((XmlQueryExpression const &)*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlModify_addRemoveStep(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlQueryExpression *arg2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlModify_addRemoveStep",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryExpression");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->addRemoveStep((XmlQueryExpression const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlModify_addRenameStep(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlQueryExpression *arg2 = 0 ;
    std::string *arg3 = 0 ;
    int res3 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:XmlModify_addRenameStep",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlQueryExpression, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlQueryExpression");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        std::string *ptr = (std::string *)0;
        res3 = SWIG_AsPtr_std_string(obj2, &ptr);
        if (!res3) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj2);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
        arg3 = ptr;
    }
    {
        try {
            (arg1)->addRenameStep((XmlQueryExpression const &)*arg2,(std::string const &)*arg3);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return resultobj;
    fail:
    if (res3 == SWIG_NEWOBJ) delete arg3;
    return NULL;
}


static PyObject *_wrap_XmlModify_setNewEncoding(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    std::string *arg2 = 0 ;
    int res2 = 0 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlModify_setNewEncoding",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        std::string *ptr = (std::string *)0;
        res2 = SWIG_AsPtr_std_string(obj1, &ptr);
        if (!res2) {
            if (!PyErr_Occurred())
            SWIG_type_error("std::string", obj1);
        } else if (!ptr) {
            SWIG_null_ref("std::string");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
        arg2 = ptr;
    }
    {
        try {
            (arg1)->setNewEncoding((std::string const &)*arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return resultobj;
    fail:
    if (res2 == SWIG_NEWOBJ) delete arg2;
    return NULL;
}


static PyObject *_wrap_XmlModify_execute__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlValue *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    unsigned int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlModify_execute",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (unsigned int)((XmlModify const *)arg1)->execute(*arg2,*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlModify_execute__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlResults *arg2 = 0 ;
    XmlQueryContext *arg3 = 0 ;
    XmlUpdateContext *arg4 = 0 ;
    unsigned int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:XmlModify_execute",&obj0,&obj1,&obj2,&obj3)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlResults");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        try {
            result = (unsigned int)((XmlModify const *)arg1)->execute(*arg2,*arg3,*arg4);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlModify_execute__SWIG_2(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlValue *arg3 = 0 ;
    XmlQueryContext *arg4 = 0 ;
    XmlUpdateContext *arg5 = 0 ;
    unsigned int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlModify_execute",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlValue, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlValue");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (unsigned int)((XmlModify const *)arg1)->execute(*arg2,*arg3,*arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlModify_execute__SWIG_3(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlModify *arg1 = (XmlModify *) 0 ;
    XmlTransaction *arg2 = 0 ;
    XmlResults *arg3 = 0 ;
    XmlQueryContext *arg4 = 0 ;
    XmlUpdateContext *arg5 = 0 ;
    unsigned int result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:XmlModify_execute",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlModify, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        SWIG_Python_ConvertPtr(obj1, (void **)&arg2, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(2)) SWIG_fail;
        if (arg2 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj2, (void **)&arg3, SWIGTYPE_p_XmlResults, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(3)) SWIG_fail;
        if (arg3 == NULL) {
            SWIG_null_ref("XmlResults");
        }
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj3, (void **)&arg4, SWIGTYPE_p_XmlQueryContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(4)) SWIG_fail;
        if (arg4 == NULL) {
            SWIG_null_ref("XmlQueryContext");
        }
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        SWIG_Python_ConvertPtr(obj4, (void **)&arg5, SWIGTYPE_p_XmlUpdateContext, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(5)) SWIG_fail;
        if (arg5 == NULL) {
            SWIG_null_ref("XmlUpdateContext");
        }
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        try {
            result = (unsigned int)((XmlModify const *)arg1)->execute(*arg2,*arg3,*arg4,*arg5);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlModify_execute(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[6];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlModify, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlModify_execute__SWIG_0(self,args);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlModify, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        return _wrap_XmlModify_execute__SWIG_1(self,args);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlModify, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlValue, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            return _wrap_XmlModify_execute__SWIG_2(self,args);
                        }
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlModify, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr = 0;
                if (SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                    _v = 0;
                    PyErr_Clear();
                } else {
                    _v = (ptr != 0);
                }
            }
            if (_v) {
                {
                    void *ptr = 0;
                    if (SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_XmlResults, 0) == -1) {
                        _v = 0;
                        PyErr_Clear();
                    } else {
                        _v = (ptr != 0);
                    }
                }
                if (_v) {
                    {
                        void *ptr = 0;
                        if (SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_XmlQueryContext, 0) == -1) {
                            _v = 0;
                            PyErr_Clear();
                        } else {
                            _v = (ptr != 0);
                        }
                    }
                    if (_v) {
                        {
                            void *ptr = 0;
                            if (SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_XmlUpdateContext, 0) == -1) {
                                _v = 0;
                                PyErr_Clear();
                            } else {
                                _v = (ptr != 0);
                            }
                        }
                        if (_v) {
                            return _wrap_XmlModify_execute__SWIG_3(self,args);
                        }
                    }
                }
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlModify_execute'");
    return NULL;
}


static PyObject * XmlModify_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlModify, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlTransaction__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *result;
    
    if(!PyArg_ParseTuple(args,(char *)":new_XmlTransaction")) goto fail;
    {
        try {
            result = (XmlTransaction *)new XmlTransaction();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlTransaction, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_XmlTransaction(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *arg1 = (XmlTransaction *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlTransaction",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlTransaction__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *arg1 = 0 ;
    XmlTransaction *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlTransaction",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlTransaction");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlTransaction *)new XmlTransaction((XmlTransaction const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlTransaction, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_new_XmlTransaction(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[2];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 0) {
        return _wrap_new_XmlTransaction__SWIG_0(self,args);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr = 0;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = (ptr != 0);
            }
        }
        if (_v) {
            return _wrap_new_XmlTransaction__SWIG_1(self,args);
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'new_XmlTransaction'");
    return NULL;
}


static PyObject *_wrap_XmlTransaction_abort(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *arg1 = (XmlTransaction *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlTransaction_abort",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            (arg1)->abort();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlTransaction_commit__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *arg1 = (XmlTransaction *) 0 ;
    u_int32_t arg2 ;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlTransaction_commit",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            (arg1)->commit(arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlTransaction_createChild__SWIG_0(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *arg1 = (XmlTransaction *) 0 ;
    u_int32_t arg2 ;
    XmlTransaction *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:XmlTransaction_createChild",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (u_int32_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        try {
            result = (XmlTransaction *)XmlTransaction_createChild__SWIG_0(arg1,arg2);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlTransaction, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlTransaction_createChild__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *arg1 = (XmlTransaction *) 0 ;
    XmlTransaction *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlTransaction_createChild",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (XmlTransaction *)XmlTransaction_createChild__SWIG_0(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlTransaction, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlTransaction_createChild(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlTransaction_createChild__SWIG_1(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_unsigned_SS_int(argv[1]);
            if (_v) {
                return _wrap_XmlTransaction_createChild__SWIG_0(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlTransaction_createChild'");
    return NULL;
}


static PyObject *_wrap_XmlTransaction_commit__SWIG_1(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *arg1 = (XmlTransaction *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlTransaction_commit",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            XmlTransaction_commit__SWIG_1(arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlTransaction_commit(PyObject *self, PyObject *args) {
    int argc;
    PyObject *argv[3];
    int ii;
    
    argc = PyObject_Length(args);
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = PyTuple_GetItem(args,ii);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_XmlTransaction_commit__SWIG_1(self,args);
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_XmlTransaction, 0) == -1) {
                _v = 0;
                PyErr_Clear();
            } else {
                _v = 1;
            }
        }
        if (_v) {
            _v = SWIG_Check_unsigned_SS_int(argv[1]);
            if (_v) {
                return _wrap_XmlTransaction_commit__SWIG_0(self,args);
            }
        }
    }
    
    PyErr_SetString(PyExc_NotImplementedError,"No matching function for overloaded 'XmlTransaction_commit'");
    return NULL;
}


static PyObject *_wrap_XmlTransaction_getDbTxn(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlTransaction *arg1 = (XmlTransaction *) 0 ;
    DbTxn *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlTransaction_getDbTxn",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlTransaction, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (DbTxn *)(arg1)->getDbTxn();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_DbTxn, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlTransaction_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlTransaction, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyObject *_wrap_new_XmlStatistics(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlStatistics *arg1 = 0 ;
    XmlStatistics *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:new_XmlStatistics",&obj0)) goto fail;
    {
        SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlStatistics, SWIG_POINTER_EXCEPTION | 0);
        if (SWIG_arg_fail(1)) SWIG_fail;
        if (arg1 == NULL) {
            SWIG_null_ref("XmlStatistics");
        }
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        try {
            result = (XmlStatistics *)new XmlStatistics((XmlStatistics const &)*arg1);
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_XmlStatistics, 1);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_delete_XmlStatistics(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlStatistics *arg1 = (XmlStatistics *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:delete_XmlStatistics",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlStatistics, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            delete arg1;
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlStatistics_getNumberOfIndexedKeys(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlStatistics *arg1 = (XmlStatistics *) 0 ;
    double result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlStatistics_getNumberOfIndexedKeys",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlStatistics, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (double)((XmlStatistics const *)arg1)->getNumberOfIndexedKeys();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_double((double)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlStatistics_getNumberOfUniqueKeys(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlStatistics *arg1 = (XmlStatistics *) 0 ;
    double result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlStatistics_getNumberOfUniqueKeys",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlStatistics, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (double)((XmlStatistics const *)arg1)->getNumberOfUniqueKeys();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_double((double)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_XmlStatistics_getSumKeyValueSize(PyObject *, PyObject *args) {
    PyObject *resultobj;
    XmlStatistics *arg1 = (XmlStatistics *) 0 ;
    double result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:XmlStatistics_getSumKeyValueSize",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_XmlStatistics, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        try {
            result = (double)((XmlStatistics const *)arg1)->getSumKeyValueSize();
            
        } catch (XmlException &e) {
            PyErr_SetString(PyExc_RuntimeError, e.what());
            return NULL;
        }
    }
    {
        resultobj = SWIG_From_double((double)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject * XmlStatistics_swigregister(PyObject *, PyObject *args) {
    PyObject *obj;
    if (!PyArg_ParseTuple(args,(char*)"O", &obj)) return NULL;
    SWIG_TypeClientData(SWIGTYPE_p_XmlStatistics, obj);
    Py_INCREF(obj);
    return Py_BuildValue((char *)"");
}
static PyMethodDef SwigMethods[] = {
	 { (char *)"new_XmlManager", _wrap_new_XmlManager, METH_VARARGS, NULL},
	 { (char *)"delete_XmlManager", _wrap_delete_XmlManager, METH_VARARGS, NULL},
	 { (char *)"XmlManager_setDefaultContainerFlags", _wrap_XmlManager_setDefaultContainerFlags, METH_VARARGS, NULL},
	 { (char *)"XmlManager_getDefaultContainerFlags", _wrap_XmlManager_getDefaultContainerFlags, METH_VARARGS, NULL},
	 { (char *)"XmlManager_setDefaultPageSize", _wrap_XmlManager_setDefaultPageSize, METH_VARARGS, NULL},
	 { (char *)"XmlManager_getDefaultPageSize", _wrap_XmlManager_getDefaultPageSize, METH_VARARGS, NULL},
	 { (char *)"XmlManager_setDefaultContainerType", _wrap_XmlManager_setDefaultContainerType, METH_VARARGS, NULL},
	 { (char *)"XmlManager_getDefaultContainerType", _wrap_XmlManager_getDefaultContainerType, METH_VARARGS, NULL},
	 { (char *)"XmlManager_getDbEnv", _wrap_XmlManager_getDbEnv, METH_VARARGS, NULL},
	 { (char *)"XmlManager_getHome", _wrap_XmlManager_getHome, METH_VARARGS, NULL},
	 { (char *)"XmlManager_registerResolver", _wrap_XmlManager_registerResolver, METH_VARARGS, NULL},
	 { (char *)"XmlManager_removeContainer", _wrap_XmlManager_removeContainer, METH_VARARGS, NULL},
	 { (char *)"XmlManager_renameContainer", _wrap_XmlManager_renameContainer, METH_VARARGS, NULL},
	 { (char *)"XmlManager_upgradeContainer", _wrap_XmlManager_upgradeContainer, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createStdInInputStream", _wrap_XmlManager_createStdInInputStream, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createLocalFileInputStream", _wrap_XmlManager_createLocalFileInputStream, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createMemBufInputStream", _wrap_XmlManager_createMemBufInputStream, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createURLInputStream", _wrap_XmlManager_createURLInputStream, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createContainer", _wrap_XmlManager_createContainer, METH_VARARGS, NULL},
	 { (char *)"XmlManager_openContainer", _wrap_XmlManager_openContainer, METH_VARARGS, NULL},
	 { (char *)"XmlManager_dumpContainer", _wrap_XmlManager_dumpContainer, METH_VARARGS, NULL},
	 { (char *)"XmlManager_loadContainer", _wrap_XmlManager_loadContainer, METH_VARARGS, NULL},
	 { (char *)"XmlManager_verifyContainer", _wrap_XmlManager_verifyContainer, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createDocument", _wrap_XmlManager_createDocument, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createQueryContext", _wrap_XmlManager_createQueryContext, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createUpdateContext", _wrap_XmlManager_createUpdateContext, METH_VARARGS, NULL},
	 { (char *)"XmlManager_prepare", _wrap_XmlManager_prepare, METH_VARARGS, NULL},
	 { (char *)"XmlManager_query", _wrap_XmlManager_query, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createResults", _wrap_XmlManager_createResults, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createModify", _wrap_XmlManager_createModify, METH_VARARGS, NULL},
	 { (char *)"XmlManager_createTransaction", _wrap_XmlManager_createTransaction, METH_VARARGS, NULL},
	 { (char *)"XmlManager_setLogLevel", _wrap_XmlManager_setLogLevel, METH_VARARGS, NULL},
	 { (char *)"XmlManager_setLogCategory", _wrap_XmlManager_setLogCategory, METH_VARARGS, NULL},
	 { (char *)"XmlManager_get_version_major", _wrap_XmlManager_get_version_major, METH_VARARGS, NULL},
	 { (char *)"XmlManager_get_version_minor", _wrap_XmlManager_get_version_minor, METH_VARARGS, NULL},
	 { (char *)"XmlManager_get_version_patch", _wrap_XmlManager_get_version_patch, METH_VARARGS, NULL},
	 { (char *)"XmlManager_get_version_string", _wrap_XmlManager_get_version_string, METH_VARARGS, NULL},
	 { (char *)"XmlManager_swigregister", XmlManager_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlContainer", _wrap_new_XmlContainer, METH_VARARGS, NULL},
	 { (char *)"delete_XmlContainer", _wrap_delete_XmlContainer, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_sync", _wrap_XmlContainer_sync, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_close", _wrap_XmlContainer_close, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_addAlias", _wrap_XmlContainer_addAlias, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_removeAlias", _wrap_XmlContainer_removeAlias, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_getManager", _wrap_XmlContainer_getManager, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_getName", _wrap_XmlContainer_getName, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_getContainerType", _wrap_XmlContainer_getContainerType, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_setIndexSpecification", _wrap_XmlContainer_setIndexSpecification, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_addIndex", _wrap_XmlContainer_addIndex, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_deleteIndex", _wrap_XmlContainer_deleteIndex, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_replaceIndex", _wrap_XmlContainer_replaceIndex, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_addDefaultIndex", _wrap_XmlContainer_addDefaultIndex, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_deleteDefaultIndex", _wrap_XmlContainer_deleteDefaultIndex, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_replaceDefaultIndex", _wrap_XmlContainer_replaceDefaultIndex, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_putDocument", _wrap_XmlContainer_putDocument, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_deleteDocument", _wrap_XmlContainer_deleteDocument, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_updateDocument", _wrap_XmlContainer_updateDocument, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_getNumDocuments", _wrap_XmlContainer_getNumDocuments, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_getIndexSpecification", _wrap_XmlContainer_getIndexSpecification, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_getDocument", _wrap_XmlContainer_getDocument, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_getAllDocuments", _wrap_XmlContainer_getAllDocuments, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_lookupIndex", _wrap_XmlContainer_lookupIndex, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_lookupStatistics", _wrap_XmlContainer_lookupStatistics, METH_VARARGS, NULL},
	 { (char *)"XmlContainer_swigregister", XmlContainer_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlDocument", _wrap_new_XmlDocument, METH_VARARGS, NULL},
	 { (char *)"delete_XmlDocument", _wrap_delete_XmlDocument, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_setName", _wrap_XmlDocument_setName, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_getName", _wrap_XmlDocument_getName, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_setContent", _wrap_XmlDocument_setContent, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_getContentAsXmlInputStream", _wrap_XmlDocument_getContentAsXmlInputStream, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_setContentAsXmlInputStream", _wrap_XmlDocument_setContentAsXmlInputStream, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_fetchAllData", _wrap_XmlDocument_fetchAllData, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_removeMetaData", _wrap_XmlDocument_removeMetaData, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_setMetaData", _wrap_XmlDocument_setMetaData, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_getMetaData", _wrap_XmlDocument_getMetaData, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_getContentAsString", _wrap_XmlDocument_getContentAsString, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_getContent", _wrap_XmlDocument_getContent, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_getMetaDataIterator", _wrap_XmlDocument_getMetaDataIterator, METH_VARARGS, NULL},
	 { (char *)"XmlDocument_swigregister", XmlDocument_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlMetaDataIterator", _wrap_new_XmlMetaDataIterator, METH_VARARGS, NULL},
	 { (char *)"delete_XmlMetaDataIterator", _wrap_delete_XmlMetaDataIterator, METH_VARARGS, NULL},
	 { (char *)"XmlMetaDataIterator_reset", _wrap_XmlMetaDataIterator_reset, METH_VARARGS, NULL},
	 { (char *)"XmlMetaDataIterator_next", _wrap_XmlMetaDataIterator_next, METH_VARARGS, NULL},
	 { (char *)"XmlMetaDataIterator_swigregister", XmlMetaDataIterator_swigregister, METH_VARARGS, NULL},
	 { (char *)"delete_XmlMetaData", _wrap_delete_XmlMetaData, METH_VARARGS, NULL},
	 { (char *)"XmlMetaData_get_uri", _wrap_XmlMetaData_get_uri, METH_VARARGS, NULL},
	 { (char *)"XmlMetaData_get_name", _wrap_XmlMetaData_get_name, METH_VARARGS, NULL},
	 { (char *)"XmlMetaData_get_value", _wrap_XmlMetaData_get_value, METH_VARARGS, NULL},
	 { (char *)"new_XmlMetaData", _wrap_new_XmlMetaData, METH_VARARGS, NULL},
	 { (char *)"XmlMetaData_swigregister", XmlMetaData_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlQueryContext", _wrap_new_XmlQueryContext, METH_VARARGS, NULL},
	 { (char *)"delete_XmlQueryContext", _wrap_delete_XmlQueryContext, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_setNamespace", _wrap_XmlQueryContext_setNamespace, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_getNamespace", _wrap_XmlQueryContext_getNamespace, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_removeNamespace", _wrap_XmlQueryContext_removeNamespace, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_clearNamespaces", _wrap_XmlQueryContext_clearNamespaces, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_setVariableValue", _wrap_XmlQueryContext_setVariableValue, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_setBaseURI", _wrap_XmlQueryContext_setBaseURI, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_getBaseURI", _wrap_XmlQueryContext_getBaseURI, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_setReturnType", _wrap_XmlQueryContext_setReturnType, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_getReturnType", _wrap_XmlQueryContext_getReturnType, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_setEvaluationType", _wrap_XmlQueryContext_setEvaluationType, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_getEvaluationType", _wrap_XmlQueryContext_getEvaluationType, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_getVariableValue", _wrap_XmlQueryContext_getVariableValue, METH_VARARGS, NULL},
	 { (char *)"XmlQueryContext_swigregister", XmlQueryContext_swigregister, METH_VARARGS, NULL},
	 { (char *)"delete_XmlResults", _wrap_delete_XmlResults, METH_VARARGS, NULL},
	 { (char *)"new_XmlResults", _wrap_new_XmlResults, METH_VARARGS, NULL},
	 { (char *)"XmlResults_hasNext", _wrap_XmlResults_hasNext, METH_VARARGS, NULL},
	 { (char *)"XmlResults_hasPrevious", _wrap_XmlResults_hasPrevious, METH_VARARGS, NULL},
	 { (char *)"XmlResults_next", _wrap_XmlResults_next, METH_VARARGS, NULL},
	 { (char *)"XmlResults_previous", _wrap_XmlResults_previous, METH_VARARGS, NULL},
	 { (char *)"XmlResults_peek", _wrap_XmlResults_peek, METH_VARARGS, NULL},
	 { (char *)"XmlResults_reset", _wrap_XmlResults_reset, METH_VARARGS, NULL},
	 { (char *)"XmlResults_size", _wrap_XmlResults_size, METH_VARARGS, NULL},
	 { (char *)"XmlResults_add", _wrap_XmlResults_add, METH_VARARGS, NULL},
	 { (char *)"XmlResults_swigregister", XmlResults_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlUpdateContext", _wrap_new_XmlUpdateContext, METH_VARARGS, NULL},
	 { (char *)"delete_XmlUpdateContext", _wrap_delete_XmlUpdateContext, METH_VARARGS, NULL},
	 { (char *)"XmlUpdateContext_setApplyChangesToContainers", _wrap_XmlUpdateContext_setApplyChangesToContainers, METH_VARARGS, NULL},
	 { (char *)"XmlUpdateContext_getApplyChangesToContainers", _wrap_XmlUpdateContext_getApplyChangesToContainers, METH_VARARGS, NULL},
	 { (char *)"XmlUpdateContext_swigregister", XmlUpdateContext_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlValue", _wrap_new_XmlValue, METH_VARARGS, NULL},
	 { (char *)"delete_XmlValue", _wrap_delete_XmlValue, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getType", _wrap_XmlValue_getType, METH_VARARGS, NULL},
	 { (char *)"XmlValue_isNull", _wrap_XmlValue_isNull, METH_VARARGS, NULL},
	 { (char *)"XmlValue_isType", _wrap_XmlValue_isType, METH_VARARGS, NULL},
	 { (char *)"XmlValue_isNumber", _wrap_XmlValue_isNumber, METH_VARARGS, NULL},
	 { (char *)"XmlValue_isString", _wrap_XmlValue_isString, METH_VARARGS, NULL},
	 { (char *)"XmlValue_isBoolean", _wrap_XmlValue_isBoolean, METH_VARARGS, NULL},
	 { (char *)"XmlValue_isNode", _wrap_XmlValue_isNode, METH_VARARGS, NULL},
	 { (char *)"XmlValue_asNumber", _wrap_XmlValue_asNumber, METH_VARARGS, NULL},
	 { (char *)"XmlValue_asString", _wrap_XmlValue_asString, METH_VARARGS, NULL},
	 { (char *)"XmlValue_asBoolean", _wrap_XmlValue_asBoolean, METH_VARARGS, NULL},
	 { (char *)"XmlValue_asDocument", _wrap_XmlValue_asDocument, METH_VARARGS, NULL},
	 { (char *)"XmlValue_equals", _wrap_XmlValue_equals, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getNodeName", _wrap_XmlValue_getNodeName, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getNodeValue", _wrap_XmlValue_getNodeValue, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getNamespaceURI", _wrap_XmlValue_getNamespaceURI, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getPrefix", _wrap_XmlValue_getPrefix, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getLocalName", _wrap_XmlValue_getLocalName, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getNodeType", _wrap_XmlValue_getNodeType, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getParentNode", _wrap_XmlValue_getParentNode, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getFirstChild", _wrap_XmlValue_getFirstChild, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getLastChild", _wrap_XmlValue_getLastChild, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getPreviousSibling", _wrap_XmlValue_getPreviousSibling, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getNextSibling", _wrap_XmlValue_getNextSibling, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getAttributes", _wrap_XmlValue_getAttributes, METH_VARARGS, NULL},
	 { (char *)"XmlValue_getOwnerElement", _wrap_XmlValue_getOwnerElement, METH_VARARGS, NULL},
	 { (char *)"XmlValue_setValue", _wrap_XmlValue_setValue, METH_VARARGS, NULL},
	 { (char *)"XmlValue_swigregister", XmlValue_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlIndexSpecification", _wrap_new_XmlIndexSpecification, METH_VARARGS, NULL},
	 { (char *)"delete_XmlIndexSpecification", _wrap_delete_XmlIndexSpecification, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_addIndex", _wrap_XmlIndexSpecification_addIndex, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_deleteIndex", _wrap_XmlIndexSpecification_deleteIndex, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_replaceIndex", _wrap_XmlIndexSpecification_replaceIndex, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_addDefaultIndex", _wrap_XmlIndexSpecification_addDefaultIndex, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_deleteDefaultIndex", _wrap_XmlIndexSpecification_deleteDefaultIndex, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_replaceDefaultIndex", _wrap_XmlIndexSpecification_replaceDefaultIndex, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_reset", _wrap_XmlIndexSpecification_reset, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_find", _wrap_XmlIndexSpecification_find, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_next", _wrap_XmlIndexSpecification_next, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_getDefaultIndex", _wrap_XmlIndexSpecification_getDefaultIndex, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_getValueType", _wrap_XmlIndexSpecification_getValueType, METH_VARARGS, NULL},
	 { (char *)"XmlIndexSpecification_swigregister", XmlIndexSpecification_swigregister, METH_VARARGS, NULL},
	 { (char *)"delete_XmlIndexDeclaration", _wrap_delete_XmlIndexDeclaration, METH_VARARGS, NULL},
	 { (char *)"XmlIndexDeclaration_get_uri", _wrap_XmlIndexDeclaration_get_uri, METH_VARARGS, NULL},
	 { (char *)"XmlIndexDeclaration_get_name", _wrap_XmlIndexDeclaration_get_name, METH_VARARGS, NULL},
	 { (char *)"XmlIndexDeclaration_get_index", _wrap_XmlIndexDeclaration_get_index, METH_VARARGS, NULL},
	 { (char *)"new_XmlIndexDeclaration", _wrap_new_XmlIndexDeclaration, METH_VARARGS, NULL},
	 { (char *)"XmlIndexDeclaration_swigregister", XmlIndexDeclaration_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlQueryExpression", _wrap_new_XmlQueryExpression, METH_VARARGS, NULL},
	 { (char *)"delete_XmlQueryExpression", _wrap_delete_XmlQueryExpression, METH_VARARGS, NULL},
	 { (char *)"XmlQueryExpression_getQuery", _wrap_XmlQueryExpression_getQuery, METH_VARARGS, NULL},
	 { (char *)"XmlQueryExpression_getQueryPlan", _wrap_XmlQueryExpression_getQueryPlan, METH_VARARGS, NULL},
	 { (char *)"XmlQueryExpression_execute", _wrap_XmlQueryExpression_execute, METH_VARARGS, NULL},
	 { (char *)"XmlQueryExpression_swigregister", XmlQueryExpression_swigregister, METH_VARARGS, NULL},
	 { (char *)"delete_XmlInputStream", _wrap_delete_XmlInputStream, METH_VARARGS, NULL},
	 { (char *)"XmlInputStream_curPos", _wrap_XmlInputStream_curPos, METH_VARARGS, NULL},
	 { (char *)"XmlInputStream_readBytes", _wrap_XmlInputStream_readBytes, METH_VARARGS, NULL},
	 { (char *)"XmlInputStream_freeMemory", _wrap_XmlInputStream_freeMemory, METH_VARARGS, NULL},
	 { (char *)"new_XmlInputStream", _wrap_new_XmlInputStream, METH_VARARGS, NULL},
	 { (char *)"disown_XmlInputStream", _wrap_disown_XmlInputStream, METH_VARARGS, NULL},
	 { (char *)"XmlInputStream_swigregister", XmlInputStream_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlResolver", _wrap_new_XmlResolver, METH_VARARGS, NULL},
	 { (char *)"delete_XmlResolver", _wrap_delete_XmlResolver, METH_VARARGS, NULL},
	 { (char *)"XmlResolver_resolveDocument", _wrap_XmlResolver_resolveDocument, METH_VARARGS, NULL},
	 { (char *)"XmlResolver_resolveCollection", _wrap_XmlResolver_resolveCollection, METH_VARARGS, NULL},
	 { (char *)"XmlResolver_resolveSchema", _wrap_XmlResolver_resolveSchema, METH_VARARGS, NULL},
	 { (char *)"XmlResolver_resolveEntity", _wrap_XmlResolver_resolveEntity, METH_VARARGS, NULL},
	 { (char *)"disown_XmlResolver", _wrap_disown_XmlResolver, METH_VARARGS, NULL},
	 { (char *)"XmlResolver_swigregister", XmlResolver_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlModify", _wrap_new_XmlModify, METH_VARARGS, NULL},
	 { (char *)"delete_XmlModify", _wrap_delete_XmlModify, METH_VARARGS, NULL},
	 { (char *)"XmlModify_addInsertBeforeStep", _wrap_XmlModify_addInsertBeforeStep, METH_VARARGS, NULL},
	 { (char *)"XmlModify_addInsertAfterStep", _wrap_XmlModify_addInsertAfterStep, METH_VARARGS, NULL},
	 { (char *)"XmlModify_addAppendStep", _wrap_XmlModify_addAppendStep, METH_VARARGS, NULL},
	 { (char *)"XmlModify_addUpdateStep", _wrap_XmlModify_addUpdateStep, METH_VARARGS, NULL},
	 { (char *)"XmlModify_addRemoveStep", _wrap_XmlModify_addRemoveStep, METH_VARARGS, NULL},
	 { (char *)"XmlModify_addRenameStep", _wrap_XmlModify_addRenameStep, METH_VARARGS, NULL},
	 { (char *)"XmlModify_setNewEncoding", _wrap_XmlModify_setNewEncoding, METH_VARARGS, NULL},
	 { (char *)"XmlModify_execute", _wrap_XmlModify_execute, METH_VARARGS, NULL},
	 { (char *)"XmlModify_swigregister", XmlModify_swigregister, METH_VARARGS, NULL},
	 { (char *)"delete_XmlTransaction", _wrap_delete_XmlTransaction, METH_VARARGS, NULL},
	 { (char *)"new_XmlTransaction", _wrap_new_XmlTransaction, METH_VARARGS, NULL},
	 { (char *)"XmlTransaction_abort", _wrap_XmlTransaction_abort, METH_VARARGS, NULL},
	 { (char *)"XmlTransaction_createChild", _wrap_XmlTransaction_createChild, METH_VARARGS, NULL},
	 { (char *)"XmlTransaction_commit", _wrap_XmlTransaction_commit, METH_VARARGS, NULL},
	 { (char *)"XmlTransaction_getDbTxn", _wrap_XmlTransaction_getDbTxn, METH_VARARGS, NULL},
	 { (char *)"XmlTransaction_swigregister", XmlTransaction_swigregister, METH_VARARGS, NULL},
	 { (char *)"new_XmlStatistics", _wrap_new_XmlStatistics, METH_VARARGS, NULL},
	 { (char *)"delete_XmlStatistics", _wrap_delete_XmlStatistics, METH_VARARGS, NULL},
	 { (char *)"XmlStatistics_getNumberOfIndexedKeys", _wrap_XmlStatistics_getNumberOfIndexedKeys, METH_VARARGS, NULL},
	 { (char *)"XmlStatistics_getNumberOfUniqueKeys", _wrap_XmlStatistics_getNumberOfUniqueKeys, METH_VARARGS, NULL},
	 { (char *)"XmlStatistics_getSumKeyValueSize", _wrap_XmlStatistics_getSumKeyValueSize, METH_VARARGS, NULL},
	 { (char *)"XmlStatistics_swigregister", XmlStatistics_swigregister, METH_VARARGS, NULL},
	 { NULL, NULL, 0, NULL }
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__std__size_t[] = {{"_std__size_t", 0, "std::size_t", 0, 0, 0, 0},{"_std__size_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__size_t[] = {{"_size_t", 0, "size_t", 0, 0, 0, 0},{"_size_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlManager[] = {{"_p_XmlManager", 0, "XmlManager *", 0, 0, 0, 0},{"_p_XmlManager", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlResults[] = {{"_p_XmlResults", 0, "XmlResults *", 0, 0, 0, 0},{"_p_XmlResults", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlUpdateContext[] = {{"_p_XmlUpdateContext", 0, "XmlUpdateContext *", 0, 0, 0, 0},{"_p_XmlUpdateContext", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlQueryContext[] = {{"_p_XmlQueryContext", 0, "XmlQueryContext *", 0, 0, 0, 0},{"_p_XmlQueryContext", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlIndexSpecification[] = {{"_p_XmlIndexSpecification", 0, "XmlIndexSpecification *", 0, 0, 0, 0},{"_p_XmlIndexSpecification", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlValue[] = {{"_p_XmlValue", 0, "XmlValue *", 0, 0, 0, 0},{"_p_XmlValue", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlStatistics[] = {{"_p_XmlStatistics", 0, "XmlStatistics *", 0, 0, 0, 0},{"_p_XmlStatistics", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_unsigned_int[] = {{"_p_unsigned_int", 0, "unsigned int *|u_int32_t *", 0, 0, 0, 0},{"_p_unsigned_int", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_char[] = {{"_p_char", 0, "char *", 0, 0, 0, 0},{"_p_char", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlResolver[] = {{"_p_XmlResolver", 0, "XmlResolver *", 0, 0, 0, 0},{"_p_XmlResolver", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlInputStream[] = {{"_p_XmlInputStream", 0, "XmlInputStream *", 0, 0, 0, 0},{"_p_XmlInputStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlMetaData[] = {{"_p_XmlMetaData", 0, "XmlMetaData *", 0, 0, 0, 0},{"_p_XmlMetaData", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlQueryExpression[] = {{"_p_XmlQueryExpression", 0, "XmlQueryExpression *", 0, 0, 0, 0},{"_p_XmlQueryExpression", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_DbTxn[] = {{"_p_DbTxn", 0, "DbTxn *", 0, 0, 0, 0},{"_p_DbTxn", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__std__ptrdiff_t[] = {{"_std__ptrdiff_t", 0, "std::ptrdiff_t", 0, 0, 0, 0},{"_std__ptrdiff_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__ptrdiff_t[] = {{"_ptrdiff_t", 0, "ptrdiff_t", 0, 0, 0, 0},{"_ptrdiff_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlContainer[] = {{"_p_XmlContainer", 0, "XmlContainer *", 0, 0, 0, 0},{"_p_XmlContainer", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_DbEnv[] = {{"_p_DbEnv", 0, "DbEnv *", 0, 0, 0, 0},{"_p_DbEnv", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlModify[] = {{"_p_XmlModify", 0, "XmlModify *", 0, 0, 0, 0},{"_p_XmlModify", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlTransaction[] = {{"_p_XmlTransaction", 0, "XmlTransaction *", 0, 0, 0, 0},{"_p_XmlTransaction", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlDocument[] = {{"_p_XmlDocument", 0, "XmlDocument *", 0, 0, 0, 0},{"_p_XmlDocument", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlData[] = {{"_p_XmlData", 0, "XmlData *", 0, 0, 0, 0},{"_p_XmlData", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *|int32_t *", 0, 0, 0, 0},{"_p_int", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlMetaDataIterator[] = {{"_p_XmlMetaDataIterator", 0, "XmlMetaDataIterator *", 0, 0, 0, 0},{"_p_XmlMetaDataIterator", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_XmlIndexDeclaration[] = {{"_p_XmlIndexDeclaration", 0, "XmlIndexDeclaration *", 0, 0, 0, 0},{"_p_XmlIndexDeclaration", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__std__size_t, 
_swigt__size_t, 
_swigt__p_XmlManager, 
_swigt__p_XmlResults, 
_swigt__p_XmlUpdateContext, 
_swigt__p_XmlQueryContext, 
_swigt__p_XmlIndexSpecification, 
_swigt__p_XmlValue, 
_swigt__p_XmlStatistics, 
_swigt__p_unsigned_int, 
_swigt__p_char, 
_swigt__p_XmlResolver, 
_swigt__p_XmlInputStream, 
_swigt__p_XmlMetaData, 
_swigt__p_XmlQueryExpression, 
_swigt__p_DbTxn, 
_swigt__std__ptrdiff_t, 
_swigt__ptrdiff_t, 
_swigt__p_XmlContainer, 
_swigt__p_DbEnv, 
_swigt__p_XmlModify, 
_swigt__p_XmlTransaction, 
_swigt__p_XmlDocument, 
_swigt__p_XmlData, 
_swigt__p_int, 
_swigt__p_XmlMetaDataIterator, 
_swigt__p_XmlIndexDeclaration, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
{ SWIG_PY_POINTER, (char*)"metaDataNamespace_uri", 0, 0, (void *)"http://www.sleepycat.com/2002/dbxml", &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"metaDataNamespace_prefix", 0, 0, (void *)"dbxml", &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"metaDataName_name", 0, 0, (void *)"name", &SWIGTYPE_p_char},
{ SWIG_PY_POINTER, (char*)"metaDataName_root", 0, 0, (void *)"root", &SWIGTYPE_p_char},
{0, 0, 0, 0.0, 0, 0}};

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
    
    /* Python-specific SWIG API */
#define SWIG_newvarlink()                             SWIG_Python_newvarlink()
#define SWIG_addvarlink(p, name, get_attr, set_attr)  SWIG_Python_addvarlink(p, name, get_attr, set_attr)
#define SWIG_InstallConstants(d, constants)           SWIG_Python_InstallConstants(d, constants)
    
    /* -----------------------------------------------------------------------------
     * global variable support code.
     * ----------------------------------------------------------------------------- */
    
    typedef struct swig_globalvar {
        char       *name;                  /* Name of global variable */
        PyObject *(*get_attr)();           /* Return the current value */
        int       (*set_attr)(PyObject *); /* Set the value */
        struct swig_globalvar *next;
    } swig_globalvar;
    
    typedef struct swig_varlinkobject {
        PyObject_HEAD
        swig_globalvar *vars;
    } swig_varlinkobject;
    
    static PyObject *
    swig_varlink_repr(swig_varlinkobject *v) {
        v = v;
        return PyString_FromString("<Swig global variables>");
    }
    
    static int
    swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
        swig_globalvar  *var;
        flags = flags;
        fprintf(fp,"Swig global variables { ");
        for (var = v->vars; var; var=var->next) {
            fprintf(fp,"%s", var->name);
            if (var->next) fprintf(fp,", ");
        }
        fprintf(fp," }\n");
        return 0;
    }
    
    static PyObject *
    swig_varlink_getattr(swig_varlinkobject *v, char *n) {
        swig_globalvar *var = v->vars;
        while (var) {
            if (strcmp(var->name,n) == 0) {
                return (*var->get_attr)();
            }
            var = var->next;
        }
        PyErr_SetString(PyExc_NameError,"Unknown C global variable");
        return NULL;
    }
    
    static int
    swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
        swig_globalvar *var = v->vars;
        while (var) {
            if (strcmp(var->name,n) == 0) {
                return (*var->set_attr)(p);
            }
            var = var->next;
        }
        PyErr_SetString(PyExc_NameError,"Unknown C global variable");
        return 1;
    }
    
    static PyTypeObject varlinktype = {
        PyObject_HEAD_INIT(0)              
        0,                                  /* Number of items in variable part (ob_size) */
        (char *)"swigvarlink",              /* Type name (tp_name) */
        sizeof(swig_varlinkobject),         /* Basic size (tp_basicsize) */
        0,                                  /* Itemsize (tp_itemsize) */
        0,                                  /* Deallocator (tp_dealloc) */ 
        (printfunc) swig_varlink_print,     /* Print (tp_print) */
        (getattrfunc) swig_varlink_getattr, /* get attr (tp_getattr) */
        (setattrfunc) swig_varlink_setattr, /* Set attr (tp_setattr) */
        0,                                  /* tp_compare */
        (reprfunc) swig_varlink_repr,       /* tp_repr */
        0,                                  /* tp_as_number */
        0,                                  /* tp_as_sequence */
        0,                                  /* tp_as_mapping */
        0,                                  /* tp_hash */
        0,                                  /* tp_call */
        0,                                  /* tp_str */
        0,                                  /* tp_getattro */
        0,                                  /* tp_setattro */
        0,                                  /* tp_as_buffer */
        0,                                  /* tp_flags */
        0,                                  /* tp_doc */
#if PY_VERSION_HEX >= 0x02000000
        0,                                  /* tp_traverse */
        0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
        0,                                  /* tp_richcompare */
        0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
        0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
        0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };
    
    /* Create a variable linking object for use later */
    static PyObject *
    SWIG_Python_newvarlink(void) {
        swig_varlinkobject *result = 0;
        result = PyMem_NEW(swig_varlinkobject,1);
        varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
        result->ob_type = &varlinktype;
        result->vars = 0;
        result->ob_refcnt = 0;
        Py_XINCREF((PyObject *) result);
        return ((PyObject*) result);
    }
    
    static void
    SWIG_Python_addvarlink(PyObject *p, char *name, PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
        swig_varlinkobject *v;
        swig_globalvar *gv;
        v= (swig_varlinkobject *) p;
        gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
        gv->name = (char *) malloc(strlen(name)+1);
        strcpy(gv->name,name);
        gv->get_attr = get_attr;
        gv->set_attr = set_attr;
        gv->next = v->vars;
        v->vars = gv;
    }
    
    /* -----------------------------------------------------------------------------
     * constants/methods manipulation
     * ----------------------------------------------------------------------------- */
    
    /* Install Constants */
    static void
    SWIG_Python_InstallConstants(PyObject *d, swig_const_info constants[]) {
        PyObject *obj = 0;
        size_t i;
        for (i = 0; constants[i].type; i++) {
            switch(constants[i].type) {
                case SWIG_PY_INT:
                obj = PyInt_FromLong(constants[i].lvalue);
                break;
                case SWIG_PY_FLOAT:
                obj = PyFloat_FromDouble(constants[i].dvalue);
                break;
                case SWIG_PY_STRING:
                if (constants[i].pvalue) {
                    obj = PyString_FromString((char *) constants[i].pvalue);
                } else {
                    Py_INCREF(Py_None);
                    obj = Py_None;
                }
                break;
                case SWIG_PY_POINTER:
                obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
                break;
                case SWIG_PY_BINARY:
                obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype));
                break;
                default:
                obj = 0;
                break;
            }
            if (obj) {
                PyDict_SetItemString(d,constants[i].name,obj);
                Py_DECREF(obj);
            }
        }
    }
    
    /* -----------------------------------------------------------------------------*/
    /* Fix SwigMethods to carry the callback ptrs when needed */
    /* -----------------------------------------------------------------------------*/
    
    static void
    SWIG_Python_FixMethods(PyMethodDef *methods,
    swig_const_info *const_table,
    swig_type_info **types,
    swig_type_info **types_initial) {
        size_t i;
        for (i = 0; methods[i].ml_name; ++i) {
            char *c = methods[i].ml_doc;
            if (c && (c = strstr(c, "swig_ptr: "))) {
                int j;
                swig_const_info *ci = 0;
                char *name = c + 10;
                for (j = 0; const_table[j].type; j++) {
                    if (strncmp(const_table[j].name, name, 
                    strlen(const_table[j].name)) == 0) {
                        ci = &(const_table[j]);
                        break;
                    }
                }
                if (ci) {
                    size_t shift = (ci->ptype) - types;
                    swig_type_info *ty = types_initial[shift];
                    size_t ldoc = (c - methods[i].ml_doc);
                    size_t lptr = strlen(ty->name)+2*sizeof(void*)+2;
                    char *ndoc = (char*)malloc(ldoc + lptr + 10);
                    char *buff = ndoc;
                    void *ptr = (ci->type == SWIG_PY_POINTER) ? ci->pvalue: (void *)(ci->lvalue);
                    strncpy(buff, methods[i].ml_doc, ldoc);
                    buff += ldoc;
                    strncpy(buff, "swig_ptr: ", 10);
                    buff += 10;
                    SWIG_PackVoidPtr(buff, ptr, ty->name, lptr);
                    methods[i].ml_doc = ndoc;
                }
            }
        }
    }
    
    /* -----------------------------------------------------------------------------*
     *  Initialize type list
     * -----------------------------------------------------------------------------*/
    
#if PY_MAJOR_VERSION < 2
    /* PyModule_AddObject function was introduced in Python 2.0.  The following function
    is copied out of Python/modsupport.c in python version 2.3.4 */
    static int
    PyModule_AddObject(PyObject *m, char *name, PyObject *o)
    {
        PyObject *dict;
        if (!PyModule_Check(m)) {
            PyErr_SetString(PyExc_TypeError,
            "PyModule_AddObject() needs module as first arg");
            return -1;
        }
        if (!o) {
            PyErr_SetString(PyExc_TypeError,
            "PyModule_AddObject() needs non-NULL value");
            return -1;
        }
        
        dict = PyModule_GetDict(m);
        if (dict == NULL) {
            /* Internal error -- modules must have a dict! */
            PyErr_Format(PyExc_SystemError, "module '%s' has no __dict__",
            PyModule_GetName(m));
            return -1;
        }
        if (PyDict_SetItemString(dict, name, o))
        return -1;
        Py_DECREF(o);
        return 0;
    }
#endif
    
    static swig_type_info **
    SWIG_Python_SetTypeListHandle(swig_type_info **type_list_handle) {
        static PyMethodDef swig_empty_runtime_method_table[] = {
            {
                NULL, NULL, 0, NULL
            } 
        };/* Sentinel */
        
        PyObject *module = Py_InitModule((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
        swig_empty_runtime_method_table);
        PyObject *pointer = PyCObject_FromVoidPtr((void *) type_list_handle, NULL);
        if (pointer && module) {
            PyModule_AddObject(module, (char*)"type_pointer" SWIG_TYPE_TABLE_NAME, pointer);
        }
        return type_list_handle;
    } 
    
    static swig_type_info **
    SWIG_Python_LookupTypePointer(swig_type_info **type_list_handle) {
        swig_type_info **type_pointer;
        
        /* first check if module already created */
        type_pointer = SWIG_Python_GetTypeListHandle();
        if (type_pointer) {
            return type_pointer;
        } else {
            /* create a new module and variable */
            return SWIG_Python_SetTypeListHandle(type_list_handle);
        }
    }
    
#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------*
 *  Partial Init method
 * -----------------------------------------------------------------------------*/

#ifdef SWIG_LINK_RUNTIME
#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void *) SWIG_ReturnGlobalTypeList(void *);
#endif

#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) SWIG_init(void) {
    static PyObject *SWIG_globals = 0; 
    static int       typeinit = 0;
    PyObject *m, *d;
    int       i;
    if (!SWIG_globals) SWIG_globals = SWIG_newvarlink();
    
    /* Fix SwigMethods to carry the callback ptrs when needed */
    SWIG_Python_FixMethods(SwigMethods, swig_const_table, swig_types, swig_types_initial);
    
    m = Py_InitModule((char *) SWIG_name, SwigMethods);
    d = PyModule_GetDict(m);
    
    if (!typeinit) {
#ifdef SWIG_LINK_RUNTIME
        swig_type_list_handle = (swig_type_info **) SWIG_ReturnGlobalTypeList(swig_type_list_handle);
#else
#  ifndef SWIG_STATIC_RUNTIME
        swig_type_list_handle = SWIG_Python_LookupTypePointer(swig_type_list_handle);
#  endif
#endif
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        typeinit = 1;
    }
    SWIG_InstallConstants(d,swig_const_table);
    
    {
        PyDict_SetItemString(d,"DB_CREATE", SWIG_From_int((int)(DB_CREATE))); 
    }
    {
        PyDict_SetItemString(d,"DB_DIRTY_READ", SWIG_From_int((int)(DB_DIRTY_READ))); 
    }
    {
        PyDict_SetItemString(d,"DB_EXCL", SWIG_From_int((int)(DB_EXCL))); 
    }
    {
        PyDict_SetItemString(d,"DB_NOMMAP", SWIG_From_int((int)(DB_NOMMAP))); 
    }
    {
        PyDict_SetItemString(d,"DB_RDONLY", SWIG_From_int((int)(DB_RDONLY))); 
    }
    {
        PyDict_SetItemString(d,"DB_THREAD", SWIG_From_int((int)(DB_THREAD))); 
    }
    {
        PyDict_SetItemString(d,"DB_INIT_LOCK", SWIG_From_int((int)(DB_INIT_LOCK))); 
    }
    {
        PyDict_SetItemString(d,"DB_INIT_LOG", SWIG_From_int((int)(DB_INIT_LOG))); 
    }
    {
        PyDict_SetItemString(d,"DB_INIT_MPOOL", SWIG_From_int((int)(DB_INIT_MPOOL))); 
    }
    {
        PyDict_SetItemString(d,"DB_INIT_TXN", SWIG_From_int((int)(DB_INIT_TXN))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_ADOPT_DBENV", SWIG_From_int((int)(DBXML_ADOPT_DBENV))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_ALLOW_EXTERNAL_ACCESS", SWIG_From_int((int)(DBXML_ALLOW_EXTERNAL_ACCESS))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_ALLOW_AUTO_OPEN", SWIG_From_int((int)(DBXML_ALLOW_AUTO_OPEN))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_ALLOW_VALIDATION", SWIG_From_int((int)(DBXML_ALLOW_VALIDATION))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_TRANSACTIONAL", SWIG_From_int((int)(DBXML_TRANSACTIONAL))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_CHKSUM", SWIG_From_int((int)(DBXML_CHKSUM))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_ENCRYPT", SWIG_From_int((int)(DBXML_ENCRYPT))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_GEN_NAME", SWIG_From_int((int)(DBXML_GEN_NAME))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_LAZY_DOCS", SWIG_From_int((int)(DBXML_LAZY_DOCS))); 
    }
    {
        PyDict_SetItemString(d,"DBXML_INDEX_NODES", SWIG_From_int((int)(DBXML_INDEX_NODES))); 
    }
    {
        PyDict_SetItemString(d,"LEVEL_NONE", SWIG_From_int((int)(LEVEL_NONE))); 
    }
    {
        PyDict_SetItemString(d,"LEVEL_DEBUG", SWIG_From_int((int)(LEVEL_DEBUG))); 
    }
    {
        PyDict_SetItemString(d,"LEVEL_INFO", SWIG_From_int((int)(LEVEL_INFO))); 
    }
    {
        PyDict_SetItemString(d,"LEVEL_WARNING", SWIG_From_int((int)(LEVEL_WARNING))); 
    }
    {
        PyDict_SetItemString(d,"LEVEL_ERROR", SWIG_From_int((int)(LEVEL_ERROR))); 
    }
    {
        PyDict_SetItemString(d,"LEVEL_ALL", SWIG_From_int((int)(LEVEL_ALL))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_NONE", SWIG_From_int((int)(CATEGORY_NONE))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_INDEXER", SWIG_From_int((int)(CATEGORY_INDEXER))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_QUERY", SWIG_From_int((int)(CATEGORY_QUERY))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_OPTIMIZER", SWIG_From_int((int)(CATEGORY_OPTIMIZER))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_DICTIONARY", SWIG_From_int((int)(CATEGORY_DICTIONARY))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_CONTAINER", SWIG_From_int((int)(CATEGORY_CONTAINER))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_NODESTORE", SWIG_From_int((int)(CATEGORY_NODESTORE))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_MANAGER", SWIG_From_int((int)(CATEGORY_MANAGER))); 
    }
    {
        PyDict_SetItemString(d,"CATEGORY_ALL", SWIG_From_int((int)(CATEGORY_ALL))); 
    }
    PyDict_SetItemString(d,"metaDataNamespace_uri", SWIG_FromCharPtr("http://www.sleepycat.com/2002/dbxml"));
    PyDict_SetItemString(d,"metaDataNamespace_prefix", SWIG_FromCharPtr("dbxml"));
    PyDict_SetItemString(d,"metaDataName_name", SWIG_FromCharPtr("name"));
    PyDict_SetItemString(d,"metaDataName_root", SWIG_FromCharPtr("root"));
    {
        PyDict_SetItemString(d,"XmlContainer_WholedocContainer", SWIG_From_int((int)(XmlContainer::WholedocContainer))); 
    }
    {
        PyDict_SetItemString(d,"XmlContainer_NodeContainer", SWIG_From_int((int)(XmlContainer::NodeContainer))); 
    }
    {
        PyDict_SetItemString(d,"XmlQueryContext_DeadValues", SWIG_From_int((int)(XmlQueryContext::DeadValues))); 
    }
    {
        PyDict_SetItemString(d,"XmlQueryContext_LiveValues", SWIG_From_int((int)(XmlQueryContext::LiveValues))); 
    }
    {
        PyDict_SetItemString(d,"XmlQueryContext_Eager", SWIG_From_int((int)(XmlQueryContext::Eager))); 
    }
    {
        PyDict_SetItemString(d,"XmlQueryContext_Lazy", SWIG_From_int((int)(XmlQueryContext::Lazy))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_ELEMENT_NODE", SWIG_From_int((int)(XmlValue::ELEMENT_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_ATTRIBUTE_NODE", SWIG_From_int((int)(XmlValue::ATTRIBUTE_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_TEXT_NODE", SWIG_From_int((int)(XmlValue::TEXT_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_CDATA_SECTION_NODE", SWIG_From_int((int)(XmlValue::CDATA_SECTION_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_ENTITY_REFERENCE_NODE", SWIG_From_int((int)(XmlValue::ENTITY_REFERENCE_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_ENTITY_NODE", SWIG_From_int((int)(XmlValue::ENTITY_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_PROCESSING_INSTRUCTION_NODE", SWIG_From_int((int)(XmlValue::PROCESSING_INSTRUCTION_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_COMMENT_NODE", SWIG_From_int((int)(XmlValue::COMMENT_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DOCUMENT_NODE", SWIG_From_int((int)(XmlValue::DOCUMENT_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DOCUMENT_TYPE_NODE", SWIG_From_int((int)(XmlValue::DOCUMENT_TYPE_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DOCUMENT_FRAGMENT_NODE", SWIG_From_int((int)(XmlValue::DOCUMENT_FRAGMENT_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_NOTATION_NODE", SWIG_From_int((int)(XmlValue::NOTATION_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_NONE", SWIG_From_int((int)(XmlValue::NONE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_NODE", SWIG_From_int((int)(XmlValue::NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_ANY_SIMPLE_TYPE", SWIG_From_int((int)(XmlValue::ANY_SIMPLE_TYPE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_ANY_URI", SWIG_From_int((int)(XmlValue::ANY_URI))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_BASE_64_BINARY", SWIG_From_int((int)(XmlValue::BASE_64_BINARY))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_BOOLEAN", SWIG_From_int((int)(XmlValue::BOOLEAN))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DATE", SWIG_From_int((int)(XmlValue::DATE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DATE_TIME", SWIG_From_int((int)(XmlValue::DATE_TIME))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DAY_TIME_DURATION", SWIG_From_int((int)(XmlValue::DAY_TIME_DURATION))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DECIMAL", SWIG_From_int((int)(XmlValue::DECIMAL))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DOUBLE", SWIG_From_int((int)(XmlValue::DOUBLE))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_DURATION", SWIG_From_int((int)(XmlValue::DURATION))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_FLOAT", SWIG_From_int((int)(XmlValue::FLOAT))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_G_DAY", SWIG_From_int((int)(XmlValue::G_DAY))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_G_MONTH", SWIG_From_int((int)(XmlValue::G_MONTH))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_G_MONTH_DAY", SWIG_From_int((int)(XmlValue::G_MONTH_DAY))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_G_YEAR", SWIG_From_int((int)(XmlValue::G_YEAR))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_G_YEAR_MONTH", SWIG_From_int((int)(XmlValue::G_YEAR_MONTH))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_HEX_BINARY", SWIG_From_int((int)(XmlValue::HEX_BINARY))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_NOTATION", SWIG_From_int((int)(XmlValue::NOTATION))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_QNAME", SWIG_From_int((int)(XmlValue::QNAME))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_STRING", SWIG_From_int((int)(XmlValue::STRING))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_TIME", SWIG_From_int((int)(XmlValue::TIME))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_YEAR_MONTH_DURATION", SWIG_From_int((int)(XmlValue::YEAR_MONTH_DURATION))); 
    }
    {
        PyDict_SetItemString(d,"XmlValue_UNTYPED_ATOMIC", SWIG_From_int((int)(XmlValue::UNTYPED_ATOMIC))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_UNIQUE_OFF", SWIG_From_int((int)(XmlIndexSpecification::UNIQUE_OFF))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_UNIQUE_ON", SWIG_From_int((int)(XmlIndexSpecification::UNIQUE_ON))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_PATH_NONE", SWIG_From_int((int)(XmlIndexSpecification::PATH_NONE))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_PATH_NODE", SWIG_From_int((int)(XmlIndexSpecification::PATH_NODE))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_PATH_EDGE", SWIG_From_int((int)(XmlIndexSpecification::PATH_EDGE))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_NODE_NONE", SWIG_From_int((int)(XmlIndexSpecification::NODE_NONE))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_NODE_ELEMENT", SWIG_From_int((int)(XmlIndexSpecification::NODE_ELEMENT))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_NODE_ATTRIBUTE", SWIG_From_int((int)(XmlIndexSpecification::NODE_ATTRIBUTE))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_NODE_METADATA", SWIG_From_int((int)(XmlIndexSpecification::NODE_METADATA))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_KEY_NONE", SWIG_From_int((int)(XmlIndexSpecification::KEY_NONE))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_KEY_PRESENCE", SWIG_From_int((int)(XmlIndexSpecification::KEY_PRESENCE))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_KEY_EQUALITY", SWIG_From_int((int)(XmlIndexSpecification::KEY_EQUALITY))); 
    }
    {
        PyDict_SetItemString(d,"XmlIndexSpecification_KEY_SUBSTRING", SWIG_From_int((int)(XmlIndexSpecification::KEY_SUBSTRING))); 
    }
    {
        PyDict_SetItemString(d,"XmlModify_Element", SWIG_From_int((int)(XmlModify::Element))); 
    }
    {
        PyDict_SetItemString(d,"XmlModify_Attribute", SWIG_From_int((int)(XmlModify::Attribute))); 
    }
    {
        PyDict_SetItemString(d,"XmlModify_Text", SWIG_From_int((int)(XmlModify::Text))); 
    }
    {
        PyDict_SetItemString(d,"XmlModify_ProcessingInstruction", SWIG_From_int((int)(XmlModify::ProcessingInstruction))); 
    }
    {
        PyDict_SetItemString(d,"XmlModify_Comment", SWIG_From_int((int)(XmlModify::Comment))); 
    }
}

