//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlDocumentConfig.java,v 1.5 2005/04/20 18:31:35 bostic Exp $
//
//

package com.sleepycat.dbxml;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.XmlHelper;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbConstants;

public class XmlDocumentConfig implements Cloneable {

    public static final XmlDocumentConfig DEFAULT = new XmlDocumentConfig();

    public boolean getLazyDocs() {
	return lazyDocs;
    }

    public XmlDocumentConfig setLazyDocs(final boolean value) {
	this.lazyDocs = value;
	return this;
    }

    public boolean getGenerateName() {
	return genName;
    }

    public XmlDocumentConfig setGenerateName(final boolean value) {
	this.genName = value;
	return this;
    }

    public XmlDocumentConfig setDirtyRead(final boolean dirtyRead) {
        this.dirtyRead = dirtyRead;
	return this;
    }

    public boolean getDirtyRead() {
        return dirtyRead;
    }

    public LockMode getLockMode() {
	return lockMode;
    }

    public XmlDocumentConfig setLockMode(LockMode lmode) {
	this.lockMode = lmode;
	return this;
    }

    /* package */
    int makeFlags() {
	int flags = 0;
	if (lazyDocs)
	    flags |= dbxml_javaConstants.DBXML_LAZY_DOCS;
	if (genName)
	    flags |= dbxml_javaConstants.DBXML_GEN_NAME;
	if (dirtyRead)
	    flags |= DbConstants.DB_DIRTY_READ;
	if (lockMode != null) {
	    try {
		flags |= XmlHelper.getFlag(lockMode);
	    } catch (DatabaseException e) {}
	}
	return flags;
    }

    /* Flags */
    private boolean lazyDocs = false;
    private boolean genName = false;
    private LockMode lockMode = null;
    private boolean dirtyRead = false;
}
