//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ContainerContextOptimizer.hpp,v 1.3 2005/04/05 16:44:14 bostic Exp $
//

#ifndef __CONTAINERCONTEXTOPTIMIZER_HPP
#define	__CONTAINERCONTEXTOPTIMIZER_HPP

#include "NodeVisitingOptimizer.hpp"
#include "dbxml/XmlValue.hpp"

namespace DbXml
{

class ContainerContextOptimizer : public NodeVisitingOptimizer
{
public:
  ContainerContextOptimizer(const std::string &containerName, bool documentMode,
                            DynamicContext *xpc, Optimizer *parent = 0)
    : NodeVisitingOptimizer(parent), containerURI_("dbxml:/" + containerName),
      xpc_(xpc), documentMode_(documentMode)
  {}
  virtual ~ContainerContextOptimizer() {}

protected:
  virtual DataItem *optimize(DataItem *item);
  virtual XQGlobalVariable *optimizeGlobalVar(XQGlobalVariable *item);
  virtual void resetInternal() {}

private:
  XmlValue containerURI_;
  DynamicContext *xpc_;
  bool documentMode_;
};

}

#endif
