//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ContainerContextOptimizer.cpp,v 1.5 2005/04/05 16:44:13 bostic Exp $
//

#include <pathan/dataItem/DataItemSequence.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/functions/FunctionCollection.hpp>
#include <pathan/dataItem/DataItemNav.hpp>

#include "ContainerContextOptimizer.hpp"
#include "../Value.hpp"

using namespace DbXml;
using namespace std;

XQGlobalVariable *ContainerContextOptimizer::optimizeGlobalVar(XQGlobalVariable *item)
{
  item->setVariableExpr(optimize(const_cast<DataItem *>(item->getVariableExpr())));
  return item;
}

DataItem *ContainerContextOptimizer::optimize(DataItem *item)
{
  // Make a fn:collection() object, with containerURI_ as it's argument
  DataItemSequence *dis = new (xpc_->getMemoryManager())
    DataItemSequence(Value::convertToItem(containerURI_, xpc_), xpc_, xpc_->getMemoryManager());

  VectorOfDataItems args(PathanAllocator<DataItem*>(xpc_->getMemoryManager()));
  args.push_back(dis);

  FunctionCollection *func = new (xpc_->getMemoryManager()) FunctionCollection(args, xpc_->getMemoryManager());

  if(documentMode_) {
    // Add the rest of the expression as a predicate
    DataItem::Predicates &preds = const_cast<DataItem::Predicates &>(func->getPredicates());
    preds.push_back(item);
    return func;
  }
  else {
    switch(item->getType()) {
    case DataItem::NAVIGATION: {
      // Add the rest of the expression as further steps of the existing navigation
      DataItemNav *nav = (DataItemNav *)item;
      nav->setGotoRootFirst(false);
      nav->addStepFront(func);
      return nav;
    }
    default: {
      // Add the rest of the expression as further steps of a new navigation
      DataItemNav *nav = new (xpc_->getMemoryManager()) DataItemNav(xpc_->getMemoryManager());
      nav->addStep(func);
      nav->addStep(item);
      return nav;
    }
    }
  }
}
