//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: CollectionAndDocOptimizer.hpp,v 1.6 2005/05/19 11:43:40 jsnelson Exp $
//

#ifndef __COLLECTIONANDDOCOPTIMIZER_HPP
#define	__COLLECTIONANDDOCOPTIMIZER_HPP

#include "NodeVisitingOptimizer.hpp"
#include "../ReferenceMinder.hpp"

#include <pathan/XPath2MemoryManager.hpp>

class DynamicContext;

namespace DbXml
{

class CollectionAndDocOptimizer : public NodeVisitingOptimizer
{
public:
	CollectionAndDocOptimizer(ReferenceMinder &minder, DynamicContext *xpc, Optimizer *parent = 0)
		: NodeVisitingOptimizer(parent),
		  xpc_(xpc), minder_(minder)
	{}
	virtual ~CollectionAndDocOptimizer() {}

protected:
	virtual void resetInternal()
	{
		minder_.resetMinder();
	}
	virtual DataItem *optimizeFunction(DataItemFunction *item);
	virtual DataItem *optimizeStep(DataItemStep *item);
	virtual DataItem *optimizeNav(DataItemNav *item);

private:
	DynamicContext *xpc_;
	ReferenceMinder &minder_;
};

}

#endif
