//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: CollectionAndDocOptimizer.cpp,v 1.7 2005/05/19 11:43:40 jsnelson Exp $
//

#include "dbxml/XmlPortability.hpp"
#include "CollectionAndDocOptimizer.hpp"
#include "../UTF8.hpp"
#include "../dataItem/QueryPlanFunction.hpp"
#include "../dataItem/ElementChildAxis.hpp"
#include "../dataItem/ElementDescendantAxis.hpp"
#include "../dataItem/ElementDescendantOrSelfAxis.hpp"
#include "PrintDataItemTree.hpp"

#include <pathan/functions/FunctionDoc.hpp>
#include <pathan/functions/FunctionCollection.hpp>

#include <xercesc/dom/DOMNode.hpp>
#if defined(XERCES_HAS_CPP_NAMESPACE)
XERCES_CPP_NAMESPACE_USE
#endif

using namespace DbXml;

DataItem *CollectionAndDocOptimizer::optimizeFunction(DataItemFunction *item)
{
	const XMLCh *uri = item->getFunctionURI();
	const XMLCh *name = item->getFunctionName();

	// Replace fn:doc() or fn:collection() with our fn:QueryPlanFunction()
	if(uri == DataItemFunction::XMLChFunctionURI &&
		(name == FunctionDoc::name
			|| name == FunctionCollection::name)) {

		QueryPlanFunction::Type type = 
			(name == FunctionDoc::name ? QueryPlanFunction::DOCUMENT : QueryPlanFunction::COLLECTION);
		QueryPlanFunction *result = new (xpc_->getMemoryManager()) QueryPlanFunction(minder_, type, item->getArguments(), xpc_->getMemoryManager());
		result->addPredicates(item->getPredicates());
		item = result;
	}

	return NodeVisitingOptimizer::optimizeFunction(item);
}

//imports the data in step 2 into step1
static void importStep(NavStepImpl *step1, NavStepImpl *step2)
{
	if(step2->getPrefixSet()) {
		step1->setNodePrefix(step2->getNodePrefix());
	}
	step1->setNodeUri(step2->getNodeUri());
	step1->setNodeName(step2->getNodeName());
	step1->setType(step2->getType());
	step2->setType(NULL);
	step1->setNodeType(step2->getNodeType());

	if(step2->getNameWildcard())
		step1->setNameWildcard();
	if(step2->getNamespaceWildcard())
		step1->setNamespaceWildcard();
	if(step2->getTypeWildcard())
		step1->setTypeWildcard();
}

DataItem *CollectionAndDocOptimizer::optimizeNav(DataItemNav *item)
{
	DataItemNav::Steps &args = const_cast<DataItemNav::Steps &>(item->getSteps());
	for(DataItemNav::Steps::iterator i = args.begin(); i != args.end(); ++i) {
		// Special case, to optimise //foo or //descendant::foo
		if(i->step->getType() == DataItem::STEP) {
			DataItemStep *step = (DataItemStep *)i->step;
			NavStepImpl *navstep = (NavStepImpl*)step->getNavStep();

			// Check for a descendant-or-self::node() step (equivalent to //)
			if(navstep->getAxis() == NavStepImpl::DESCENDANT_OR_SELF && navstep->getTypeWildcard() &&
				navstep->getNamespaceWildcard() && navstep->getNameWildcard() &&
				(i + 1) != args.end()) {
				// We can optimise it if its followed by a DataItemStep with an
				// axis of CHILD or DESCENDANT
				const DataItem *peek = (i + 1)->step;
				if(peek->getType() == DataItem::STEP) {
					const NavStepImpl *peeknav = ((DataItemStep*)peek)->getNavStep();
					if(peeknav->getAxis() == NavStepImpl::CHILD ||
						peeknav->getAxis() == NavStepImpl::DESCENDANT) {

						ElementDescendantOrSelfAxis *newAxis = new (xpc_->getMemoryManager()) ElementDescendantOrSelfAxis();
						importStep(newAxis, navstep);
						step->setNavStep(newAxis);
					}
				}
			}
		}

		i->step = optimize(i->step);
	}
	optimizePredicates(item);
	return item;
}

DataItem *CollectionAndDocOptimizer::optimizeStep(DataItemStep *item)
{
	NavStepImpl *navstep = (NavStepImpl*)item->getNavStep();

	if(navstep->getType() == 0 && !navstep->getTypeWildcard() &&
		navstep->getNodeType() == DOMNode::ELEMENT_NODE) {
		 
		switch(navstep->getAxis()) {
		case NavStepImpl::CHILD: {
			ElementChildAxis *newAxis = new (xpc_->getMemoryManager()) ElementChildAxis();
			importStep(newAxis, navstep);
			item->setNavStep(newAxis);
			break;
		}
		case NavStepImpl::DESCENDANT: {
			ElementDescendantAxis *newAxis = new (xpc_->getMemoryManager()) ElementDescendantAxis();
			importStep(newAxis, navstep);
			item->setNavStep(newAxis);
			break;
		}
		case NavStepImpl::DESCENDANT_OR_SELF: {
			ElementDescendantOrSelfAxis *newAxis = new (xpc_->getMemoryManager()) ElementDescendantOrSelfAxis();
			importStep(newAxis, navstep);
			item->setNavStep(newAxis);
			break;
		}
		}	
	}

	return NodeVisitingOptimizer::optimizeStep(item);
}
