//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//      Sleepycat Software.  All rights reserved.
//
// $Id: NsEventGenerator.hpp,v 1.10 2005/04/05 16:44:09 bostic Exp $
//

#ifndef __DBXMLNSEVENTGENERATOR_HPP
#define __DBXMLNSEVENTGENERATOR_HPP
	
#include <db_cxx.h>
#include "NsTypes.hpp"
#include "NsEvent.hpp"
#include "NsDocument.hpp"
#include "../ScopedDbt.hpp"

namespace DbXml
{

// forwards
class NsEventGeneratorBuf;
class NsEventHandler8;
class NsDocumentDatabase;

/**
 * NsEventGenerator
 *
 * This class generates events from a persistent NsDocument instance.
 *
 * Usage:
 *   NsEventGenerator ev(NsEventHandler8&, NsDocument &, ...);
 *   ev.start();
 *
 * There is no reset method to restart the cursor iteration.
 * It'd be easy to add.
 */
class NsEventGenerator : public NsEventSource8 {
public:
	NsEventGenerator(Transaction *txn, NsDocumentDatabase *db, const ID &docId,
			 u_int32_t flags, XER_NS MemoryManager *memManager,
			 const nid_t *startId = 0);
	virtual ~NsEventGenerator();

	virtual void start();

	virtual NsEventHandler8 *getNsEventHandler(void) const {
		return _handler;
	}
	virtual void setNsEventHandler(NsEventHandler8 *handler) {
		_handler = handler;
	}

	void start(bool oneElementOnly); // start event generation
	void stop() { _stop = true; }  // stop handling mid-stream

private:
	void _processNode(NsEventGeneratorBuf **curBuf,
			  const Dbt &data);
	void _textEvent(const nsTextList_t *text,
			uint32_t *currentText,
			uint32_t lastIndex) const;
	void _nextNode(NsEventGeneratorBuf **bufp, Dbt &data, nid_t *startId = 0);
	void _releaseNode(NsEventGeneratorBuf *buf);
	// data
	NsEventHandler8 *_handler; // TBD: utf-16 version
	NsDocument _document;
	bool _stop;
	DbtOut _docKey;
	Dbc *_cursor;
	nid_t _startId;
	// memory mgmt
	NsEventGeneratorBuf *_freeList;
};

}

#endif
