//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//      Sleepycat Software.  All rights reserved.
//
// $Id: NsDomEventSource.hpp,v 1.3 2005/04/05 16:44:08 bostic Exp $
//

#ifndef __DBXMLNSDOMEVENTSOURCE_HPP
#define __DBXMLNSDOMEVENTSOURCE_HPP
	
#include "NsEvent.hpp"

namespace DbXml
{

class NsDomElement;

/**
 * NsDomEventSource8
 *
 */
class NsDomEventSource8 : public NsEventSource8 {
public:
	NsDomEventSource8(NsDomElement *node)
		: _handler(0), _startNode(node) {}

	virtual void start();
	virtual NsEventHandler8 *getNsEventHandler(void) const {
		return _handler;
	}
	virtual void setNsEventHandler(NsEventHandler8 *handler) {
		_handler = handler;
	}

private:
	void generateElement(NsDomElement *element) const;
	void generateElementChildren(NsDomElement *element) const;
private:
	NsEventHandler8 *_handler;
	NsDomElement *_startNode;
};

}

#endif
