//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ElementDescendantOrSelfAxis.cpp,v 1.1 2005/05/19 11:03:14 jsnelson Exp $
//

#include "ElementDescendantOrSelfAxis.hpp"
#include "../nodeStore/NsXercesDom.hpp"

#include <xercesc/dom/DOMNode.hpp>
#if defined(XERCES_HAS_CPP_NAMESPACE)
XERCES_CPP_NAMESPACE_USE
#endif

using namespace DbXml;

Result ElementDescendantOrSelfAxis::createResult(DynamicContext* context) const
{
	return new ElementDescendantOrSelfAxisResult(this, context);
}

ElementDescendantOrSelfAxis::ElementDescendantOrSelfAxisResult::ElementDescendantOrSelfAxisResult(const NavStepImpl *step, DynamicContext *context)
	: AxisResult(step, context),
	  toDo_(true),
	  nscontext_(0),
	  descendant_(0)
{
}

static inline const NsDomNode *fakeDynamicCastNsDomNode(const DOMNode *node)
{
	if (!node) return 0;
	return (NsDomNode*)
		const_cast<DOMNode*>(node)->getInterface(_nsDomString);
}

static inline DOMNode *fakeDynamicCastDOMNode(NsDomNode *node)
{
	if (!node)
		return 0;

	NsNodeType_t type = node->getNsNodeType();
	switch (type) {
	case nsNodeElement: {
		return (NsXDOMElement*)node->getNsInterface("elem");
	}
	case nsNodeDocument: {
		return (NsXDOMDocument*)node->getNsInterface("document");
	}
	default: {
		NS_ASSERT(node->getNsNodeType() == nsNodeElement || node->getNsNodeType() == nsNodeDocument);	  
	}
	}

	return 0;
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *ElementDescendantOrSelfAxis::ElementDescendantOrSelfAxisResult::stepNext(DynamicContext *context)
{
	if(toDo_) {
		// initialise
		toDo_ = false;

		if(contextNode_->getNodeType() == DOMNode::ELEMENT_NODE ||
			contextNode_->getNodeType() == DOMNode::DOCUMENT_NODE) {
			nscontext_ = (NsDomElement*)const_cast<NsDomNode*>(fakeDynamicCastNsDomNode(contextNode_));
			descendant_ = nscontext_;
		}
	}
	else if(descendant_ != 0) {
		NsDomElement *result = descendant_->getElemFirstChild();

		while(result == 0 && descendant_ != nscontext_) {
			result = descendant_->getElemNext();
			if(result == 0) {
				descendant_ = descendant_->getElemParent();
			}
		}

		descendant_ = result;
	}

	return fakeDynamicCastDOMNode(descendant_);
}

