//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ElementDescendantAxis.hpp,v 1.1 2005/05/19 11:03:14 jsnelson Exp $
//

#ifndef __ELEMENTDESCENDANTAXIS_HPP
#define	__ELEMENTDESCENDANTAXIS_HPP

#include <pathan/internal/navigation/ForwardAxis.hpp>

namespace DbXml
{

class NsDomElement;

class ElementDescendantAxis : public ForwardAxis
{
public:
	virtual Axis getAxis() const {
		return NavStepImpl::DESCENDANT_OR_SELF;
	}
protected:
	virtual Result createResult(DynamicContext* context) const;

	class ElementDescendantAxisResult : public NavStepImpl::AxisResult
	{
	public:
		ElementDescendantAxisResult(const NavStepImpl *step, DynamicContext *context);
		const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
	private:
		bool toDo_;
		NsDomElement *nscontext_;
		NsDomElement *descendant_;
	};
};

}

#endif
