//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ElementDescendantAxis.cpp,v 1.1 2005/05/19 11:03:14 jsnelson Exp $
//

#include "ElementDescendantAxis.hpp"
#include "../nodeStore/NsXercesDom.hpp"

#include <xercesc/dom/DOMNode.hpp>
#if defined(XERCES_HAS_CPP_NAMESPACE)
XERCES_CPP_NAMESPACE_USE
#endif

using namespace DbXml;

Result ElementDescendantAxis::createResult(DynamicContext* context) const
{
	return new ElementDescendantAxisResult(this, context);
}

ElementDescendantAxis::ElementDescendantAxisResult::ElementDescendantAxisResult(const NavStepImpl *step, DynamicContext *context)
	: AxisResult(step, context),
	  toDo_(true),
	  nscontext_(0),
	  descendant_(0)
{
}

static inline const NsDomNode *fakeDynamicCastNsDomNode(const DOMNode *node)
{
	if (!node) return 0;
	return (NsDomNode*)
		const_cast<DOMNode*>(node)->getInterface(_nsDomString);
}

static inline DOMElement *fakeDynamicCastDOMElement(NsDomNode *node)
{
	if (!node)
		return 0;

	NS_ASSERT(node->getNsNodeType() == nsNodeElement)
		NsXDOMElement *el =
		(NsXDOMElement*)node->getNsInterface("elem");
	return el;
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *ElementDescendantAxis::ElementDescendantAxisResult::stepNext(DynamicContext *context)
{
	if(toDo_) {
		// initialise
		toDo_ = false;

		if(contextNode_->getNodeType() == DOMNode::ELEMENT_NODE ||
			contextNode_->getNodeType() == DOMNode::DOCUMENT_NODE) {

			nscontext_ = (NsDomElement*)const_cast<NsDomNode*>(fakeDynamicCastNsDomNode(contextNode_));
			descendant_ = nscontext_->getElemFirstChild();
		}
	}
	else if(descendant_ != 0) {
		NsDomElement *result = descendant_->getElemFirstChild();

		while(result == 0) {
			result = descendant_->getElemNext();
			if(result == 0) {
				descendant_ = descendant_->getElemParent();
				if(descendant_ == nscontext_) break;
			}
		}

		descendant_ = result;
	}

	return fakeDynamicCastDOMElement(descendant_);
}

