//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ElementChildAxis.hpp,v 1.1 2005/05/19 11:03:14 jsnelson Exp $
//

#ifndef __ELEMENTCHILDAXIS_HPP
#define	__ELEMENTCHILDAXIS_HPP

#include <pathan/internal/navigation/ForwardAxis.hpp>

namespace DbXml
{

class NsDomElement;

class ElementChildAxis : public ForwardAxis
{
public:
	virtual Axis getAxis() const {
		return NavStepImpl::CHILD;
	}
protected:
	virtual Result createResult(DynamicContext* context) const;

	class ElementChildAxisResult : public NavStepImpl::AxisResult
	{
	public:
		ElementChildAxisResult(const NavStepImpl *step, DynamicContext *context);
		const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
	private:
		bool toDo_;
		NsDomElement *child_;
	};
};

}

#endif
