//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ElementChildAxis.cpp,v 1.1 2005/05/19 11:03:14 jsnelson Exp $
//

#include "ElementChildAxis.hpp"
#include "../nodeStore/NsXercesDom.hpp"

#include <xercesc/dom/DOMNode.hpp>
#if defined(XERCES_HAS_CPP_NAMESPACE)
XERCES_CPP_NAMESPACE_USE
#endif

using namespace DbXml;

Result ElementChildAxis::createResult(DynamicContext* context) const
{
	return new ElementChildAxisResult(this, context);
}

ElementChildAxis::ElementChildAxisResult::ElementChildAxisResult(const NavStepImpl *step, DynamicContext *context)
	: AxisResult(step, context),
	  toDo_(true),
	  child_(0)
{
}

static inline const NsDomNode *fakeDynamicCastNsDomNode(const DOMNode *node)
{
	if (!node) return 0;
	return (NsDomNode*)
		const_cast<DOMNode*>(node)->getInterface(_nsDomString);
}

static inline DOMElement *fakeDynamicCastDOMElement(NsDomNode *node)
{
	if (!node)
		return 0;

	NS_ASSERT(node->getNsNodeType() == nsNodeElement)
		NsXDOMElement *el =
		(NsXDOMElement*)node->getNsInterface("elem");
	return el;
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *ElementChildAxis::ElementChildAxisResult::stepNext(DynamicContext *context)
{
	if(toDo_) {
		// initialise
		toDo_ = false;

		if(contextNode_->getNodeType() == DOMNode::ELEMENT_NODE ||
			contextNode_->getNodeType() == DOMNode::DOCUMENT_NODE) {

			NsDomNode *nsnode = const_cast<NsDomNode*>(fakeDynamicCastNsDomNode(contextNode_));
			child_ = ((NsDomElement*)nsnode)->getElemFirstChild();
		}
	}
	else if(child_ != 0) {
		child_ = child_->getElemNext();
	}

	return fakeDynamicCastDOMElement(child_);
}

