//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: DbXmlContext.hpp,v 1.5 2005/04/05 16:44:04 bostic Exp $
//

#ifndef __DBXMLCONTEXT_HPP
#define	__DBXMLCONTEXT_HPP

#include <xquery/XQContext.hpp>
#include "DbXmlURIResolver.hpp"
#include "../QueryContext.hpp"

#define CAST_TO_CONST_DBXMLCONTEXT(x) (static_cast<const DbXmlContext*>(x))
#define CAST_TO_DBXMLCONTEXT(x) (static_cast<DbXmlContext*>(x))

namespace DbXml
{

class DbXmlContext : public XQContext
{
public:
	DbXmlContext(QueryContext &qc, Transaction *txn)
		: qc_(&qc), resolver_(qc.getManager(), txn) {}
	virtual ~DbXmlContext() {}

	QueryContext &getQueryContext() const { return *qc_; }
	void setQueryContext(QueryContext &qc) { qc_ = &qc; }
	void setTransaction(Transaction *txn) {
		resolver_.setTransaction(txn);
	}

	// these are required by DynamicContext (pathan)
	virtual void trace(const XMLCh* message1, const XMLCh* message2);

protected:
	QueryContext *qc_;
	DbXmlURIResolver resolver_;
};

}

#endif
